/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.cube.model;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.annotation.Nullable;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.KylinConfigExt;
import org.apache.kylin.common.KylinVersion;
import org.apache.kylin.common.persistence.RootPersistentEntity;
import org.apache.kylin.common.util.Array;
import org.apache.kylin.common.util.CaseInsensitiveStringMap;
import org.apache.kylin.common.util.JsonUtil;
import org.apache.kylin.cube.model.AggregationGroup;
import org.apache.kylin.cube.model.DimensionDesc;
import org.apache.kylin.cube.model.HBaseColumnDesc;
import org.apache.kylin.cube.model.HBaseColumnFamilyDesc;
import org.apache.kylin.cube.model.HBaseMappingDesc;
import org.apache.kylin.cube.model.RowKeyColDesc;
import org.apache.kylin.cube.model.RowKeyDesc;
import org.apache.kylin.measure.MeasureType;
import org.apache.kylin.measure.extendedcolumn.ExtendedColumnMeasureType;
import org.apache.kylin.metadata.MetadataManager;
import org.apache.kylin.metadata.model.ColumnDesc;
import org.apache.kylin.metadata.model.DataModelDesc;
import org.apache.kylin.metadata.model.FunctionDesc;
import org.apache.kylin.metadata.model.JoinDesc;
import org.apache.kylin.metadata.model.MeasureDesc;
import org.apache.kylin.metadata.model.TableDesc;
import org.apache.kylin.metadata.model.TblColRef;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE, getterVisibility=JsonAutoDetect.Visibility.NONE, isGetterVisibility=JsonAutoDetect.Visibility.NONE, setterVisibility=JsonAutoDetect.Visibility.NONE)
public class CubeDesc
extends RootPersistentEntity {
    private static final Logger logger = LoggerFactory.getLogger(CubeDesc.class);
    private KylinConfigExt config;
    private DataModelDesc model;
    @JsonProperty(value="name")
    private String name;
    @JsonProperty(value="model_name")
    private String modelName;
    @JsonProperty(value="description")
    private String description;
    @JsonProperty(value="null_string")
    private String[] nullStrings;
    @JsonProperty(value="dimensions")
    private List<DimensionDesc> dimensions;
    @JsonProperty(value="measures")
    private List<MeasureDesc> measures;
    @JsonProperty(value="rowkey")
    private RowKeyDesc rowkey;
    @JsonProperty(value="hbase_mapping")
    private HBaseMappingDesc hbaseMapping;
    @JsonProperty(value="aggregation_groups")
    private List<AggregationGroup> aggregationGroups;
    @JsonProperty(value="signature")
    private String signature;
    @JsonProperty(value="notify_list")
    private List<String> notifyList;
    @JsonProperty(value="status_need_notify")
    private List<String> statusNeedNotify = Collections.emptyList();
    @JsonProperty(value="partition_date_start")
    private long partitionDateStart = 0L;
    @JsonProperty(value="partition_date_end")
    private long partitionDateEnd = 3153600000000L;
    @JsonProperty(value="auto_merge_time_ranges")
    private long[] autoMergeTimeRanges;
    @JsonProperty(value="retention_range")
    private long retentionRange = 0L;
    @JsonProperty(value="engine_type")
    private int engineType = 0;
    @JsonProperty(value="storage_type")
    private int storageType = 0;
    @JsonProperty(value="override_kylin_properties")
    private LinkedHashMap<String, String> overrideKylinProps = new LinkedHashMap();
    private Map<String, Map<String, TblColRef>> columnMap = new HashMap<String, Map<String, TblColRef>>();
    private LinkedHashSet<TblColRef> allColumns = new LinkedHashSet();
    private LinkedHashSet<TblColRef> dimensionColumns = new LinkedHashSet();
    private Map<TblColRef, DeriveInfo> derivedToHostMap = Maps.newHashMap();
    private Map<Array<TblColRef>, List<DeriveInfo>> hostToDerivedMap = Maps.newHashMap();
    private Map<TblColRef, DeriveInfo> extendedColumnToHosts = Maps.newHashMap();
    private List<String> errors = new ArrayList<String>();

    public boolean isEnableSharding() {
        return this.storageType == 2;
    }

    public Set<TblColRef> getShardByColumns() {
        return this.getRowkey().getShardByColumns();
    }

    public Set<TblColRef> listAllColumns() {
        return this.allColumns;
    }

    public Set<TblColRef> listDimensionColumnsIncludingDerived() {
        return this.dimensionColumns;
    }

    public List<TblColRef> listDimensionColumnsExcludingDerived(boolean alsoExcludeExtendedCol) {
        ArrayList<TblColRef> result = new ArrayList<TblColRef>();
        for (TblColRef col : this.dimensionColumns) {
            if (this.isDerived(col) || alsoExcludeExtendedCol && this.isExtendedColumn(col)) continue;
            result.add(col);
        }
        return result;
    }

    public List<FunctionDesc> listAllFunctions() {
        ArrayList<FunctionDesc> functions = new ArrayList<FunctionDesc>();
        for (MeasureDesc m : this.measures) {
            functions.add(m.getFunction());
        }
        return functions;
    }

    public TblColRef findColumnRef(String table, String column) {
        Map<String, TblColRef> cols = this.columnMap.get(table);
        if (cols == null) {
            return null;
        }
        return cols.get(column);
    }

    public DimensionDesc findDimensionByTable(String lookupTableName) {
        lookupTableName = lookupTableName.toUpperCase();
        for (DimensionDesc dim : this.dimensions) {
            if (dim.getTable() == null || !dim.getTable().equals(lookupTableName)) continue;
            return dim;
        }
        return null;
    }

    public boolean hasHostColumn(TblColRef col) {
        return this.isDerived(col) || this.isExtendedColumn(col);
    }

    public boolean isDerived(TblColRef col) {
        return this.derivedToHostMap.containsKey(col);
    }

    public boolean isExtendedColumn(TblColRef col) {
        return this.extendedColumnToHosts.containsKey(col);
    }

    public DeriveInfo getHostInfo(TblColRef derived) {
        if (this.isDerived(derived)) {
            return this.derivedToHostMap.get(derived);
        }
        if (this.isExtendedColumn(derived)) {
            return this.extendedColumnToHosts.get(derived);
        }
        throw new RuntimeException("Cannot get host info for " + derived);
    }

    public Map<Array<TblColRef>, List<DeriveInfo>> getHostToDerivedInfo(List<TblColRef> rowCols, Collection<TblColRef> wantedCols) {
        HashMap<Array<TblColRef>, List<DeriveInfo>> result = new HashMap<Array<TblColRef>, List<DeriveInfo>>();
        for (Map.Entry<Array<TblColRef>, List<DeriveInfo>> entry : this.hostToDerivedMap.entrySet()) {
            Array<TblColRef> hostCols = entry.getKey();
            boolean hostOnRow = rowCols.containsAll(Arrays.asList(hostCols.data));
            if (!hostOnRow) continue;
            ArrayList<DeriveInfo> wantedInfo = new ArrayList<DeriveInfo>();
            for (DeriveInfo info : entry.getValue()) {
                if (wantedCols != null && Collections.disjoint(wantedCols, Arrays.asList(info.columns))) continue;
                wantedInfo.add(info);
            }
            if (wantedInfo.size() <= 0) continue;
            result.put(hostCols, wantedInfo);
        }
        return result;
    }

    public String getResourcePath() {
        return CubeDesc.concatResourcePath(this.name);
    }

    public static String concatResourcePath(String descName) {
        return "/cube_desc/" + descName + ".json";
    }

    public KylinConfig getConfig() {
        return this.config;
    }

    private void setConfig(KylinConfigExt config) {
        this.config = config;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getModelName() {
        return this.modelName;
    }

    public void setModelName(String modelName) {
        this.modelName = modelName;
    }

    public DataModelDesc getModel() {
        return this.model;
    }

    public void setModel(DataModelDesc model) {
        this.model = model;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getFactTable() {
        return this.model.getFactTable();
    }

    public TableDesc getFactTableDesc() {
        return this.model.getFactTableDesc();
    }

    public List<TableDesc> getLookupTableDescs() {
        return this.model.getLookupTableDescs();
    }

    public String[] getNullStrings() {
        return this.nullStrings;
    }

    public List<DimensionDesc> getDimensions() {
        return this.dimensions;
    }

    public void setDimensions(List<DimensionDesc> dimensions) {
        this.dimensions = dimensions;
    }

    public List<MeasureDesc> getMeasures() {
        return this.measures;
    }

    public void setMeasures(List<MeasureDesc> measures) {
        this.measures = measures;
    }

    public RowKeyDesc getRowkey() {
        return this.rowkey;
    }

    public void setRowkey(RowKeyDesc rowkey) {
        this.rowkey = rowkey;
    }

    public List<AggregationGroup> getAggregationGroups() {
        return this.aggregationGroups;
    }

    public void setAggregationGroups(List<AggregationGroup> aggregationGroups) {
        this.aggregationGroups = aggregationGroups;
    }

    public String getSignature() {
        return this.signature;
    }

    public void setSignature(String signature) {
        this.signature = signature;
    }

    public List<String> getNotifyList() {
        return this.notifyList;
    }

    public void setNotifyList(List<String> notifyList) {
        this.notifyList = notifyList;
    }

    public List<String> getStatusNeedNotify() {
        return this.statusNeedNotify;
    }

    public void setStatusNeedNotify(List<String> statusNeedNotify) {
        this.statusNeedNotify = statusNeedNotify;
    }

    public LinkedHashMap<String, String> getOverrideKylinProps() {
        return this.overrideKylinProps;
    }

    private void setOverrideKylinProps(LinkedHashMap<String, String> overrideKylinProps) {
        this.overrideKylinProps = overrideKylinProps;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CubeDesc cubeDesc = (CubeDesc)o;
        if (!this.name.equals(cubeDesc.name)) {
            return false;
        }
        return this.getFactTable().equals(cubeDesc.getFactTable());
    }

    public int getBuildLevel() {
        return (Integer)Collections.max(Collections2.transform(this.aggregationGroups, (Function)new Function<AggregationGroup, Integer>(){

            @Nullable
            public Integer apply(AggregationGroup input) {
                return input.getBuildLevel();
            }
        }));
    }

    @Override
    public int hashCode() {
        int result = 0;
        result = 31 * result + this.name.hashCode();
        result = 31 * result + this.getFactTable().hashCode();
        return result;
    }

    public String toString() {
        return "CubeDesc [name=" + this.name + "]";
    }

    public boolean checkSignature() {
        if (KylinVersion.getCurrentVersion().isCompatibleWith(new KylinVersion(this.getVersion())) && !KylinVersion.getCurrentVersion().isSignatureCompatibleWith(new KylinVersion(this.getVersion()))) {
            logger.info("checkSignature on {} is skipped as the its version is {} (not signature compatible but compatible) ", (Object)this.getName(), (Object)this.getVersion());
            return true;
        }
        if (StringUtils.isBlank((String)this.getSignature())) {
            return true;
        }
        String calculated = this.calculateSignature();
        String saved = this.getSignature();
        return calculated.equals(saved);
    }

    public boolean consistentWith(CubeDesc another) {
        if (another == null) {
            return false;
        }
        return this.calculateSignature().equals(another.calculateSignature());
    }

    public String calculateSignature() {
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            StringBuilder sigString = new StringBuilder();
            sigString.append(this.name).append("|").append(JsonUtil.writeValueAsString(this.modelName)).append("|").append(JsonUtil.writeValueAsString(this.nullStrings)).append("|").append(JsonUtil.writeValueAsString(this.dimensions)).append("|").append(JsonUtil.writeValueAsString(this.measures)).append("|").append(JsonUtil.writeValueAsString(this.rowkey)).append("|").append(JsonUtil.writeValueAsString(this.aggregationGroups)).append("|").append(JsonUtil.writeValueAsString(this.hbaseMapping)).append("|").append(JsonUtil.writeValueAsString(this.engineType)).append("|").append(JsonUtil.writeValueAsString(this.storageType)).append("|");
            String signatureInput = sigString.toString().replaceAll("\\s+", "").toLowerCase();
            byte[] signature = md.digest(signatureInput.getBytes());
            String ret = new String(Base64.encodeBase64((byte[])signature));
            return ret;
        }
        catch (JsonProcessingException | NoSuchAlgorithmException e) {
            throw new RuntimeException("Failed to calculate signature");
        }
    }

    public Map<String, TblColRef> buildColumnNameAbbreviation() {
        CaseInsensitiveStringMap<TblColRef> r = new CaseInsensitiveStringMap<TblColRef>();
        for (TblColRef col : this.listDimensionColumnsExcludingDerived(true)) {
            r.put(col.getName(), col);
        }
        return r;
    }

    public void init(KylinConfig config, Map<String, TableDesc> tables) {
        this.errors.clear();
        this.config = KylinConfigExt.createInstance(config, this.overrideKylinProps);
        if (this.modelName == null || this.modelName.length() == 0) {
            this.addError("The cubeDesc '" + this.getName() + "' doesn't have data model specified.");
        }
        this.validate();
        this.model = MetadataManager.getInstance(config).getDataModelDesc(this.modelName);
        if (this.model == null) {
            this.addError("No data model found with name '" + this.modelName + "'.");
        }
        for (DimensionDesc dim : this.dimensions) {
            dim.init(this, tables);
        }
        this.initDimensionColumns();
        this.initMeasureColumns();
        this.rowkey.init(this);
        for (AggregationGroup agg : this.aggregationGroups) {
            agg.init(this, this.rowkey);
        }
        if (this.hbaseMapping != null) {
            this.hbaseMapping.init(this);
        }
        this.initMeasureReferenceToColumnFamily();
        List<TblColRef> dimCols = this.listDimensionColumnsExcludingDerived(true);
        if (this.rowkey.getRowKeyColumns().length != dimCols.size()) {
            this.addError("RowKey columns count (" + this.rowkey.getRowKeyColumns().length + ") does not match dimension columns count (" + dimCols.size() + "). ");
        }
    }

    public void validate() {
        int index = 0;
        for (AggregationGroup agg : this.getAggregationGroups()) {
            if (agg.getIncludes() == null) {
                logger.error("Aggregation group " + index + " 'includes' field not set");
                throw new IllegalStateException("Aggregation group " + index + " includes field not set");
            }
            if (agg.getSelectRule() == null) {
                logger.error("Aggregation group " + index + " 'select_rule' field not set");
                throw new IllegalStateException("Aggregation group " + index + " select rule field not set");
            }
            int combination = 1;
            TreeSet<String> includeDims = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
            this.getDims(includeDims, agg.getIncludes());
            TreeSet<String> mandatoryDims = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
            this.getDims(mandatoryDims, agg.getSelectRule().mandatory_dims);
            ArrayList hierarchyDimsList = Lists.newArrayList();
            TreeSet<String> hierarchyDims = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
            this.getDims(hierarchyDimsList, hierarchyDims, agg.getSelectRule().hierarchy_dims);
            for (Set hierarchy : hierarchyDimsList) {
                combination *= hierarchy.size() + 1;
            }
            ArrayList jointDimsList = Lists.newArrayList();
            TreeSet<String> jointDims = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
            this.getDims(jointDimsList, jointDims, agg.getSelectRule().joint_dims);
            if (jointDimsList.size() > 0) {
                combination *= 1 << jointDimsList.size();
            }
            if (!(includeDims.containsAll(mandatoryDims) && includeDims.containsAll(hierarchyDims) && includeDims.containsAll(jointDims))) {
                logger.error("Aggregation group " + index + " Include dims not containing all the used dims");
                throw new IllegalStateException("Aggregation group " + index + " Include dims not containing all the used dims");
            }
            TreeSet<String> normalDims = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
            normalDims.addAll(includeDims);
            normalDims.removeAll(mandatoryDims);
            normalDims.removeAll(hierarchyDims);
            normalDims.removeAll(jointDims);
            if ((combination *= 1 << normalDims.size()) > this.config.getCubeAggrGroupMaxCombination()) {
                String msg = "Aggregation group " + index + " has too many combinations, use 'mandatory'/'hierarchy'/'joint' to optimize; or update 'kylin.cube.aggrgroup.max.combination' to a bigger value.";
                logger.error("Aggregation group " + index + " has " + combination + " combinations;");
                logger.error(msg);
                throw new IllegalStateException(msg);
            }
            if (CollectionUtils.containsAny(mandatoryDims, hierarchyDims)) {
                logger.warn("Aggregation group " + index + " mandatory dims overlap with hierarchy dims");
            }
            if (CollectionUtils.containsAny(mandatoryDims, jointDims)) {
                logger.warn("Aggregation group " + index + " mandatory dims overlap with joint dims");
            }
            if (CollectionUtils.containsAny(hierarchyDims, jointDims)) {
                logger.error("Aggregation group " + index + " hierarchy dims overlap with joint dims");
                throw new IllegalStateException("Aggregation group " + index + " hierarchy dims overlap with joint dims");
            }
            if (this.hasSingle(hierarchyDimsList)) {
                logger.error("Aggregation group " + index + " require at least 2 dims in a hierarchy");
                throw new IllegalStateException("Aggregation group " + index + " require at least 2 dims in a hierarchy");
            }
            if (this.hasSingle(jointDimsList)) {
                logger.error("Aggregation group " + index + " require at least 2 dims in a joint");
                throw new IllegalStateException("Aggregation group " + index + " require at least 2 dims in a joint");
            }
            if (this.hasOverlap(hierarchyDimsList, hierarchyDims)) {
                logger.error("Aggregation group " + index + " a dim exist in more than one hierarchy");
                throw new IllegalStateException("Aggregation group " + index + " a dim exist in more than one hierarchy");
            }
            if (this.hasOverlap(jointDimsList, jointDims)) {
                logger.error("Aggregation group " + index + " a dim exist in more than one joint");
                throw new IllegalStateException("Aggregation group " + index + " a dim exist in more than one joint");
            }
            ++index;
        }
    }

    private void getDims(Set<String> dims, String[] stringSet) {
        if (stringSet != null) {
            for (String str : stringSet) {
                dims.add(str);
            }
        }
    }

    private void getDims(ArrayList<Set<String>> dimsList, Set<String> dims, String[][] stringSets) {
        if (stringSets != null) {
            for (String[] ss : stringSets) {
                TreeSet<String> temp = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
                for (String s : ss) {
                    temp.add(s);
                    dims.add(s);
                }
                dimsList.add(temp);
            }
        }
    }

    private boolean hasSingle(ArrayList<Set<String>> dimsList) {
        boolean hasSingle = false;
        for (Set<String> dims : dimsList) {
            if (dims.size() >= 2) continue;
            hasSingle = true;
        }
        return hasSingle;
    }

    private boolean hasOverlap(ArrayList<Set<String>> dimsList, Set<String> Dims) {
        boolean hasOverlap = false;
        int dimSize = 0;
        for (Set<String> dims : dimsList) {
            dimSize += dims.size();
        }
        if (dimSize != Dims.size()) {
            hasOverlap = true;
        }
        return hasOverlap;
    }

    private void initDimensionColumns() {
        for (DimensionDesc dim : this.dimensions) {
            JoinDesc join = dim.getJoin();
            ArrayList dimCols = Lists.newArrayList();
            String colStrs = dim.getColumn();
            if (colStrs == null && dim.isDerived() || "{FK}".equalsIgnoreCase(colStrs)) {
                for (TblColRef col : join.getForeignKeyColumns()) {
                    dimCols.add(this.initDimensionColRef(col));
                }
            } else {
                if (StringUtils.isEmpty((String)colStrs)) {
                    throw new IllegalStateException("Dimension column must not be blank " + dim);
                }
                dimCols.add(this.initDimensionColRef(dim, colStrs));
            }
            Object[] dimColArray = dimCols.toArray(new TblColRef[dimCols.size()]);
            dim.setColumnRefs((TblColRef[])dimColArray);
            if (dim.isDerived()) {
                String[] derived = dim.getDerived();
                String[][] split = this.splitDerivedColumnAndExtra(derived);
                String[] derivedNames = split[0];
                String[] derivedExtra = split[1];
                TblColRef[] derivedCols = new TblColRef[derivedNames.length];
                for (int i = 0; i < derivedNames.length; ++i) {
                    derivedCols[i] = this.initDimensionColRef(dim, derivedNames[i]);
                }
                this.initDerivedMap((TblColRef[])dimColArray, DeriveType.LOOKUP, dim, derivedCols, derivedExtra);
            }
            if (join == null) continue;
            TblColRef[] fk = join.getForeignKeyColumns();
            TblColRef[] pk = join.getPrimaryKeyColumns();
            this.allColumns.addAll(Arrays.asList(fk));
            this.allColumns.addAll(Arrays.asList(pk));
            for (int i = 0; i < fk.length; ++i) {
                int find = ArrayUtils.indexOf((Object[])dimColArray, (Object)fk[i]);
                if (find < 0) continue;
                TblColRef derivedCol = this.initDimensionColRef(pk[i]);
                this.initDerivedMap(new TblColRef[]{dimColArray[find]}, DeriveType.PK_FK, dim, new TblColRef[]{derivedCol}, null);
            }
        }
    }

    private String[][] splitDerivedColumnAndExtra(String[] derived) {
        String[] cols = new String[derived.length];
        String[] extra = new String[derived.length];
        for (int i = 0; i < derived.length; ++i) {
            String str = derived[i];
            int cut = str.indexOf(":");
            if (cut >= 0) {
                cols[i] = str.substring(0, cut);
                extra[i] = str.substring(cut + 1).trim();
                continue;
            }
            cols[i] = str;
            extra[i] = "";
        }
        return new String[][]{cols, extra};
    }

    private void initDerivedMap(TblColRef[] hostCols, DeriveType type, DimensionDesc dimension, TblColRef[] derivedCols, String[] extra) {
        if (hostCols.length == 0 || derivedCols.length == 0) {
            throw new IllegalStateException("host/derived columns must not be empty");
        }
        for (int i = 0; i < derivedCols.length; ++i) {
            if (!ArrayUtils.contains((Object[])hostCols, (Object)derivedCols[i])) continue;
            derivedCols = (TblColRef[])ArrayUtils.remove((Object[])derivedCols, (int)i);
            extra = (String[])ArrayUtils.remove((Object[])extra, (int)i);
            --i;
        }
        Map<TblColRef, DeriveInfo> toHostMap = this.derivedToHostMap;
        Map<Array<TblColRef>, List<DeriveInfo>> hostToMap = this.hostToDerivedMap;
        Array<TblColRef> hostColArray = new Array<TblColRef>(hostCols);
        List<DeriveInfo> infoList = hostToMap.get(hostColArray);
        if (infoList == null) {
            infoList = new ArrayList<DeriveInfo>();
            hostToMap.put(hostColArray, infoList);
        }
        infoList.add(new DeriveInfo(type, dimension, derivedCols, false));
        for (int i = 0; i < derivedCols.length; ++i) {
            TblColRef derivedCol = derivedCols[i];
            boolean isOneToOne = type == DeriveType.PK_FK || ArrayUtils.contains((Object[])hostCols, (Object)derivedCol) || extra != null && extra[i].contains("1-1");
            toHostMap.put(derivedCol, new DeriveInfo(type, dimension, hostCols, isOneToOne));
        }
    }

    private TblColRef initDimensionColRef(DimensionDesc dim, String colName) {
        int idx;
        TableDesc table = dim.getTableDesc();
        ColumnDesc col = table.findColumnByName(colName);
        if (col == null) {
            throw new IllegalArgumentException("No column '" + colName + "' found in table " + table);
        }
        TblColRef ref = new TblColRef(col);
        JoinDesc join = dim.getJoin();
        if (join != null && (idx = ArrayUtils.indexOf((Object[])join.getPrimaryKeyColumns(), (Object)ref)) >= 0) {
            ref = join.getForeignKeyColumns()[idx];
        }
        return this.initDimensionColRef(ref);
    }

    private TblColRef initDimensionColRef(TblColRef ref) {
        TblColRef existing = this.findColumnRef(ref.getTable(), ref.getName());
        if (existing != null) {
            return existing;
        }
        this.allColumns.add(ref);
        this.dimensionColumns.add(ref);
        Map<String, TblColRef> cols = this.columnMap.get(ref.getTable());
        if (cols == null) {
            cols = new HashMap<String, TblColRef>();
            this.columnMap.put(ref.getTable(), cols);
        }
        cols.put(ref.getName(), ref);
        return ref;
    }

    private void initMeasureColumns() {
        if (this.measures == null || this.measures.isEmpty()) {
            return;
        }
        TableDesc factTable = this.getFactTableDesc();
        List<TableDesc> lookupTables = this.getLookupTableDescs();
        for (MeasureDesc m : this.measures) {
            m.setName(m.getName().toUpperCase());
            if (m.getDependentMeasureRef() != null) {
                m.setDependentMeasureRef(m.getDependentMeasureRef().toUpperCase());
            }
            FunctionDesc func = m.getFunction();
            func.init(factTable, lookupTables);
            this.allColumns.addAll(func.getParameter().getColRefs());
            if (!"EXTENDED_COLUMN".equalsIgnoreCase(m.getFunction().getExpression())) continue;
            FunctionDesc functionDesc = m.getFunction();
            List<TblColRef> hosts = ExtendedColumnMeasureType.getExtendedColumnHosts(functionDesc);
            TblColRef extendedColumn = ExtendedColumnMeasureType.getExtendedColumn(functionDesc);
            this.initExtendedColumnMap(hosts.toArray(new TblColRef[hosts.size()]), extendedColumn);
        }
    }

    private void initExtendedColumnMap(TblColRef[] hostCols, TblColRef extendedColumn) {
        this.extendedColumnToHosts.put(extendedColumn, new DeriveInfo(DeriveType.EXTENDED_COLUMN, null, hostCols, false));
    }

    private void initMeasureReferenceToColumnFamily() {
        if (this.measures == null || this.measures.size() == 0) {
            return;
        }
        HashMap<String, MeasureDesc> measureLookup = new HashMap<String, MeasureDesc>();
        for (MeasureDesc m : this.measures) {
            measureLookup.put(m.getName(), m);
        }
        HashMap<String, Integer> measureIndexLookup = new HashMap<String, Integer>();
        for (int i = 0; i < this.measures.size(); ++i) {
            measureIndexLookup.put(this.measures.get(i).getName(), i);
        }
        for (HBaseColumnFamilyDesc cf : this.getHbaseMapping().getColumnFamily()) {
            for (HBaseColumnDesc c : cf.getColumns()) {
                String[] colMeasureRefs = c.getMeasureRefs();
                MeasureDesc[] measureDescs = new MeasureDesc[colMeasureRefs.length];
                int[] measureIndex = new int[colMeasureRefs.length];
                for (int i = 0; i < colMeasureRefs.length; ++i) {
                    measureDescs[i] = (MeasureDesc)measureLookup.get(colMeasureRefs[i]);
                    measureIndex[i] = (Integer)measureIndexLookup.get(colMeasureRefs[i]);
                }
                c.setMeasures(measureDescs);
                c.setMeasureIndex(measureIndex);
                c.setColumnFamilyName(cf.getName());
            }
        }
    }

    public TblColRef getColumnByBitIndex(int bitIndex) {
        RowKeyColDesc[] rowKeyColumns = this.getRowkey().getRowKeyColumns();
        return rowKeyColumns[rowKeyColumns.length - 1 - bitIndex].getColRef();
    }

    public boolean hasMemoryHungryMeasures() {
        for (MeasureDesc measure : this.measures) {
            if (!measure.getFunction().getMeasureType().isMemoryHungry()) continue;
            return true;
        }
        return false;
    }

    public long getRetentionRange() {
        return this.retentionRange;
    }

    public void setRetentionRange(long retentionRange) {
        this.retentionRange = retentionRange;
    }

    public long[] getAutoMergeTimeRanges() {
        return this.autoMergeTimeRanges;
    }

    public void setAutoMergeTimeRanges(long[] autoMergeTimeRanges) {
        this.autoMergeTimeRanges = autoMergeTimeRanges;
    }

    public void addError(String message) {
        this.addError(message, false);
    }

    public void addError(String message, boolean silent) {
        if (!silent) {
            throw new IllegalStateException(message);
        }
        this.errors.add(message);
    }

    public List<String> getError() {
        return this.errors;
    }

    public HBaseMappingDesc getHbaseMapping() {
        return this.hbaseMapping;
    }

    public void setHbaseMapping(HBaseMappingDesc hbaseMapping) {
        this.hbaseMapping = hbaseMapping;
    }

    public void setNullStrings(String[] nullStrings) {
        this.nullStrings = nullStrings;
    }

    public int getStorageType() {
        return this.storageType;
    }

    public void setStorageType(int storageType) {
        this.storageType = storageType;
    }

    public int getEngineType() {
        return this.engineType;
    }

    public void setEngineType(int engineType) {
        this.engineType = engineType;
    }

    public long getPartitionDateStart() {
        return this.partitionDateStart;
    }

    public void setPartitionDateStart(long partitionDateStart) {
        this.partitionDateStart = partitionDateStart;
    }

    public long getPartitionDateEnd() {
        return this.partitionDateEnd;
    }

    public void setPartitionDateEnd(long partitionDateEnd) {
        this.partitionDateEnd = partitionDateEnd;
    }

    public List<TblColRef> getAllColumnsNeedDictionary() {
        ArrayList result = Lists.newArrayList();
        for (RowKeyColDesc rowKeyColDesc : this.rowkey.getRowKeyColumns()) {
            TblColRef colRef = rowKeyColDesc.getColRef();
            if (!this.rowkey.isUseDictionary(colRef)) continue;
            result.add(colRef);
        }
        for (MeasureDesc measure : this.measures) {
            MeasureType<?> aggrType = measure.getFunction().getMeasureType();
            result.addAll(aggrType.getColumnsNeedDictionary(measure.getFunction()));
        }
        return result;
    }

    public static CubeDesc getCopyOf(CubeDesc cubeDesc) {
        CubeDesc newCubeDesc = new CubeDesc();
        newCubeDesc.setName(cubeDesc.getName());
        newCubeDesc.setModelName(cubeDesc.getModelName());
        newCubeDesc.setDescription(cubeDesc.getDescription());
        newCubeDesc.setNullStrings(cubeDesc.getNullStrings());
        newCubeDesc.setDimensions(cubeDesc.getDimensions());
        newCubeDesc.setMeasures(cubeDesc.getMeasures());
        newCubeDesc.setRowkey(cubeDesc.getRowkey());
        newCubeDesc.setHbaseMapping(cubeDesc.getHbaseMapping());
        newCubeDesc.setSignature(cubeDesc.getSignature());
        newCubeDesc.setNotifyList(cubeDesc.getNotifyList());
        newCubeDesc.setStatusNeedNotify(cubeDesc.getStatusNeedNotify());
        newCubeDesc.setAutoMergeTimeRanges(cubeDesc.getAutoMergeTimeRanges());
        newCubeDesc.setPartitionDateStart(cubeDesc.getPartitionDateStart());
        newCubeDesc.setPartitionDateEnd(cubeDesc.getPartitionDateEnd());
        newCubeDesc.setRetentionRange(cubeDesc.getRetentionRange());
        newCubeDesc.setEngineType(cubeDesc.getEngineType());
        newCubeDesc.setStorageType(cubeDesc.getStorageType());
        newCubeDesc.setAggregationGroups(cubeDesc.getAggregationGroups());
        newCubeDesc.setOverrideKylinProps(cubeDesc.getOverrideKylinProps());
        newCubeDesc.setConfig((KylinConfigExt)cubeDesc.getConfig());
        newCubeDesc.updateRandomUuid();
        return newCubeDesc;
    }

    public static class DeriveInfo {
        public DeriveType type;
        public DimensionDesc dimension;
        public TblColRef[] columns;
        public boolean isOneToOne;

        DeriveInfo(DeriveType type, DimensionDesc dimension, TblColRef[] columns, boolean isOneToOne) {
            this.type = type;
            this.dimension = dimension;
            this.columns = columns;
            this.isOneToOne = isOneToOne;
        }

        public String toString() {
            return "DeriveInfo [type=" + (Object)((Object)this.type) + ", dimension=" + this.dimension + ", columns=" + Arrays.toString(this.columns) + ", isOneToOne=" + this.isOneToOne + "]";
        }
    }

    public static enum DeriveType {
        LOOKUP,
        PK_FK,
        EXTENDED_COLUMN;

    }

    public static class CannotFilterExtendedColumnException
    extends RuntimeException {
        public CannotFilterExtendedColumnException(TblColRef tblColRef) {
            super(tblColRef == null ? "null" : tblColRef.getCanonicalName());
        }
    }
}

