/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.cube.kv;

import java.util.Collection;
import java.util.Comparator;
import org.apache.kylin.metadata.datatype.DataType;

public abstract class RowKeyColumnOrder
implements Comparator<String> {
    public static final NumberOrder NUMBER_ORDER = new NumberOrder();
    public static final StringOrder STRING_ORDER = new StringOrder();

    public static RowKeyColumnOrder getInstance(DataType type) {
        if (type.isNumberFamily()) {
            return NUMBER_ORDER;
        }
        return STRING_ORDER;
    }

    public String max(Collection<String> values) {
        String max = null;
        for (String v : values) {
            if (max != null && this.compare(max, v) >= 0) continue;
            max = v;
        }
        return max;
    }

    public String min(Collection<String> values) {
        String min = null;
        for (String v : values) {
            if (min != null && this.compare(min, v) <= 0) continue;
            min = v;
        }
        return min;
    }

    public String min(String v1, String v2) {
        if (v1 == null) {
            return v2;
        }
        if (v2 == null) {
            return v1;
        }
        return this.compare(v1, v2) <= 0 ? v1 : v2;
    }

    public String max(String v1, String v2) {
        if (v1 == null) {
            return v2;
        }
        if (v2 == null) {
            return v1;
        }
        return this.compare(v1, v2) >= 0 ? v1 : v2;
    }

    @Override
    public int compare(String o1, String o2) {
        if (o1 == o2) {
            return 0;
        }
        if (o1 == null) {
            return -1;
        }
        if (o2 == null) {
            return 1;
        }
        return this.compareNonNull(o1, o2);
    }

    abstract int compareNonNull(String var1, String var2);

    private static class NumberOrder
    extends RowKeyColumnOrder {
        private NumberOrder() {
        }

        @Override
        public int compareNonNull(String o1, String o2) {
            double d1 = Double.parseDouble(o1);
            double d2 = Double.parseDouble(o2);
            return Double.compare(d1, d2);
        }
    }

    private static class StringOrder
    extends RowKeyColumnOrder {
        private StringOrder() {
        }

        @Override
        public int compareNonNull(String o1, String o2) {
            return o1.compareTo(o2);
        }
    }
}

