/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.cube.inmemcubing;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import org.apache.kylin.cube.inmemcubing.ICuboidWriter;
import org.apache.kylin.cube.model.CubeDesc;
import org.apache.kylin.dimension.Dictionary;
import org.apache.kylin.gridtable.GTRecord;
import org.apache.kylin.gridtable.GTScanRequest;
import org.apache.kylin.gridtable.GridTable;
import org.apache.kylin.gridtable.IGTScanner;
import org.apache.kylin.metadata.model.TblColRef;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractInMemCubeBuilder {
    private static Logger logger = LoggerFactory.getLogger(AbstractInMemCubeBuilder.class);
    protected final CubeDesc cubeDesc;
    protected final Map<TblColRef, Dictionary<String>> dictionaryMap;
    protected int taskThreadCount = 4;
    protected int reserveMemoryMB = 100;

    public AbstractInMemCubeBuilder(CubeDesc cubeDesc, Map<TblColRef, Dictionary<String>> dictionaryMap) {
        if (cubeDesc == null) {
            throw new NullPointerException();
        }
        if (dictionaryMap == null) {
            throw new IllegalArgumentException("dictionary cannot be null");
        }
        this.cubeDesc = cubeDesc;
        this.dictionaryMap = dictionaryMap;
    }

    public void setConcurrentThreads(int n) {
        this.taskThreadCount = n;
    }

    public void setReserveMemoryMB(int mb) {
        this.reserveMemoryMB = mb;
    }

    public int getReserveMemoryMB() {
        return this.reserveMemoryMB;
    }

    public Runnable buildAsRunnable(final BlockingQueue<List<String>> input, final ICuboidWriter output) {
        return new Runnable(){

            @Override
            public void run() {
                try {
                    AbstractInMemCubeBuilder.this.build(input, output);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        };
    }

    public abstract void build(BlockingQueue<List<String>> var1, ICuboidWriter var2) throws IOException;

    protected void outputCuboid(long cuboidId, GridTable gridTable, ICuboidWriter output) throws IOException {
        long startTime = System.currentTimeMillis();
        GTScanRequest req = new GTScanRequest(gridTable.getInfo(), null, null, null);
        IGTScanner scanner = gridTable.scan(req);
        for (GTRecord record : scanner) {
            output.write(cuboidId, record);
        }
        scanner.close();
        logger.debug("Cuboid " + cuboidId + " output takes " + (System.currentTimeMillis() - startTime) + "ms");
    }
}

