/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.cube.common;

import org.apache.kylin.common.util.Bytes;
import org.apache.kylin.common.util.SplittedBytes;
import org.apache.kylin.cube.CubeSegment;
import org.apache.kylin.cube.cuboid.Cuboid;
import org.apache.kylin.cube.kv.CubeDimEncMap;
import org.apache.kylin.cube.kv.RowKeyColumnIO;
import org.apache.kylin.cube.model.CubeDesc;
import org.apache.kylin.metadata.model.TblColRef;

public class RowKeySplitter {
    private CubeDesc cubeDesc;
    private RowKeyColumnIO colIO;
    private SplittedBytes[] splitBuffers;
    private int bufferSize;
    private long lastSplittedCuboidId;
    private boolean enableSharding;

    public SplittedBytes[] getSplitBuffers() {
        return this.splitBuffers;
    }

    public int getBodySplitOffset() {
        if (this.enableSharding) {
            return 2;
        }
        return 1;
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    public RowKeySplitter(CubeSegment cubeSeg, int splitLen, int bytesLen) {
        this.enableSharding = cubeSeg.isEnableSharding();
        this.cubeDesc = cubeSeg.getCubeDesc();
        this.colIO = new RowKeyColumnIO(new CubeDimEncMap(cubeSeg));
        this.splitBuffers = new SplittedBytes[splitLen];
        for (int i = 0; i < splitLen; ++i) {
            this.splitBuffers[i] = new SplittedBytes(bytesLen);
        }
        this.bufferSize = 0;
    }

    public long split(byte[] bytes) {
        this.bufferSize = 0;
        int offset = 0;
        if (this.enableSharding) {
            SplittedBytes shardSplit = this.splitBuffers[this.bufferSize++];
            shardSplit.length = 2;
            System.arraycopy(bytes, offset, shardSplit.value, 0, 2);
            offset += 2;
        }
        SplittedBytes cuboidIdSplit = this.splitBuffers[this.bufferSize++];
        cuboidIdSplit.length = 8;
        System.arraycopy(bytes, offset, cuboidIdSplit.value, 0, 8);
        offset += 8;
        this.lastSplittedCuboidId = Bytes.toLong(cuboidIdSplit.value, 0, cuboidIdSplit.length);
        Cuboid cuboid = Cuboid.findById(this.cubeDesc, this.lastSplittedCuboidId);
        for (int i = 0; i < cuboid.getColumns().size(); ++i) {
            TblColRef col = cuboid.getColumns().get(i);
            int colLength = this.colIO.getColumnLength(col);
            SplittedBytes split = this.splitBuffers[this.bufferSize++];
            split.length = colLength;
            System.arraycopy(bytes, offset, split.value, 0, colLength);
            offset += colLength;
        }
        return this.lastSplittedCuboidId;
    }
}

