/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.cube;

import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.TimeZone;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.KylinConfigExt;
import org.apache.kylin.common.persistence.JsonSerializer;
import org.apache.kylin.common.persistence.ResourceStore;
import org.apache.kylin.common.persistence.Serializer;
import org.apache.kylin.common.restclient.Broadcaster;
import org.apache.kylin.common.restclient.CaseInsensitiveStringCache;
import org.apache.kylin.common.util.Pair;
import org.apache.kylin.cube.CubeDescManager;
import org.apache.kylin.cube.CubeInstance;
import org.apache.kylin.cube.CubeSegment;
import org.apache.kylin.cube.CubeUpdate;
import org.apache.kylin.cube.model.CubeDesc;
import org.apache.kylin.cube.model.DimensionDesc;
import org.apache.kylin.dict.DictionaryInfo;
import org.apache.kylin.dict.DictionaryManager;
import org.apache.kylin.dict.DistinctColumnValuesProvider;
import org.apache.kylin.dict.lookup.LookupStringTable;
import org.apache.kylin.dict.lookup.SnapshotManager;
import org.apache.kylin.dict.lookup.SnapshotTable;
import org.apache.kylin.dimension.Dictionary;
import org.apache.kylin.metadata.MetadataManager;
import org.apache.kylin.metadata.model.SegmentStatusEnum;
import org.apache.kylin.metadata.model.TableDesc;
import org.apache.kylin.metadata.model.TblColRef;
import org.apache.kylin.metadata.project.ProjectManager;
import org.apache.kylin.metadata.realization.IRealization;
import org.apache.kylin.metadata.realization.IRealizationProvider;
import org.apache.kylin.metadata.realization.RealizationStatusEnum;
import org.apache.kylin.metadata.realization.RealizationType;
import org.apache.kylin.source.ReadableTable;
import org.apache.kylin.source.SourceFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CubeManager
implements IRealizationProvider {
    private static String ALPHA_NUM = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ";
    private static int HBASE_TABLE_LENGTH = 10;
    public static final Serializer<CubeInstance> CUBE_SERIALIZER = new JsonSerializer<CubeInstance>(CubeInstance.class);
    private static final Logger logger = LoggerFactory.getLogger(CubeManager.class);
    private static final ConcurrentHashMap<KylinConfig, CubeManager> CACHE = new ConcurrentHashMap();
    private KylinConfig config;
    private CaseInsensitiveStringCache<CubeInstance> cubeMap;
    private Multimap<String, String> usedStorageLocation = HashMultimap.create();
    private CubeChangeListener listener;

    public static CubeManager getInstance(KylinConfig config) {
        CubeManager r = CACHE.get(config);
        if (r != null) {
            return r;
        }
        Class<CubeManager> clazz = CubeManager.class;
        synchronized (CubeManager.class) {
            r = CACHE.get(config);
            if (r != null) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return r;
            }
            try {
                r = new CubeManager(config);
                CACHE.put(config, r);
                if (CACHE.size() > 1) {
                    logger.warn("More than one cubemanager singleton exist");
                }
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return r;
            }
            catch (IOException e) {
                throw new IllegalStateException("Failed to init CubeManager from " + config, e);
            }
        }
    }

    public static void clearCache() {
        CACHE.clear();
    }

    private CubeManager(KylinConfig config) throws IOException {
        logger.info("Initializing CubeManager with config " + config);
        this.config = config;
        this.cubeMap = new CaseInsensitiveStringCache(config, Broadcaster.TYPE.CUBE);
        this.loadAllCubeInstance();
    }

    public List<CubeInstance> listAllCubes() {
        return new ArrayList<CubeInstance>(this.cubeMap.values());
    }

    public CubeInstance getCube(String cubeName) {
        cubeName = cubeName.toUpperCase();
        return (CubeInstance)this.cubeMap.get(cubeName);
    }

    public List<CubeInstance> getCubesByDesc(String descName) {
        descName = descName.toUpperCase();
        List<CubeInstance> list = this.listAllCubes();
        ArrayList<CubeInstance> result = new ArrayList<CubeInstance>();
        for (CubeInstance ci : list) {
            if (!descName.equalsIgnoreCase(ci.getDescName())) continue;
            result.add(ci);
        }
        return result;
    }

    public DictionaryInfo buildDictionary(CubeSegment cubeSeg, TblColRef col, DistinctColumnValuesProvider factTableValueProvider) throws IOException {
        CubeDesc cubeDesc = cubeSeg.getCubeDesc();
        if (!cubeDesc.getAllColumnsNeedDictionary().contains(col)) {
            return null;
        }
        DictionaryManager dictMgr = this.getDictionaryManager();
        DictionaryInfo dictInfo = dictMgr.buildDictionary(cubeDesc.getModel(), true, col, factTableValueProvider);
        if (dictInfo != null) {
            Dictionary<?> dict = dictInfo.getDictionaryObject();
            cubeSeg.putDictResPath(col, dictInfo.getResourcePath());
            cubeSeg.getRowkeyStats().add(new Object[]{col.getName(), dict.getSize(), dict.getSizeOfId()});
            CubeUpdate cubeBuilder = new CubeUpdate(cubeSeg.getCubeInstance());
            cubeBuilder.setToUpdateSegs(cubeSeg);
            this.updateCube(cubeBuilder);
        }
        return dictInfo;
    }

    public Dictionary<String> getDictionary(CubeSegment cubeSeg, TblColRef col) {
        DictionaryInfo info = null;
        try {
            DictionaryManager dictMgr = this.getDictionaryManager();
            String dictResPath = cubeSeg.getDictResPath(col);
            if (dictResPath == null) {
                return null;
            }
            info = dictMgr.getDictionaryInfo(dictResPath);
            if (info == null) {
                throw new IllegalStateException("No dictionary found by " + dictResPath + ", invalid cube state; cube segment" + cubeSeg + ", col " + col);
            }
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to get dictionary for cube segment" + cubeSeg + ", col" + col, e);
        }
        return info.getDictionaryObject();
    }

    public SnapshotTable buildSnapshotTable(CubeSegment cubeSeg, String lookupTable) throws IOException {
        MetadataManager metaMgr = this.getMetadataManager();
        SnapshotManager snapshotMgr = this.getSnapshotManager();
        TableDesc tableDesc = new TableDesc(metaMgr.getTableDesc(lookupTable));
        if ("VIRTUAL_VIEW".equalsIgnoreCase(tableDesc.getTableType())) {
            String tableName = tableDesc.getMaterializedName();
            tableDesc.setDatabase(this.config.getHiveDatabaseForIntermediateTable());
            tableDesc.setName(tableName);
        }
        ReadableTable hiveTable = SourceFactory.createReadableTable(tableDesc);
        SnapshotTable snapshot = snapshotMgr.buildSnapshot(hiveTable, tableDesc);
        cubeSeg.putSnapshotResPath(lookupTable, snapshot.getResourcePath());
        CubeUpdate cubeBuilder = new CubeUpdate(cubeSeg.getCubeInstance());
        cubeBuilder.setToUpdateSegs(cubeSeg);
        this.updateCube(cubeBuilder);
        return snapshot;
    }

    public CubeInstance dropCube(String cubeName, boolean deleteDesc) throws IOException {
        logger.info("Dropping cube '" + cubeName + "'");
        CubeInstance cube = this.getCube(cubeName);
        if (deleteDesc && cube.getDescriptor() != null) {
            CubeDescManager.getInstance(this.config).removeCubeDesc(cube.getDescriptor());
        }
        this.getStore().deleteResource(cube.getResourcePath());
        this.cubeMap.remove(cube.getName());
        ProjectManager.getInstance(this.config).removeRealizationsFromProjects(RealizationType.CUBE, cubeName);
        if (this.listener != null) {
            this.listener.afterCubeDelete(cube);
        }
        return cube;
    }

    public CubeInstance createCube(String cubeName, String projectName, CubeDesc desc, String owner) throws IOException {
        logger.info("Creating cube '" + projectName + "-->" + cubeName + "' from desc '" + desc.getName() + "'");
        CubeInstance cube = CubeInstance.create(cubeName, desc);
        cube.setOwner(owner);
        this.updateCubeWithRetry(new CubeUpdate(cube), 0);
        ProjectManager.getInstance(this.config).moveRealizationToProject(RealizationType.CUBE, cubeName, projectName, owner);
        if (this.listener != null) {
            this.listener.afterCubeCreate(cube);
        }
        return cube;
    }

    public CubeInstance createCube(CubeInstance cube, String projectName, String owner) throws IOException {
        logger.info("Creating cube '" + projectName + "-->" + cube.getName() + "' from instance object. '");
        cube.setOwner(owner);
        this.updateCubeWithRetry(new CubeUpdate(cube), 0);
        ProjectManager.getInstance(this.config).moveRealizationToProject(RealizationType.CUBE, cube.getName(), projectName, owner);
        if (this.listener != null) {
            this.listener.afterCubeCreate(cube);
        }
        return cube;
    }

    public CubeInstance updateCube(CubeUpdate update) throws IOException {
        CubeInstance cube = this.updateCubeWithRetry(update, 0);
        if (this.listener != null) {
            this.listener.afterCubeUpdate(cube);
        }
        return cube;
    }

    private boolean validateReadySegments(CubeInstance cube) {
        List<CubeSegment> readySegments = cube.getSegments(SegmentStatusEnum.READY);
        if (readySegments.size() == 0) {
            return true;
        }
        for (CubeSegment readySegment : readySegments) {
            if (readySegment.getDateRangeEnd() > readySegment.getDateRangeStart()) continue;
            logger.warn(String.format("segment:%s has invalid date range:[%d, %d], validation failed", readySegment.getName(), readySegment.getDateRangeStart(), readySegment.getDateRangeEnd()));
            return false;
        }
        Collections.sort(readySegments);
        int size = readySegments.size();
        for (int i = 0; i < size - 1; ++i) {
            CubeSegment lastSegment = readySegments.get(i);
            CubeSegment segment = readySegments.get(i + 1);
            if (lastSegment.getDateRangeEnd() <= segment.getDateRangeStart()) continue;
            logger.warn(String.format("segment:%s and %s data range has overlap, validation failed", lastSegment.getName(), segment.getName()));
            return false;
        }
        return true;
    }

    private CubeInstance updateCubeWithRetry(CubeUpdate update, int retry) throws IOException {
        if (update == null || update.getCubeInstance() == null) {
            throw new IllegalStateException();
        }
        CubeInstance cube = update.getCubeInstance();
        logger.info("Updating cube instance '" + cube.getName() + "'");
        if (update.getToAddSegs() != null) {
            cube.getSegments().addAll(Arrays.asList(update.getToAddSegs()));
        }
        ArrayList toRemoveResources = Lists.newArrayList();
        if (update.getToRemoveSegs() != null) {
            Iterator<CubeSegment> iterator = cube.getSegments().iterator();
            while (iterator.hasNext()) {
                CubeSegment currentSeg = iterator.next();
                for (CubeSegment toRemoveSeg : update.getToRemoveSegs()) {
                    if (!currentSeg.getUuid().equals(toRemoveSeg.getUuid())) continue;
                    iterator.remove();
                    toRemoveResources.add(toRemoveSeg.getStatisticsResourcePath());
                }
            }
        }
        if (update.getToUpdateSegs() != null) {
            for (CubeSegment segment : update.getToUpdateSegs()) {
                for (int i = 0; i < cube.getSegments().size(); ++i) {
                    if (!cube.getSegments().get(i).getUuid().equals(segment.getUuid())) continue;
                    cube.getSegments().set(i, segment);
                }
            }
        }
        Collections.sort(cube.getSegments());
        if (!this.validateReadySegments(cube)) {
            throw new IllegalStateException("Has invalid Ready segments in cube " + cube.getName());
        }
        if (update.getStatus() != null) {
            cube.setStatus(update.getStatus());
        }
        if (update.getOwner() != null) {
            cube.setOwner(update.getOwner());
        }
        if (update.getCost() > 0) {
            cube.setCost(update.getCost());
        }
        try {
            this.getStore().putResource(cube.getResourcePath(), cube, CUBE_SERIALIZER);
        }
        catch (IllegalStateException ise) {
            logger.warn("Write conflict to update cube " + cube.getName() + " at try " + retry + ", will retry...");
            if (retry >= 7) {
                logger.error("Retried 7 times till got error, abandoning...", (Throwable)ise);
                throw ise;
            }
            cube = this.reloadCubeLocal(cube.getName());
            update.setCubeInstance(cube);
            cube = this.updateCubeWithRetry(update, ++retry);
        }
        if (toRemoveResources.size() > 0) {
            for (String resource : toRemoveResources) {
                try {
                    this.getStore().deleteResource(resource);
                }
                catch (IOException ioe) {
                    logger.error("Failed to delete resource " + ((Object)toRemoveResources).toString());
                }
            }
        }
        this.cubeMap.put(cube.getName(), cube);
        ProjectManager.getInstance(cube.getConfig()).clearL2Cache();
        return cube;
    }

    public Pair<CubeSegment, CubeSegment> appendAndMergeSegments(CubeInstance cube, long endDate) throws IOException {
        this.checkNoBuildingSegment(cube);
        this.checkCubeIsPartitioned(cube);
        if (cube.getSegments().size() == 0) {
            throw new IllegalStateException("expect at least one existing segment");
        }
        long appendStart = this.calculateStartDateForAppendSegment(cube);
        CubeSegment appendSegment = this.newSegment(cube, appendStart, endDate);
        long startDate = cube.getDescriptor().getPartitionDateStart();
        CubeSegment mergeSegment = this.newSegment(cube, startDate, endDate);
        this.validateNewSegments(cube, mergeSegment);
        CubeUpdate cubeBuilder = new CubeUpdate(cube).setToAddSegs(appendSegment, mergeSegment);
        this.updateCube(cubeBuilder);
        return Pair.newPair(appendSegment, mergeSegment);
    }

    public CubeSegment appendSegments(CubeInstance cube, long endDate) throws IOException {
        return this.appendSegments(cube, endDate, true, true);
    }

    public CubeSegment appendSegments(CubeInstance cube, long endDate, boolean strictChecking, boolean saveChange) throws IOException {
        long startDate = 0L;
        if (cube.getDescriptor().getModel().getPartitionDesc().isPartitioned()) {
            startDate = this.calculateStartDateForAppendSegment(cube);
            if (endDate > cube.getDescriptor().getPartitionDateEnd()) {
                SimpleDateFormat f = new SimpleDateFormat("yyyy-MM-dd");
                f.setTimeZone(TimeZone.getTimeZone("GMT"));
                throw new IllegalArgumentException("The selected date couldn't be later than cube's end date '" + f.format(new Date(cube.getDescriptor().getPartitionDateEnd())) + "'.");
            }
        } else {
            endDate = Long.MAX_VALUE;
        }
        return this.appendSegments(cube, startDate, endDate, strictChecking, saveChange);
    }

    public CubeSegment appendSegments(CubeInstance cube, long startDate, long endDate, boolean strictChecking, boolean saveChange) throws IOException {
        if (strictChecking) {
            this.checkNoBuildingSegment(cube);
        }
        CubeSegment newSegment = this.newSegment(cube, startDate, endDate);
        this.validateNewSegments(cube, strictChecking, newSegment);
        if (saveChange) {
            CubeUpdate cubeBuilder = new CubeUpdate(cube);
            cubeBuilder.setToAddSegs(newSegment);
            this.updateCube(cubeBuilder);
        }
        return newSegment;
    }

    public CubeSegment refreshSegment(CubeInstance cube, long startDate, long endDate) throws IOException {
        this.checkNoBuildingSegment(cube);
        CubeSegment newSegment = this.newSegment(cube, startDate, endDate);
        CubeUpdate cubeBuilder = new CubeUpdate(cube);
        cubeBuilder.setToAddSegs(newSegment);
        this.updateCube(cubeBuilder);
        return newSegment;
    }

    public CubeSegment mergeSegments(CubeInstance cube, long startDate, long endDate, boolean forceMergeEmptySeg) throws IOException {
        this.checkNoBuildingSegment(cube);
        this.checkCubeIsPartitioned(cube);
        Pair<Long, Long> range = this.alignMergeRange(cube, startDate, endDate);
        CubeSegment newSegment = this.newSegment(cube, range.getFirst(), range.getSecond());
        List<CubeSegment> mergingSegments = cube.getMergingSegments(newSegment);
        if (!forceMergeEmptySeg) {
            ArrayList emptySegment = Lists.newArrayList();
            for (CubeSegment seg : mergingSegments) {
                if (seg.getSizeKB() != 0L) continue;
                emptySegment.add(seg.getName());
            }
            if (emptySegment.size() > 0) {
                throw new IllegalArgumentException("Empty cube segment found, couldn't merge unless 'forceMergeEmptySegment' set to true: " + emptySegment);
            }
        }
        this.validateNewSegments(cube, false, newSegment);
        CubeUpdate cubeBuilder = new CubeUpdate(cube);
        cubeBuilder.setToAddSegs(newSegment);
        this.updateCube(cubeBuilder);
        return newSegment;
    }

    private Pair<Long, Long> alignMergeRange(CubeInstance cube, long startDate, long endDate) {
        List<CubeSegment> readySegments = cube.getSegments(SegmentStatusEnum.READY);
        if (readySegments.isEmpty()) {
            throw new IllegalStateException("there are no segments in ready state");
        }
        long start = Long.MAX_VALUE;
        long end = Long.MIN_VALUE;
        for (CubeSegment readySegment : readySegments) {
            if (!this.hasOverlap(startDate, endDate, readySegment.getDateRangeStart(), readySegment.getDateRangeEnd())) continue;
            if (start > readySegment.getDateRangeStart()) {
                start = readySegment.getDateRangeStart();
            }
            if (end >= readySegment.getDateRangeEnd()) continue;
            end = readySegment.getDateRangeEnd();
        }
        return Pair.newPair(start, end);
    }

    private boolean hasOverlap(long startDate, long endDate, long anotherStartDate, long anotherEndDate) {
        if (startDate >= endDate) {
            throw new IllegalArgumentException("startDate must be less than endDate");
        }
        if (anotherStartDate >= anotherEndDate) {
            throw new IllegalArgumentException("anotherStartDate must be less than anotherEndDate");
        }
        if (startDate <= anotherStartDate && anotherStartDate < endDate) {
            return true;
        }
        return startDate < anotherEndDate && anotherEndDate <= endDate;
    }

    private long calculateStartDateForAppendSegment(CubeInstance cube) {
        List<CubeSegment> existing = cube.getSegments();
        if (existing.isEmpty()) {
            return cube.getDescriptor().getPartitionDateStart();
        }
        return existing.get(existing.size() - 1).getDateRangeEnd();
    }

    private void checkNoBuildingSegment(CubeInstance cube) {
        if (cube.getBuildingSegments().size() > 0) {
            throw new IllegalStateException("There is already a building segment!");
        }
    }

    private void checkCubeIsPartitioned(CubeInstance cube) {
        if (!cube.getDescriptor().getModel().getPartitionDesc().isPartitioned()) {
            throw new IllegalStateException("there is no partition date column specified, only full build is supported");
        }
    }

    public CubeInstance reloadCubeLocal(String cubeName) {
        return this.reloadCubeLocalAt(CubeInstance.concatResourcePath(cubeName));
    }

    public void removeCubeLocal(String cubeName) {
        this.usedStorageLocation.removeAll((Object)cubeName.toUpperCase());
        this.cubeMap.removeLocal(cubeName);
    }

    public LookupStringTable getLookupTable(CubeSegment cubeSegment, DimensionDesc dim) {
        String tableName = dim.getTable();
        String[] pkCols = dim.getJoin().getPrimaryKey();
        String snapshotResPath = cubeSegment.getSnapshotResPath(tableName);
        if (snapshotResPath == null) {
            throw new IllegalStateException("No snaphot for table '" + tableName + "' found on cube segment" + cubeSegment.getCubeInstance().getName() + "/" + cubeSegment);
        }
        try {
            SnapshotTable snapshot = this.getSnapshotManager().getSnapshotTable(snapshotResPath);
            TableDesc tableDesc = this.getMetadataManager().getTableDesc(tableName);
            return new LookupStringTable(tableDesc, pkCols, snapshot);
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to load lookup table " + tableName + " from snapshot " + snapshotResPath, e);
        }
    }

    private CubeSegment newSegment(CubeInstance cubeInstance, long startDate, long endDate) {
        if (startDate >= endDate) {
            throw new IllegalArgumentException("New segment range invalid, start date must be earlier than end date, " + startDate + " < " + endDate);
        }
        CubeSegment segment = new CubeSegment();
        String incrementalSegName = CubeSegment.getSegmentName(startDate, endDate);
        segment.setUuid(UUID.randomUUID().toString());
        segment.setName(incrementalSegName);
        Date creatTime = new Date();
        segment.setCreateTimeUTC(creatTime.getTime());
        segment.setDateRangeStart(startDate);
        segment.setDateRangeEnd(endDate);
        segment.setStatus(SegmentStatusEnum.NEW);
        segment.setStorageLocationIdentifier(this.generateStorageLocation());
        segment.setCubeInstance(cubeInstance);
        segment.validate();
        return segment;
    }

    private String generateStorageLocation() {
        StringBuffer sb;
        String namePrefix = "KYLIN_";
        String tableName = "";
        Random ran = new Random();
        do {
            sb = new StringBuffer();
            sb.append(namePrefix);
            for (int i = 0; i < HBASE_TABLE_LENGTH; ++i) {
                sb.append(ALPHA_NUM.charAt(ran.nextInt(ALPHA_NUM.length())));
            }
        } while (this.usedStorageLocation.containsValue((Object)(tableName = sb.toString())));
        return tableName;
    }

    public CubeSegment autoMergeCubeSegments(CubeInstance cube) throws IOException {
        if (!cube.needAutoMerge()) {
            logger.debug("Cube " + cube.getName() + " doesn't need auto merge");
            return null;
        }
        if (cube.getBuildingSegments().size() > 0) {
            logger.debug("Cube " + cube.getName() + " has bulding segment, will not trigger merge at this moment");
            return null;
        }
        ArrayList readySegments = Lists.newArrayList(cube.getSegments(SegmentStatusEnum.READY));
        if (readySegments.size() == 0) {
            logger.debug("Cube " + cube.getName() + " has no ready segment to merge");
            return null;
        }
        long[] timeRanges = cube.getDescriptor().getAutoMergeTimeRanges();
        Arrays.sort(timeRanges);
        CubeSegment newSeg = null;
        for (int i = timeRanges.length - 1; i >= 0; --i) {
            long toMergeRange = timeRanges[i];
            long currentRange = 0L;
            long lastEndTime = 0L;
            ArrayList toMergeSegments = Lists.newArrayList();
            for (CubeSegment segment : readySegments) {
                long thisSegmentRange = segment.getDateRangeEnd() - segment.getDateRangeStart();
                if (thisSegmentRange >= toMergeRange) {
                    toMergeSegments.clear();
                    currentRange = 0L;
                    lastEndTime = segment.getDateRangeEnd();
                    continue;
                }
                if (segment.getDateRangeStart() != lastEndTime && !toMergeSegments.isEmpty()) {
                    toMergeSegments.clear();
                    currentRange = 0L;
                }
                if ((currentRange += thisSegmentRange) < toMergeRange) {
                    toMergeSegments.add(segment);
                    lastEndTime = segment.getDateRangeEnd();
                    continue;
                }
                toMergeSegments.add(segment);
                newSeg = this.newSegment(cube, ((CubeSegment)toMergeSegments.get(0)).getDateRangeStart(), segment.getDateRangeEnd());
                return newSeg;
            }
        }
        return null;
    }

    public void promoteNewlyBuiltSegments(CubeInstance cube, CubeSegment ... newSegments) throws IOException {
        List<CubeSegment> tobe = this.calculateToBeSegments(cube, false, new CubeSegment[0]);
        for (CubeSegment seg : newSegments) {
            if (!tobe.contains(seg)) {
                throw new IllegalStateException("For cube " + cube + ", segment " + seg + " is expected but not in the tobe " + tobe);
            }
            if (StringUtils.isBlank((CharSequence)seg.getStorageLocationIdentifier())) {
                throw new IllegalStateException("For cube " + cube + ", segment " + seg + " missing StorageLocationIdentifier");
            }
            if (StringUtils.isBlank((CharSequence)seg.getLastBuildJobID())) {
                throw new IllegalStateException("For cube " + cube + ", segment " + seg + " missing LastBuildJobID");
            }
            seg.setStatus(SegmentStatusEnum.READY);
        }
        for (CubeSegment seg : tobe) {
            if (this.isReady(seg)) continue;
            throw new IllegalStateException("For cube " + cube + ", segment " + seg + " should be READY but is not");
        }
        ArrayList toRemoveSegs = Lists.newArrayList();
        for (CubeSegment segment : cube.getSegments()) {
            if (tobe.contains(segment)) continue;
            toRemoveSegs.add(segment);
        }
        logger.info("Promoting cube " + cube + ", new segments " + Arrays.toString(newSegments) + ", to remove segments " + toRemoveSegs);
        CubeUpdate cubeBuilder = new CubeUpdate(cube);
        cubeBuilder.setToRemoveSegs(toRemoveSegs.toArray(new CubeSegment[toRemoveSegs.size()])).setToUpdateSegs(newSegments).setStatus(RealizationStatusEnum.READY);
        this.updateCube(cubeBuilder);
    }

    public void validateNewSegments(CubeInstance cube, CubeSegment ... newSegments) {
        this.validateNewSegments(cube, true, newSegments);
    }

    public void validateNewSegments(CubeInstance cube, boolean strictChecking, CubeSegment ... newSegments) {
        List<CubeSegment> newList;
        List<CubeSegment> tobe = this.calculateToBeSegments(cube, strictChecking, newSegments);
        if (!tobe.containsAll(newList = Arrays.asList(newSegments))) {
            throw new IllegalStateException("For cube " + cube + ", the new segments " + newList + " do not fit in its current " + cube.getSegments() + "; the resulted tobe is " + tobe);
        }
    }

    private List<CubeSegment> calculateToBeSegments(CubeInstance cube, boolean strictChecking, CubeSegment ... newSegments) {
        ArrayList tobe = Lists.newArrayList(cube.getSegments());
        if (newSegments != null) {
            tobe.addAll(Arrays.asList(newSegments));
        }
        if (tobe.size() == 0) {
            return tobe;
        }
        Collections.sort(tobe);
        CubeSegment firstSeg = (CubeSegment)tobe.get(0);
        firstSeg.validate();
        int i = 0;
        int j = 1;
        while (j < tobe.size()) {
            CubeSegment is = (CubeSegment)tobe.get(i);
            CubeSegment js = (CubeSegment)tobe.get(j);
            js.validate();
            if (!this.isNew(is) && !this.isReady(is)) {
                tobe.remove(i);
                continue;
            }
            if (!this.isNew(js) && !this.isReady(js)) {
                tobe.remove(j);
                continue;
            }
            if (is.getDateRangeStart() == js.getDateRangeStart()) {
                if (this.isReady(is) && this.isReady(js) || this.isNew(is) && this.isNew(js)) {
                    if (is.getDateRangeEnd() <= js.getDateRangeEnd()) {
                        tobe.remove(i);
                        continue;
                    }
                    tobe.remove(j);
                    continue;
                }
                if (this.isNew(is)) {
                    tobe.remove(j);
                    continue;
                }
                tobe.remove(i);
                continue;
            }
            if (!strictChecking && is.getDateRangeEnd() <= js.getDateRangeStart() || strictChecking && is.getDateRangeEnd() == js.getDateRangeStart()) {
                ++i;
                ++j;
                continue;
            }
            tobe.remove(j);
        }
        return tobe;
    }

    private boolean isReady(CubeSegment seg) {
        return seg.getStatus() == SegmentStatusEnum.READY;
    }

    private boolean isNew(CubeSegment seg) {
        return seg.getStatus() == SegmentStatusEnum.NEW || seg.getStatus() == SegmentStatusEnum.READY_PENDING;
    }

    private void loadAllCubeInstance() throws IOException {
        ResourceStore store = this.getStore();
        List<String> paths = store.collectResourceRecursively("/cube", ".json");
        logger.debug("Loading Cube from folder " + store.getReadableResourcePath("/cube"));
        for (String path : paths) {
            this.reloadCubeLocalAt(path);
        }
        logger.debug("Loaded " + paths.size() + " Cube(s)");
    }

    private synchronized CubeInstance reloadCubeLocalAt(String path) {
        ResourceStore store = this.getStore();
        try {
            CubeInstance cubeInstance = store.getResource(path, CubeInstance.class, CUBE_SERIALIZER);
            CubeDesc cubeDesc = CubeDescManager.getInstance(this.config).getCubeDesc(cubeInstance.getDescName());
            if (cubeDesc == null) {
                throw new IllegalStateException("CubeInstance desc not found '" + cubeInstance.getDescName() + "', at " + path);
            }
            cubeInstance.setConfig((KylinConfigExt)cubeDesc.getConfig());
            if (StringUtils.isBlank((CharSequence)cubeInstance.getName())) {
                throw new IllegalStateException("CubeInstance name must not be blank, at " + path);
            }
            if (cubeInstance.getDescriptor() == null) {
                throw new IllegalStateException("CubeInstance desc not found '" + cubeInstance.getDescName() + "', at " + path);
            }
            String cubeName = cubeInstance.getName();
            this.cubeMap.putLocal(cubeName, cubeInstance);
            for (CubeSegment segment : cubeInstance.getSegments()) {
                this.usedStorageLocation.put((Object)cubeName.toUpperCase(), (Object)segment.getStorageLocationIdentifier());
            }
            logger.debug("Reloaded new cube: " + cubeName + " with reference being" + cubeInstance + " having " + cubeInstance.getSegments().size() + " segments:" + StringUtils.join((Iterable)Collections2.transform(cubeInstance.getSegments(), (Function)new Function<CubeSegment, String>(){

                @Nullable
                public String apply(CubeSegment input) {
                    return input.getStorageLocationIdentifier();
                }
            }), (String)","));
            return cubeInstance;
        }
        catch (Exception e) {
            logger.error("Error during load cube instance " + path, (Throwable)e);
            return null;
        }
    }

    private MetadataManager getMetadataManager() {
        return MetadataManager.getInstance(this.config);
    }

    private DictionaryManager getDictionaryManager() {
        return DictionaryManager.getInstance(this.config);
    }

    private SnapshotManager getSnapshotManager() {
        return SnapshotManager.getInstance(this.config);
    }

    private ResourceStore getStore() {
        return ResourceStore.getStore(this.config);
    }

    @Override
    public RealizationType getRealizationType() {
        return RealizationType.CUBE;
    }

    @Override
    public IRealization getRealization(String name) {
        return this.getCube(name);
    }

    public void setCubeChangeListener(CubeChangeListener listener) {
        this.listener = listener;
    }

    public List<TblColRef> getAllDictColumnsOnFact(CubeDesc cubeDesc) throws IOException {
        List<TblColRef> dictionaryColumns = cubeDesc.getAllColumnsNeedDictionary();
        ArrayList<TblColRef> factDictCols = new ArrayList<TblColRef>();
        DictionaryManager dictMgr = DictionaryManager.getInstance(this.config);
        for (int i = 0; i < dictionaryColumns.size(); ++i) {
            TblColRef col = dictionaryColumns.get(i);
            String scanTable = dictMgr.decideSourceData(cubeDesc.getModel(), true, col).getTable();
            if (!cubeDesc.getModel().isFactTable(scanTable)) continue;
            factDictCols.add(col);
        }
        return factDictCols;
    }

    public static interface CubeChangeListener {
        public void afterCubeCreate(CubeInstance var1);

        public void afterCubeUpdate(CubeInstance var1);

        public void afterCubeDelete(CubeInstance var1);
    }
}

