/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.common.util;

import java.util.Calendar;
import java.util.TimeZone;

public class TimeUtil {
    private static TimeZone gmt = TimeZone.getTimeZone("GMT");
    private static long ONE_MINUTE_TS = 60000L;
    private static long ONE_HOUR_TS = 60L * ONE_MINUTE_TS;
    private static long ONE_DAY_TS = 24L * ONE_HOUR_TS;

    public static long getMinuteStart(long ts) {
        return ts / ONE_MINUTE_TS * ONE_MINUTE_TS;
    }

    public static long getHourStart(long ts) {
        return ts / ONE_HOUR_TS * ONE_HOUR_TS;
    }

    public static long getDayStart(long ts) {
        return ts / ONE_DAY_TS * ONE_DAY_TS;
    }

    public static long getWeekStart(long ts) {
        Calendar calendar = Calendar.getInstance(gmt);
        calendar.setTimeInMillis(TimeUtil.getDayStart(ts));
        calendar.add(7, calendar.getFirstDayOfWeek() - calendar.get(7));
        return calendar.getTimeInMillis();
    }

    public static long getMonthStart(long ts) {
        Calendar calendar = Calendar.getInstance(gmt);
        calendar.setTimeInMillis(ts);
        int year = calendar.get(1);
        int month = calendar.get(2);
        calendar.clear();
        calendar.set(year, month, 1);
        return calendar.getTimeInMillis();
    }

    public static long getQuarterStart(long ts) {
        Calendar calendar = Calendar.getInstance(gmt);
        calendar.setTimeInMillis(ts);
        int year = calendar.get(1);
        int month = calendar.get(2);
        calendar.clear();
        calendar.set(year, month / 3 * 3, 1);
        return calendar.getTimeInMillis();
    }

    public static long getYearStart(long ts) {
        Calendar calendar = Calendar.getInstance(gmt);
        calendar.setTimeInMillis(ts);
        int year = calendar.get(1);
        calendar.clear();
        calendar.set(year, 0, 1);
        return calendar.getTimeInMillis();
    }
}

