/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.common.util;

import com.jcraft.jsch.Channel;
import com.jcraft.jsch.ChannelExec;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.kylin.common.util.Logger;
import org.apache.kylin.common.util.SSHClientOutput;
import org.slf4j.LoggerFactory;

public class SSHClient {
    protected static final org.slf4j.Logger logger = LoggerFactory.getLogger(SSHClient.class);
    private String hostname;
    private int port;
    private String username;
    private String password;
    private String identityPath;

    public SSHClient(String hostname, int port, String username, String password) {
        this.hostname = hostname;
        this.username = username;
        this.port = port;
        if (password != null && new File(password).exists()) {
            this.identityPath = new File(password).getAbsolutePath();
            this.password = null;
        } else {
            this.password = password;
            this.identityPath = null;
        }
    }

    public void scpFileToRemote(String localFile, String remoteTargetDirectory) throws Exception {
        FileInputStream fis = null;
        try {
            int len;
            System.out.println("SCP file " + localFile + " to " + remoteTargetDirectory);
            Session session = this.newJSchSession();
            session.connect();
            boolean ptimestamp = false;
            String command = "scp " + (ptimestamp ? "-p" : "") + " -t " + remoteTargetDirectory;
            Channel channel = session.openChannel("exec");
            ((ChannelExec)channel).setCommand(command);
            OutputStream out = channel.getOutputStream();
            InputStream in = channel.getInputStream();
            channel.connect();
            if (this.checkAck(in) != 0) {
                System.exit(0);
            }
            File _lfile = new File(localFile);
            if (ptimestamp) {
                command = "T " + _lfile.lastModified() / 1000L + " 0";
                command = command + " " + _lfile.lastModified() / 1000L + " 0\n";
                out.write(command.getBytes());
                out.flush();
                if (this.checkAck(in) != 0) {
                    throw new Exception("Error in checkAck()");
                }
            }
            long filesize = _lfile.length();
            command = "C0644 " + filesize + " ";
            command = localFile.lastIndexOf("/") > 0 ? command + localFile.substring(localFile.lastIndexOf("/") + 1) : (localFile.lastIndexOf(File.separator) > 0 ? command + localFile.substring(localFile.lastIndexOf(File.separator) + 1) : command + localFile);
            command = command + "\n";
            out.write(command.getBytes());
            out.flush();
            if (this.checkAck(in) != 0) {
                throw new Exception("Error in checkAck()");
            }
            fis = new FileInputStream(localFile);
            byte[] buf = new byte[1024];
            while ((len = fis.read(buf, 0, buf.length)) > 0) {
                out.write(buf, 0, len);
            }
            fis.close();
            fis = null;
            buf[0] = 0;
            out.write(buf, 0, 1);
            out.flush();
            if (this.checkAck(in) != 0) {
                throw new Exception("Error in checkAck()");
            }
            out.close();
            channel.disconnect();
            session.disconnect();
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            try {
                if (fis != null) {
                    fis.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public void scpFileToLocal(String rfile, String lfile) throws Exception {
        FileOutputStream fos = null;
        try {
            int c;
            System.out.println("SCP remote file " + rfile + " to local " + lfile);
            String prefix = null;
            if (new File(lfile).isDirectory()) {
                prefix = lfile + File.separator;
            }
            Session session = this.newJSchSession();
            session.connect();
            String command = "scp -f " + rfile;
            Channel channel = session.openChannel("exec");
            ((ChannelExec)channel).setCommand(command);
            OutputStream out = channel.getOutputStream();
            InputStream in = channel.getInputStream();
            channel.connect();
            byte[] buf = new byte[1024];
            buf[0] = 0;
            out.write(buf, 0, 1);
            out.flush();
            while ((c = this.checkAck(in)) == 67) {
                int foo;
                in.read(buf, 0, 5);
                long filesize = 0L;
                while (in.read(buf, 0, 1) >= 0 && buf[0] != 32) {
                    filesize = filesize * 10L + (long)(buf[0] - 48);
                }
                String file = null;
                int i = 0;
                while (true) {
                    in.read(buf, i, 1);
                    if (buf[i] == 10) break;
                    ++i;
                }
                file = new String(buf, 0, i);
                buf[0] = 0;
                out.write(buf, 0, 1);
                out.flush();
                fos = new FileOutputStream(prefix == null ? lfile : prefix + file);
                do {
                    foo = (long)buf.length < filesize ? buf.length : (int)filesize;
                    if ((foo = in.read(buf, 0, foo)) < 0) break;
                    fos.write(buf, 0, foo);
                } while ((filesize -= (long)foo) != 0L);
                fos.close();
                fos = null;
                if (this.checkAck(in) != 0) {
                    System.exit(0);
                }
                buf[0] = 0;
                out.write(buf, 0, 1);
                out.flush();
            }
            in.close();
            out.close();
            session.disconnect();
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            try {
                if (fos != null) {
                    fos.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public SSHClientOutput execCommand(String command) throws Exception {
        return this.execCommand(command, 7200, null);
    }

    public SSHClientOutput execCommand(String command, int timeoutSeconds, Logger logAppender) throws Exception {
        Channel channel;
        Session session;
        int exitCode;
        StringBuffer text;
        block8: {
            System.out.println("[" + this.username + "@" + this.hostname + "] Execute command: " + command);
            text = new StringBuffer();
            exitCode = -1;
            session = this.newJSchSession();
            session.connect();
            channel = session.openChannel("exec");
            ((ChannelExec)channel).setCommand(command);
            channel.setInputStream(null);
            ((ChannelExec)channel).setErrStream((OutputStream)System.err);
            InputStream in = channel.getInputStream();
            InputStream err = ((ChannelExec)channel).getErrStream();
            channel.connect();
            int timeout = timeoutSeconds;
            byte[] tmp = new byte[1024];
            while (true) {
                String line;
                int i;
                --timeout;
                while (in.available() > 0 && (i = in.read(tmp, 0, 1024)) >= 0) {
                    line = new String(tmp, 0, i);
                    text.append(line);
                    if (logAppender == null) continue;
                    logAppender.log(line);
                }
                while (err.available() > 0 && (i = err.read(tmp, 0, 1024)) >= 0) {
                    line = new String(tmp, 0, i);
                    text.append(line);
                    if (logAppender == null) continue;
                    logAppender.log(line);
                }
                if (channel.isClosed()) {
                    if (in.available() > 0) continue;
                    break block8;
                }
                Thread.sleep(1000L);
                if (timeout < 0) break;
            }
            throw new Exception("Remote command not finished within " + timeoutSeconds + " seconds.");
        }
        exitCode = channel.getExitStatus();
        System.out.println("[" + this.username + "@" + this.hostname + "] Command exit-status: " + exitCode);
        channel.disconnect();
        session.disconnect();
        return new SSHClientOutput(exitCode, text.toString());
    }

    private Session newJSchSession() throws JSchException {
        JSch jsch = new JSch();
        if (this.identityPath != null) {
            jsch.addIdentity(this.identityPath);
        }
        Session session = jsch.getSession(this.username, this.hostname, this.port);
        if (this.password != null) {
            session.setPassword(this.password);
        }
        session.setConfig("StrictHostKeyChecking", "no");
        return session;
    }

    private int checkAck(InputStream in) throws IOException {
        int b = in.read();
        if (b == 0) {
            return b;
        }
        if (b == -1) {
            return b;
        }
        if (b == 1 || b == 2) {
            int c;
            StringBuffer sb = new StringBuffer();
            do {
                c = in.read();
                sb.append((char)c);
            } while (c != 10);
            if (b == 1) {
                System.out.print(sb.toString());
            }
            if (b == 2) {
                System.out.print(sb.toString());
            }
        }
        return b;
    }
}

