/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.common.util;

import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.mail.EmailException;
import org.apache.commons.mail.HtmlEmail;
import org.apache.kylin.common.KylinConfig;

public class MailService {
    private Boolean enabled = Boolean.TRUE;
    private String host;
    private String username;
    private String password;
    private String sender;
    private static final Log logger = LogFactory.getLog(MailService.class);

    public MailService(KylinConfig config) {
        this(config.isMailEnabled(), config.getMailHost(), config.getMailUsername(), config.getMailPassword(), config.getMailSender());
    }

    private MailService(boolean enabled, String host, String username, String password, String sender) {
        this.enabled = enabled;
        this.host = host;
        this.username = username;
        this.password = password;
        this.sender = sender;
        if (enabled && host.isEmpty()) {
            throw new RuntimeException("mail service host is empty");
        }
    }

    public boolean sendMail(List<String> receivers, String subject, String content) {
        return this.sendMail(receivers, subject, content, true);
    }

    public boolean sendMail(List<String> receivers, String subject, String content, boolean isHtmlMsg) {
        if (!this.enabled.booleanValue()) {
            logger.info((Object)("Email service is disabled; this mail will not be delivered: " + subject));
            logger.info((Object)"To enable mail service, set 'mail.enabled=true' in kylin.properties");
            return false;
        }
        HtmlEmail email = new HtmlEmail();
        email.setHostName(this.host);
        if (this.username != null && this.username.trim().length() > 0) {
            email.setAuthentication(this.username, this.password);
        }
        try {
            for (String receiver : receivers) {
                email.addTo(receiver);
            }
            email.setFrom(this.sender);
            email.setSubject(subject);
            email.setCharset("UTF-8");
            if (isHtmlMsg) {
                email.setHtmlMsg(content);
            } else {
                email.setTextMsg(content);
            }
            email.send();
            email.getMailSession();
        }
        catch (EmailException e) {
            logger.error((Object)e.getLocalizedMessage(), (Throwable)e);
            return false;
        }
        return true;
    }
}

