/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.common.util;

import java.util.Map;
import org.apache.kylin.common.util.ClassUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImplementationSwitch<I> {
    private static final Logger logger = LoggerFactory.getLogger(ImplementationSwitch.class);
    private final Object[] instances;
    private Class<I> interfaceClz;

    public ImplementationSwitch(Map<Integer, String> impls, Class<I> interfaceClz) {
        this.interfaceClz = interfaceClz;
        this.instances = this.initInstances(impls);
    }

    private Object[] initInstances(Map<Integer, String> impls) {
        int maxId = 0;
        for (Integer id : impls.keySet()) {
            maxId = Math.max(maxId, id);
        }
        if (maxId > 100) {
            throw new IllegalArgumentException("you have more than 100 implementations?");
        }
        Object[] result = new Object[maxId + 1];
        for (Integer id : impls.keySet()) {
            String clzName = impls.get(id);
            try {
                result[id.intValue()] = ClassUtil.newInstance(clzName);
            }
            catch (Exception ex) {
                logger.warn("Implementation missing " + clzName + " - " + ex);
            }
        }
        return result;
    }

    public I get(int id) {
        Object result = this.instances[id];
        if (result == null) {
            throw new IllegalArgumentException("Implementations missing, ID " + id + ", interface " + this.interfaceClz.getName());
        }
        return (I)result;
    }
}

