/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.common.util;

import java.io.File;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;

public class ClassUtil {
    private static final WeakHashMap<String, Class<?>> forNameCache = new WeakHashMap();
    private static final Map<String, String> classRenameMap = new HashMap<String, String>();

    public static void addClasspath(String path) {
        System.out.println("Adding path " + path + " to class path");
        File file = new File(path);
        try {
            if (file.exists()) {
                URLClassLoader urlClassLoader = (URLClassLoader)ClassLoader.getSystemClassLoader();
                Class<URLClassLoader> urlClass = URLClassLoader.class;
                Method method = urlClass.getDeclaredMethod("addURL", URL.class);
                method.setAccessible(true);
                method.invoke((Object)urlClassLoader, file.toURI().toURL());
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> Class<? extends T> forName(String name, Class<T> clz) throws ClassNotFoundException {
        String origName = name;
        Class<?> result = forNameCache.get(origName);
        if (result == null) {
            name = ClassUtil.forRenamedClass(name);
            result = Class.forName(name);
            forNameCache.put(origName, result);
        }
        return result;
    }

    private static String forRenamedClass(String name) {
        String rename;
        if (name.startsWith("com.kylinolap")) {
            name = "org.apache.kylin" + name.substring("com.kylinolap".length());
        }
        return (rename = classRenameMap.get(name)) == null ? name : rename;
    }

    public static Object newInstance(String clz) {
        try {
            return ClassUtil.forName(clz, Object.class).newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    static {
        classRenameMap.put("org.apache.kylin.job.common.HadoopShellExecutable", "org.apache.kylin.engine.mr.common.HadoopShellExecutable");
        classRenameMap.put("org.apache.kylin.job.common.MapReduceExecutable", "org.apache.kylin.engine.mr.common.MapReduceExecutable");
        classRenameMap.put("org.apache.kylin.job.cube.CubingJob", "org.apache.kylin.engine.mr.CubingJob");
        classRenameMap.put("org.apache.kylin.job.invertedindex.IIJob", "org.apache.kylin.engine.mr.invertedindex.IIJob");
        classRenameMap.put("org.apache.kylin.job.cube.GarbageCollectionStep", "org.apache.kylin.storage.hbase.steps.DeprecatedGCStep");
        classRenameMap.put("org.apache.kylin.job.cube.MergeDictionaryStep", "org.apache.kylin.engine.mr.steps.MergeDictionaryStep");
        classRenameMap.put("org.apache.kylin.job.cube.UpdateCubeInfoAfterBuildStep", "org.apache.kylin.engine.mr.steps.UpdateCubeInfoAfterBuildStep");
        classRenameMap.put("org.apache.kylin.job.cube.UpdateCubeInfoAfterMergeStep", "org.apache.kylin.engine.mr.steps.UpdateCubeInfoAfterMergeStep");
    }
}

