/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.common.util;

import java.io.Serializable;
import java.nio.ByteBuffer;
import org.apache.kylin.common.util.Bytes;
import org.apache.kylin.common.util.BytesUtil;

public class ByteArray
implements Comparable<ByteArray>,
Serializable {
    private static final long serialVersionUID = 1L;
    public static final ByteArray EMPTY = new ImmutableByteArray();
    private byte[] data;
    private int offset;
    private int length;

    public static ByteArray allocate(int length) {
        return new ByteArray(new byte[length]);
    }

    public static ByteArray copyOf(byte[] array, int offset, int length) {
        byte[] space = new byte[length];
        System.arraycopy(array, offset, space, 0, length);
        return new ByteArray(space, 0, length);
    }

    public ByteArray() {
        this(null, 0, 0);
    }

    public ByteArray(int capacity) {
        this(new byte[capacity], 0, capacity);
    }

    public ByteArray(byte[] data) {
        this(data, 0, data == null ? 0 : data.length);
    }

    public ByteArray(byte[] data, int offset, int length) {
        this.data = data;
        this.offset = offset;
        this.length = length;
    }

    public byte[] array() {
        return this.data;
    }

    public int offset() {
        return this.offset;
    }

    public int length() {
        return this.length;
    }

    public void set(byte[] array) {
        this.set(array, 0, array.length);
    }

    public void set(byte[] array, int offset, int length) {
        this.data = array;
        this.offset = offset;
        this.length = length;
    }

    public void set(ByteArray o) {
        this.set(o.data, o.offset, o.length);
    }

    public void set(int offset, int length) {
        this.offset = offset;
        this.length = length;
    }

    public void setLength(int length) {
        this.length = length;
    }

    public ByteArray copy() {
        ByteArray copy = this.data != null ? new ByteArray(this.length) : new ByteArray(null);
        copy.copyFrom(this);
        return copy;
    }

    public void exportData(ByteBuffer out) {
        BytesUtil.writeByteArray(this.data, this.offset, this.length, out);
    }

    public static ByteArray importData(ByteBuffer in) {
        byte[] bytes = BytesUtil.readByteArray(in);
        return new ByteArray(bytes);
    }

    public void copyFrom(ByteArray other) {
        if (other.data != null) {
            System.arraycopy(other.array(), other.offset, this.data, this.offset, other.length);
        }
        this.length = other.length;
    }

    public ByteBuffer asBuffer() {
        if (this.data == null) {
            return null;
        }
        if (this.offset == 0 && this.length == this.data.length) {
            return ByteBuffer.wrap(this.data);
        }
        return ByteBuffer.wrap(this.data, this.offset, this.length).slice();
    }

    public int hashCode() {
        if (this.data == null) {
            return 0;
        }
        if (this.length <= 8 && this.length > 0) {
            long value = BytesUtil.readLong(this.data, this.offset, this.length);
            return (int)(value ^ value >>> 32);
        }
        return Bytes.hashCode(this.data, this.offset, this.length);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ByteArray o = (ByteArray)obj;
        if (this.data == null && o.data == null) {
            return true;
        }
        if (this.data == null || o.data == null) {
            return false;
        }
        return Bytes.equals(this.data, this.offset, this.length, o.data, o.offset, o.length);
    }

    @Override
    public int compareTo(ByteArray o) {
        if (this.data == null && o.data == null) {
            return 0;
        }
        if (this.data == null) {
            return -1;
        }
        if (o.data == null) {
            return 1;
        }
        return Bytes.compareTo(this.data, this.offset, this.length, o.data, o.offset, o.length);
    }

    public String toReadableText() {
        if (this.data == null) {
            return null;
        }
        return BytesUtil.toHex(this.data, this.offset, this.length);
    }

    public String toString() {
        if (this.data == null) {
            return null;
        }
        return Bytes.toStringBinary(this.data, this.offset, this.length);
    }

    public static class ImmutableByteArray
    extends ByteArray {
        private static final long serialVersionUID = 1L;

        public ImmutableByteArray() {
        }

        public ImmutableByteArray(byte[] data, int offset, int length) {
            super(data, offset, length);
        }

        public ImmutableByteArray(byte[] data) {
            super(data);
        }

        @Override
        public void set(byte[] array) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void set(byte[] array, int offset, int length) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void set(ByteArray o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setLength(int length) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void copyFrom(ByteArray other) {
            throw new UnsupportedOperationException();
        }
    }
}

