/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.common.restclient;

import java.io.IOException;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PutMethod;
import org.apache.kylin.common.util.Bytes;
import org.apache.kylin.common.util.JsonUtil;

public class RestClient {
    protected String host;
    protected int port;
    protected String baseUrl;
    protected String userName;
    protected String password;
    protected HttpClient client;
    protected static Pattern fullRestPattern = Pattern.compile("(?:([^:]+)[:]([^@]+)[@])?([^:]+)(?:[:](\\d+))?");

    public static boolean matchFullRestPattern(String uri) {
        Matcher m = fullRestPattern.matcher(uri);
        return m.matches();
    }

    public RestClient(String uri) {
        Matcher m = fullRestPattern.matcher(uri);
        if (!m.matches()) {
            throw new IllegalArgumentException("URI: " + uri + " -- does not match pattern " + fullRestPattern);
        }
        String user = m.group(1);
        String pwd = m.group(2);
        String host = m.group(3);
        String portStr = m.group(4);
        int port = Integer.parseInt(portStr == null ? "7070" : portStr);
        this.init(host, port, user, pwd);
    }

    private void init(String host, int port, String userName, String password) {
        this.host = host;
        this.port = port;
        this.userName = userName;
        this.password = password;
        this.baseUrl = "http://" + host + ":" + port + "/kylin/api";
        this.client = new HttpClient();
        if (userName != null && password != null) {
            this.client.getParams().setAuthenticationPreemptive(true);
            UsernamePasswordCredentials creds = new UsernamePasswordCredentials(userName, password);
            this.client.getState().setCredentials(new AuthScope(host, port, AuthScope.ANY_REALM), (Credentials)creds);
        }
    }

    public void wipeCache(String type, String action, String name) throws IOException {
        String url = this.baseUrl + "/cache/" + type + "/" + name + "/" + action;
        PutMethod request = new PutMethod(url);
        try {
            int code = this.client.executeMethod((HttpMethod)request);
            String msg = Bytes.toString(request.getResponseBody());
            if (code != 200) {
                throw new IOException("Invalid response " + code + " with cache wipe url " + url + "\n" + msg);
            }
        }
        catch (HttpException ex) {
            throw new IOException(ex);
        }
        finally {
            request.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getKylinProperties() throws IOException {
        String url = this.baseUrl + "/admin/config";
        GetMethod request = new GetMethod(url);
        try {
            int code = this.client.executeMethod((HttpMethod)request);
            String msg = Bytes.toString(request.getResponseBody());
            Map<String, String> map = JsonUtil.readValueAsMap(msg);
            msg = map.get("config");
            if (code != 200) {
                throw new IOException("Invalid response " + code + " with cache wipe url " + url + "\n" + msg);
            }
            String string = msg;
            return string;
        }
        finally {
            request.releaseConnection();
        }
    }
}

