/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.common.persistence;

import com.google.common.collect.Lists;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.NavigableSet;
import java.util.TreeSet;
import org.apache.commons.io.IOUtils;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.persistence.RawResource;
import org.apache.kylin.common.persistence.ResourceStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileResourceStore
extends ResourceStore {
    private static final Logger logger = LoggerFactory.getLogger(FileResourceStore.class);
    File root;

    public FileResourceStore(KylinConfig kylinConfig) {
        super(kylinConfig);
        this.root = new File(kylinConfig.getMetadataUrl()).getAbsoluteFile();
        if (!this.root.exists()) {
            throw new IllegalArgumentException("File not exist by '" + kylinConfig.getMetadataUrl() + "': " + this.root.getAbsolutePath());
        }
    }

    @Override
    protected NavigableSet<String> listResourcesImpl(String folderPath) throws IOException {
        String[] names = this.file(folderPath).list();
        if (names == null) {
            return null;
        }
        TreeSet<String> r = new TreeSet<String>();
        String prefix = folderPath.endsWith("/") ? folderPath : folderPath + "/";
        for (String n : names) {
            r.add(prefix + n);
        }
        return r;
    }

    @Override
    protected boolean existsImpl(String resPath) throws IOException {
        File f = this.file(resPath);
        return f.exists() && f.isFile();
    }

    @Override
    protected List<RawResource> getAllResourcesImpl(String folderPath, long timeStart, long timeEndExclusive) throws IOException {
        NavigableSet<String> resources = this.listResources(folderPath);
        if (resources == null) {
            return Collections.emptyList();
        }
        ArrayList result = Lists.newArrayListWithCapacity((int)resources.size());
        try {
            for (String res : resources) {
                RawResource resource;
                long ts = this.getResourceTimestampImpl(res);
                if (timeStart > ts || ts >= timeEndExclusive || (resource = this.getResourceImpl(res)) == null) continue;
                result.add(resource);
            }
        }
        catch (IOException ex) {
            for (RawResource rawResource : result) {
                IOUtils.closeQuietly((InputStream)rawResource.inputStream);
            }
            throw ex;
        }
        return result;
    }

    @Override
    protected RawResource getResourceImpl(String resPath) throws IOException {
        File f = this.file(resPath);
        if (f.exists() && f.isFile()) {
            if (f.length() == 0L) {
                logger.warn("Zero length file: " + f.getAbsolutePath());
            }
            return new RawResource(new FileInputStream(f), f.lastModified());
        }
        return null;
    }

    @Override
    protected long getResourceTimestampImpl(String resPath) throws IOException {
        File f = this.file(resPath);
        if (f.exists() && f.isFile()) {
            return f.lastModified();
        }
        return 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void putResourceImpl(String resPath, InputStream content, long ts) throws IOException {
        File f = this.file(resPath);
        f.getParentFile().mkdirs();
        FileOutputStream out = new FileOutputStream(f);
        try {
            IOUtils.copy((InputStream)content, (OutputStream)out);
        }
        finally {
            IOUtils.closeQuietly((OutputStream)out);
        }
        f.setLastModified(ts);
    }

    @Override
    protected long checkAndPutResourceImpl(String resPath, byte[] content, long oldTS, long newTS) throws IOException, IllegalStateException {
        File f = this.file(resPath);
        if (f.exists() && f.lastModified() != oldTS || !f.exists() && oldTS != 0L) {
            throw new IllegalStateException("Overwriting conflict " + resPath + ", expect old TS " + oldTS + ", but found " + f.lastModified());
        }
        this.putResourceImpl(resPath, new ByteArrayInputStream(content), newTS);
        return f.lastModified();
    }

    @Override
    protected void deleteResourceImpl(String resPath) throws IOException {
        File f = this.file(resPath);
        f.delete();
    }

    @Override
    protected String getReadableResourcePathImpl(String resPath) {
        return this.file(resPath).toString();
    }

    private File file(String resPath) {
        if (resPath.equals("/")) {
            return this.root;
        }
        return new File(this.root, resPath);
    }
}

