/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.common;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Enumeration;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.kylin.common.KylinConfigBase;
import org.apache.kylin.common.KylinConfigExt;
import org.apache.kylin.common.restclient.RestClient;
import org.apache.kylin.common.util.ClassUtil;
import org.apache.kylin.common.util.Log4jConfigurer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KylinConfig
extends KylinConfigBase {
    private static final Logger logger = LoggerFactory.getLogger(KylinConfig.class);
    public static final String KYLIN_CONF_PROPERTIES_FILE = "kylin.properties";
    public static final String KYLIN_CONF = "KYLIN_CONF";
    private static KylinConfig ENV_INSTANCE;

    public static KylinConfig getInstanceFromEnv() {
        if (ENV_INSTANCE == null) {
            try {
                KylinConfig config;
                ENV_INSTANCE = config = KylinConfig.loadKylinConfig();
            }
            catch (IllegalArgumentException e) {
                throw new IllegalStateException("Failed to find KylinConfig ", e);
            }
        }
        return ENV_INSTANCE;
    }

    public static void destroyInstance() {
        ENV_INSTANCE = null;
    }

    private static UriType decideUriType(String metaUri) {
        try {
            File file = new File(metaUri);
            if (file.exists() || metaUri.contains("/")) {
                if (!file.exists()) {
                    file.mkdirs();
                }
                if (file.isDirectory()) {
                    return UriType.LOCAL_FOLDER;
                }
                if (file.isFile()) {
                    if (file.getName().equalsIgnoreCase(KYLIN_CONF_PROPERTIES_FILE)) {
                        return UriType.PROPERTIES_FILE;
                    }
                    throw new IllegalStateException("Metadata uri : " + metaUri + " is a local file but not kylin.properties");
                }
                throw new IllegalStateException("Metadata uri : " + metaUri + " looks like a file but it's neither a file nor a directory");
            }
            if (RestClient.matchFullRestPattern(metaUri)) {
                return UriType.REST_ADDR;
            }
            throw new IllegalStateException("Metadata uri : " + metaUri + " is not a valid REST URI address");
        }
        catch (Exception e) {
            throw new IllegalStateException("Metadata uri : " + metaUri + " is not recognized", e);
        }
    }

    public static KylinConfig createInstanceFromUri(String uri) {
        UriType uriType = KylinConfig.decideUriType(uri);
        logger.info("The URI " + uri + " is recognized as " + (Object)((Object)uriType));
        if (uriType == UriType.LOCAL_FOLDER) {
            KylinConfig config = new KylinConfig();
            config.setMetadataUrl(uri);
            return config;
        }
        if (uriType == UriType.PROPERTIES_FILE) {
            KylinConfig config;
            try {
                config = new KylinConfig();
                FileInputStream is = new FileInputStream(uri);
                config.reloadKylinConfig(is);
                ((InputStream)is).close();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            return config;
        }
        try {
            KylinConfig config = new KylinConfig();
            RestClient client = new RestClient(uri);
            String propertyText = client.getKylinProperties();
            InputStream is = IOUtils.toInputStream((String)propertyText);
            config.reloadKylinConfig(is);
            is.close();
            return config;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static KylinConfig getKylinConfigFromInputStream(InputStream is) {
        KylinConfig config = new KylinConfig();
        config.reloadKylinConfig(is);
        return config;
    }

    private static File getKylinProperties() {
        String kylinConfHome = System.getProperty(KYLIN_CONF);
        if (!StringUtils.isEmpty((String)kylinConfHome)) {
            logger.info("Use KYLIN_CONF=" + kylinConfHome);
            return KylinConfig.getKylinPropertiesFile(kylinConfHome);
        }
        logger.warn("KYLIN_CONF property was not set, will seek KYLIN_HOME env variable");
        String kylinHome = KylinConfig.getKylinHome();
        if (StringUtils.isEmpty((String)kylinHome)) {
            throw new RuntimeException("Didn't find KYLIN_CONF or KYLIN_HOME, please set one of them");
        }
        String path = kylinHome + File.separator + "conf";
        return KylinConfig.getKylinPropertiesFile(path);
    }

    public static InputStream getKylinPropertiesAsInputStream() {
        File propFile = KylinConfig.getKylinProperties();
        if (propFile == null || !propFile.exists()) {
            logger.error("fail to locate kylin.properties");
            throw new RuntimeException("fail to locate kylin.properties");
        }
        File overrideFile = new File(propFile.getParentFile(), propFile.getName() + ".override");
        if (overrideFile.exists()) {
            ByteArrayInputStream byteArrayInputStream;
            FileInputStream fis = null;
            FileInputStream fis2 = null;
            try {
                fis = new FileInputStream(propFile);
                fis2 = new FileInputStream(overrideFile);
                Properties conf = new Properties();
                conf.load(fis);
                Properties override = new Properties();
                override.load(fis2);
                for (Map.Entry<Object, Object> entries : override.entrySet()) {
                    conf.setProperty(entries.getKey().toString(), entries.getValue().toString());
                }
                ByteArrayOutputStream bout = new ByteArrayOutputStream();
                conf.store(bout, "output");
                byteArrayInputStream = new ByteArrayInputStream(bout.toByteArray());
            }
            catch (IOException e) {
                try {
                    throw new RuntimeException(e);
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(fis);
                    IOUtils.closeQuietly(fis2);
                    throw throwable;
                }
            }
            IOUtils.closeQuietly((InputStream)fis);
            IOUtils.closeQuietly((InputStream)fis2);
            return byteArrayInputStream;
        }
        try {
            return new FileInputStream(propFile);
        }
        catch (FileNotFoundException e) {
            logger.error("this should not happen");
            throw new RuntimeException(e);
        }
    }

    private static File getKylinPropertiesFile(String path) {
        if (path == null) {
            return null;
        }
        return new File(path, KYLIN_CONF_PROPERTIES_FILE);
    }

    private static KylinConfig loadKylinConfig() {
        InputStream is = KylinConfig.getKylinPropertiesAsInputStream();
        if (is == null) {
            throw new IllegalArgumentException("Failed to load kylin config");
        }
        KylinConfig config = new KylinConfig();
        config.reloadKylinConfig(is);
        return config;
    }

    public static void setSandboxEnvIfPossible() {
        File dir1 = new File("../../kylin/examples/test_case_data/sandbox");
        File dir2 = new File("../examples/test_case_data/sandbox");
        if (dir1.exists()) {
            logger.info("Setting sandbox env, KYLIN_CONF=" + dir1.getAbsolutePath());
            ClassUtil.addClasspath(dir1.getAbsolutePath());
            System.setProperty(KYLIN_CONF, dir1.getAbsolutePath());
        } else if (dir2.exists()) {
            logger.info("Setting sandbox env, KYLIN_CONF=" + dir2.getAbsolutePath());
            ClassUtil.addClasspath(dir2.getAbsolutePath());
            System.setProperty(KYLIN_CONF, dir2.getAbsolutePath());
        }
    }

    public KylinConfig() {
    }

    public KylinConfig(Properties props) {
        super(props);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeProperties(File file) throws IOException {
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(file);
            this.getAllProperties().store(fos, file.getAbsolutePath());
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(fos);
            throw throwable;
        }
        IOUtils.closeQuietly((OutputStream)fos);
    }

    public String getConfigAsString() throws IOException {
        StringWriter stringWriter = new StringWriter();
        this.list(new PrintWriter(stringWriter));
        return stringWriter.toString();
    }

    private void list(PrintWriter out) {
        Properties props = this.getAllProperties();
        Enumeration<Object> e = props.keys();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            String val = (String)props.get(key);
            out.println(key + "=" + val);
        }
    }

    private KylinConfig base() {
        if (this instanceof KylinConfigExt) {
            return ((KylinConfigExt)this).base;
        }
        return this;
    }

    private int superHashCode() {
        return super.hashCode();
    }

    public int hashCode() {
        return this.base().superHashCode();
    }

    public boolean equals(Object another) {
        if (!(another instanceof KylinConfig)) {
            return false;
        }
        return this.base() == ((KylinConfig)another).base();
    }

    static {
        Log4jConfigurer.initLogger();
        ENV_INSTANCE = null;
    }

    public static enum UriType {
        PROPERTIES_FILE,
        REST_ADDR,
        LOCAL_FOLDER;

    }
}

