/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.tool;

import com.google.common.collect.Lists;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.lang.StringUtils;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.persistence.ResourceStore;
import org.apache.kylin.common.persistence.ResourceTool;
import org.apache.kylin.common.util.AbstractApplication;
import org.apache.kylin.common.util.OptionsHelper;
import org.apache.kylin.engine.mr.steps.CubingExecutableUtil;
import org.apache.kylin.job.common.ShellExecutable;
import org.apache.kylin.job.dao.ExecutableDao;
import org.apache.kylin.job.dao.ExecutablePO;
import org.apache.kylin.tool.CubeMetaExtractor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JobInfoExtractor
extends AbstractApplication {
    private static final Logger logger = LoggerFactory.getLogger(JobInfoExtractor.class);
    private static final Option OPTION_JOB_ID;
    private static final Option OPTION_DEST;
    private static final Option OPTION_INCLUDE_CUBE;
    private static final Option OPTION_INCLUDE_YARN_LOGS;
    private Options options;
    private KylinConfig kylinConfig;
    private CubeMetaExtractor cubeMetaExtractor;
    private ExecutableDao executableDao;
    List<String> requiredResources = Lists.newArrayList();
    List<String> yarnLogsResources = Lists.newArrayList();

    public JobInfoExtractor() {
        this.cubeMetaExtractor = new CubeMetaExtractor();
        this.options = new Options();
        this.options.addOption(OPTION_JOB_ID);
        this.options.addOption(OPTION_DEST);
        this.options.addOption(OPTION_INCLUDE_CUBE);
        this.options.addOption(OPTION_INCLUDE_YARN_LOGS);
        this.kylinConfig = KylinConfig.getInstanceFromEnv();
        this.executableDao = ExecutableDao.getInstance((KylinConfig)this.kylinConfig);
    }

    protected Options getOptions() {
        return this.options;
    }

    protected void execute(OptionsHelper optionsHelper) throws Exception {
        boolean includeYarnLogs;
        String jobId = optionsHelper.getOptionValue(OPTION_JOB_ID);
        String dest = optionsHelper.getOptionValue(OPTION_DEST);
        boolean includeCube = optionsHelper.hasOption(OPTION_INCLUDE_CUBE) ? Boolean.valueOf(optionsHelper.getOptionValue(OPTION_INCLUDE_CUBE)) : true;
        boolean bl = includeYarnLogs = optionsHelper.hasOption(OPTION_INCLUDE_YARN_LOGS) ? Boolean.valueOf(optionsHelper.getOptionValue(OPTION_INCLUDE_YARN_LOGS)) : true;
        if (StringUtils.isEmpty((String)dest)) {
            throw new RuntimeException("destDir is not set, exit directly without extracting");
        }
        if (!dest.endsWith("/")) {
            dest = dest + "/";
        }
        ExecutablePO executablePO = this.executableDao.getJob(jobId);
        this.addRequired(ExecutableDao.pathOfJob((String)jobId));
        this.addRequired(ExecutableDao.pathOfJobOutput((String)jobId));
        for (ExecutablePO task : executablePO.getTasks()) {
            this.addRequired(ExecutableDao.pathOfJob((String)task.getUuid()));
            this.addRequired(ExecutableDao.pathOfJobOutput((String)task.getUuid()));
            if (!includeYarnLogs) continue;
            this.yarnLogsResources.add(task.getUuid());
        }
        this.executeExtraction(dest);
        if (includeCube) {
            String cubeName = CubingExecutableUtil.getCubeName((Map)executablePO.getParams());
            Object[] cubeMetaArgs = new String[]{"-cube", cubeName, "-destDir", dest + "cube_" + cubeName + "/", "-includeJobs", "false"};
            logger.info("Start to extract related cube: " + StringUtils.join((Object[])cubeMetaArgs));
            this.cubeMetaExtractor.execute((String[])cubeMetaArgs);
        }
        if (includeYarnLogs) {
            logger.info("Start to related yarn job logs: " + jobId);
            for (String taskId : this.yarnLogsResources) {
                this.extractYarnLog(taskId, dest + "yarn_" + jobId + "/");
            }
        }
        logger.info("Extracted kylin jobs located at: " + new File(dest).getAbsolutePath());
    }

    private void executeExtraction(String dest) {
        logger.info("The resource paths going to be extracted:");
        for (String s : this.requiredResources) {
            logger.info(s + "(required)");
        }
        try {
            ResourceStore src = ResourceStore.getStore((KylinConfig)KylinConfig.getInstanceFromEnv());
            ResourceStore dst = ResourceStore.getStore((KylinConfig)KylinConfig.createInstanceFromUri((String)dest));
            for (String path : this.requiredResources) {
                ResourceTool.copyR((ResourceStore)src, (ResourceStore)dst, (String)path);
            }
        }
        catch (IOException e) {
            throw new RuntimeException("IOException", e);
        }
    }

    private void extractYarnLog(String taskId, String dest) throws Exception {
        Map jobInfo = this.executableDao.getJobOutput(taskId).getInfo();
        if (jobInfo.containsKey("mr_job_id")) {
            String applicationId = ((String)jobInfo.get("mr_job_id")).replace("job", "application");
            File destFile = new File(dest + applicationId + ".log");
            ShellExecutable yarnExec = new ShellExecutable();
            yarnExec.setCmd("yarn logs -applicationId " + applicationId + " > " + destFile.getAbsolutePath());
            yarnExec.setName(yarnExec.getCmd());
            logger.info(yarnExec.getCmd());
            this.kylinConfig.getCliCommandExecutor().execute(yarnExec.getCmd(), null);
        }
    }

    private void addRequired(String record) {
        logger.info("adding required resource {}", (Object)record);
        this.requiredResources.add(record);
    }

    public static void main(String[] args) {
        JobInfoExtractor extractor = new JobInfoExtractor();
        extractor.execute(args);
    }

    static {
        OptionBuilder.withArgName((String)"jobId");
        OptionBuilder.hasArg();
        OptionBuilder.isRequired((boolean)true);
        OptionBuilder.withDescription((String)"specify the Job ID to extract information. ");
        OPTION_JOB_ID = OptionBuilder.create((String)"jobId");
        OptionBuilder.withArgName((String)"destDir");
        OptionBuilder.hasArg();
        OptionBuilder.isRequired((boolean)true);
        OptionBuilder.withDescription((String)"specify the dest dir to save the related information");
        OPTION_DEST = OptionBuilder.create((String)"destDir");
        OptionBuilder.withArgName((String)"includeCube");
        OptionBuilder.hasArg();
        OptionBuilder.isRequired((boolean)false);
        OptionBuilder.withDescription((String)"set this to true if want to extract related cube info too. Default true");
        OPTION_INCLUDE_CUBE = OptionBuilder.create((String)"includeCube");
        OptionBuilder.withArgName((String)"includeYarnLogs");
        OptionBuilder.hasArg();
        OptionBuilder.isRequired((boolean)false);
        OptionBuilder.withDescription((String)"set this to true if want to extract related yarn logs too. Default true");
        OPTION_INCLUDE_YARN_LOGS = OptionBuilder.create((String)"includeYarnLogs");
    }
}

