/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.tool;

import com.google.common.collect.Lists;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.util.AbstractApplication;
import org.apache.kylin.common.util.OptionsHelper;
import org.apache.kylin.common.util.ZipFileUtils;
import org.apache.kylin.tool.CubeMetaExtractor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DiagnosisInfoCLI
extends AbstractApplication {
    private static final Logger logger = LoggerFactory.getLogger(DiagnosisInfoCLI.class);
    private static final int DEFAULT_LOG_PERIOD = 3;
    private static final Option OPTION_LOG_PERIOD;
    private static final Option OPTION_COMPRESS;
    private static final Option OPTION_DEST;
    private static final Option OPTION_PROJECT;
    private static final Option OPTION_INCLUDE_CONF;
    private CubeMetaExtractor cubeMetaExtractor = new CubeMetaExtractor();
    private Options options = new Options();
    private String exportDest;

    public DiagnosisInfoCLI() {
        this.options.addOption(OPTION_LOG_PERIOD);
        this.options.addOption(OPTION_COMPRESS);
        this.options.addOption(OPTION_DEST);
        this.options.addOption(OPTION_PROJECT);
        this.options.addOption(OPTION_INCLUDE_CONF);
    }

    public static void main(String[] args) {
        DiagnosisInfoCLI diagnosisInfoCLI = new DiagnosisInfoCLI();
        diagnosisInfoCLI.execute(args);
    }

    protected Options getOptions() {
        return this.options;
    }

    protected void execute(OptionsHelper optionsHelper) throws Exception {
        boolean includeConf;
        String project = optionsHelper.getOptionValue(this.options.getOption("project"));
        this.exportDest = optionsHelper.getOptionValue(this.options.getOption("destDir"));
        if (StringUtils.isEmpty((String)this.exportDest)) {
            throw new RuntimeException("destDir is not set, exit directly without extracting");
        }
        if (!this.exportDest.endsWith("/")) {
            this.exportDest = this.exportDest + "/";
        }
        this.exportDest = this.exportDest + "diagnosis_" + new SimpleDateFormat("YYYY_MM_dd_HH_mm_ss").format(new Date()) + "/";
        String[] cubeMetaArgs = new String[]{"-destDir", this.exportDest + "metadata", "-project", project};
        this.cubeMetaExtractor.execute(cubeMetaArgs);
        int logPeriod = optionsHelper.hasOption(OPTION_LOG_PERIOD) ? Integer.valueOf(optionsHelper.getOptionValue(OPTION_LOG_PERIOD)) : 3;
        boolean compress = optionsHelper.hasOption(OPTION_COMPRESS) ? Boolean.valueOf(optionsHelper.getOptionValue(OPTION_COMPRESS)) : true;
        boolean bl = includeConf = optionsHelper.hasOption(OPTION_INCLUDE_CONF) ? Boolean.valueOf(optionsHelper.getOptionValue(OPTION_INCLUDE_CONF)) : true;
        if (logPeriod > 0) {
            logger.info("Start to extract kylin logs in {} days", (Object)logPeriod);
            String logFolder = KylinConfig.getKylinHome() + "/logs/";
            String defaultLogFilename = "kylin.log";
            File logsDir = new File(this.exportDest + "logs/");
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
            FileUtils.forceMkdir((File)logsDir);
            ArrayList logFileNames = Lists.newArrayListWithCapacity((int)logPeriod);
            logFileNames.add("kylin.log");
            for (int i = 1; i < logPeriod; ++i) {
                Calendar todayCal = Calendar.getInstance();
                todayCal.add(5, 0 - i);
                logFileNames.add("kylin.log." + format.format(todayCal.getTime()));
            }
            for (String logFilename : logFileNames) {
                File logFile = new File(logFolder + logFilename);
                if (!logFile.exists()) continue;
                FileUtils.copyFileToDirectory((File)logFile, (File)logsDir);
            }
        }
        if (includeConf) {
            logger.info("Start to extract kylin conf files.");
            FileUtils.copyDirectoryToDirectory((File)new File(this.getConfFolder()), (File)new File(this.exportDest));
        }
        if (compress) {
            File tempZipFile = File.createTempFile("diagnosis_", ".zip");
            ZipFileUtils.compressZipFile((String)this.exportDest, (String)tempZipFile.getAbsolutePath());
            FileUtils.forceDelete((File)new File(this.exportDest));
            FileUtils.moveFileToDirectory((File)tempZipFile, (File)new File(this.exportDest), (boolean)true);
            this.exportDest = this.exportDest + tempZipFile.getName();
        }
        logger.info("Diagnosis info locates at: " + new File(this.exportDest).getAbsolutePath());
    }

    public String getExportDest() {
        return this.exportDest;
    }

    private String getConfFolder() {
        String path = System.getProperty("KYLIN_CONF");
        if (StringUtils.isNotEmpty((String)path)) {
            return path;
        }
        path = KylinConfig.getKylinHome();
        if (StringUtils.isNotEmpty((String)path)) {
            return path + File.separator + "conf";
        }
        return null;
    }

    static {
        OptionBuilder.withArgName((String)"logPeriod");
        OptionBuilder.hasArg();
        OptionBuilder.isRequired((boolean)false);
        OptionBuilder.withDescription((String)"specify how many days of kylin logs to extract. Default 3.");
        OPTION_LOG_PERIOD = OptionBuilder.create((String)"logPeriod");
        OptionBuilder.withArgName((String)"compress");
        OptionBuilder.hasArg();
        OptionBuilder.isRequired((boolean)false);
        OptionBuilder.withDescription((String)"specify whether to compress the output with zip. Default true.");
        OPTION_COMPRESS = OptionBuilder.create((String)"compress");
        OptionBuilder.withArgName((String)"destDir");
        OptionBuilder.hasArg();
        OptionBuilder.isRequired((boolean)true);
        OptionBuilder.withDescription((String)"specify the dest dir to save the related metadata");
        OPTION_DEST = OptionBuilder.create((String)"destDir");
        OptionBuilder.withArgName((String)"project");
        OptionBuilder.hasArg();
        OptionBuilder.isRequired((boolean)false);
        OptionBuilder.withDescription((String)"Specify realizations in which project to extract");
        OPTION_PROJECT = OptionBuilder.create((String)"project");
        OptionBuilder.withArgName((String)"includeConf");
        OptionBuilder.hasArg();
        OptionBuilder.isRequired((boolean)false);
        OptionBuilder.withDescription((String)"Specify whether to include conf files to extract. Default true.");
        OPTION_INCLUDE_CONF = OptionBuilder.create((String)"includeConf");
    }
}

