/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.tool;

import com.google.common.collect.Lists;
import java.io.File;
import java.io.IOException;
import java.util.List;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.OptionGroup;
import org.apache.commons.cli.Options;
import org.apache.commons.lang3.StringUtils;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.persistence.ResourceStore;
import org.apache.kylin.common.persistence.ResourceTool;
import org.apache.kylin.common.persistence.RootPersistentEntity;
import org.apache.kylin.common.util.AbstractApplication;
import org.apache.kylin.common.util.OptionsHelper;
import org.apache.kylin.cube.CubeDescManager;
import org.apache.kylin.cube.CubeInstance;
import org.apache.kylin.cube.CubeManager;
import org.apache.kylin.cube.CubeSegment;
import org.apache.kylin.cube.model.CubeDesc;
import org.apache.kylin.engine.streaming.StreamingConfig;
import org.apache.kylin.engine.streaming.StreamingManager;
import org.apache.kylin.invertedindex.IIInstance;
import org.apache.kylin.job.dao.ExecutableDao;
import org.apache.kylin.job.dao.ExecutablePO;
import org.apache.kylin.job.exception.PersistentException;
import org.apache.kylin.metadata.MetadataManager;
import org.apache.kylin.metadata.badquery.BadQueryHistoryManager;
import org.apache.kylin.metadata.model.DataModelDesc;
import org.apache.kylin.metadata.model.SegmentStatusEnum;
import org.apache.kylin.metadata.model.TableDesc;
import org.apache.kylin.metadata.project.ProjectInstance;
import org.apache.kylin.metadata.project.ProjectManager;
import org.apache.kylin.metadata.project.RealizationEntry;
import org.apache.kylin.metadata.realization.IRealization;
import org.apache.kylin.metadata.realization.RealizationRegistry;
import org.apache.kylin.metadata.realization.RealizationType;
import org.apache.kylin.source.kafka.KafkaConfigManager;
import org.apache.kylin.source.kafka.config.KafkaConfig;
import org.apache.kylin.storage.hybrid.HybridInstance;
import org.apache.kylin.storage.hybrid.HybridManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CubeMetaExtractor
extends AbstractApplication {
    private static final Logger logger = LoggerFactory.getLogger(CubeMetaExtractor.class);
    private static final Option OPTION_CUBE;
    private static final Option OPTION_HYBRID;
    private static final Option OPTION_PROJECT;
    private static final Option OPTION_INCLUDE_SEGMENTS;
    private static final Option OPTION_INCLUDE_JOB;
    private static final Option OPTION_INCLUDE_SEGMENT_DETAILS;
    private static final Option OPTION_DEST;
    private Options options = null;
    private KylinConfig kylinConfig;
    private MetadataManager metadataManager;
    private ProjectManager projectManager;
    private HybridManager hybridManager;
    private CubeManager cubeManager;
    private StreamingManager streamingManager;
    private KafkaConfigManager kafkaConfigManager;
    private CubeDescManager cubeDescManager;
    private ExecutableDao executableDao;
    private RealizationRegistry realizationRegistry;
    private BadQueryHistoryManager badQueryHistoryManager;
    boolean includeSegments;
    boolean includeJobs;
    boolean includeSegmentDetails;
    List<String> requiredResources = Lists.newArrayList();
    List<String> optionalResources = Lists.newArrayList();
    List<CubeInstance> cubesToTrimAndSave = Lists.newArrayList();

    public CubeMetaExtractor() {
        this.options = new Options();
        OptionGroup realizationOrProject = new OptionGroup();
        realizationOrProject.addOption(OPTION_CUBE);
        realizationOrProject.addOption(OPTION_PROJECT);
        realizationOrProject.addOption(OPTION_HYBRID);
        realizationOrProject.setRequired(true);
        this.options.addOptionGroup(realizationOrProject);
        this.options.addOption(OPTION_INCLUDE_SEGMENTS);
        this.options.addOption(OPTION_INCLUDE_JOB);
        this.options.addOption(OPTION_INCLUDE_SEGMENT_DETAILS);
        this.options.addOption(OPTION_DEST);
    }

    protected Options getOptions() {
        return this.options;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void execute(OptionsHelper optionsHelper) throws Exception {
        this.includeSegments = optionsHelper.hasOption(OPTION_INCLUDE_SEGMENTS) ? Boolean.valueOf(optionsHelper.getOptionValue(OPTION_INCLUDE_SEGMENTS)) : true;
        this.includeJobs = optionsHelper.hasOption(OPTION_INCLUDE_JOB) ? Boolean.valueOf(optionsHelper.getOptionValue(OPTION_INCLUDE_JOB)) : false;
        this.includeSegmentDetails = optionsHelper.hasOption(OPTION_INCLUDE_SEGMENT_DETAILS) ? Boolean.valueOf(optionsHelper.getOptionValue(OPTION_INCLUDE_SEGMENT_DETAILS)) : false;
        String dest = null;
        if (optionsHelper.hasOption(OPTION_DEST)) {
            dest = optionsHelper.getOptionValue(OPTION_DEST);
        }
        if (StringUtils.isEmpty(dest)) {
            throw new RuntimeException("destDir is not set, exit directly without extracting");
        }
        if (!dest.endsWith("/")) {
            dest = dest + "/";
        }
        this.kylinConfig = KylinConfig.getInstanceFromEnv();
        this.metadataManager = MetadataManager.getInstance((KylinConfig)this.kylinConfig);
        this.projectManager = ProjectManager.getInstance((KylinConfig)this.kylinConfig);
        this.hybridManager = HybridManager.getInstance((KylinConfig)this.kylinConfig);
        this.cubeManager = CubeManager.getInstance((KylinConfig)this.kylinConfig);
        this.cubeDescManager = CubeDescManager.getInstance((KylinConfig)this.kylinConfig);
        this.streamingManager = StreamingManager.getInstance((KylinConfig)this.kylinConfig);
        this.kafkaConfigManager = KafkaConfigManager.getInstance((KylinConfig)this.kylinConfig);
        this.executableDao = ExecutableDao.getInstance((KylinConfig)this.kylinConfig);
        this.realizationRegistry = RealizationRegistry.getInstance((KylinConfig)this.kylinConfig);
        this.badQueryHistoryManager = BadQueryHistoryManager.getInstance((KylinConfig)this.kylinConfig);
        if (optionsHelper.hasOption(OPTION_PROJECT)) {
            String projectName = optionsHelper.getOptionValue(OPTION_PROJECT);
            ProjectInstance projectInstance = this.projectManager.getProject(projectName);
            if (projectInstance == null) {
                throw new IllegalArgumentException("Project " + projectName + " does not exist");
            }
            this.addRequired(projectInstance.getResourcePath());
            List realizationEntries = projectInstance.getRealizationEntries();
            for (RealizationEntry realizationEntry : realizationEntries) {
                this.retrieveResourcePath(this.getRealization(realizationEntry));
            }
            this.addOptional(this.badQueryHistoryManager.getBadQueriesForProject(projectName).getResourcePath());
        } else if (optionsHelper.hasOption(OPTION_CUBE)) {
            String cubeName = optionsHelper.getOptionValue(OPTION_CUBE);
            IRealization realization = this.cubeManager.getRealization(cubeName);
            if (realization == null) throw new IllegalArgumentException("No cube found with name of " + cubeName);
            this.retrieveResourcePath(realization);
        } else if (optionsHelper.hasOption(OPTION_HYBRID)) {
            String hybridName = optionsHelper.getOptionValue(OPTION_HYBRID);
            IRealization realization = this.hybridManager.getRealization(hybridName);
            if (realization == null) throw new IllegalArgumentException("No hybrid found with name of" + hybridName);
            this.retrieveResourcePath(realization);
        }
        this.executeExtraction(dest);
        logger.info("Extracted metadata files located at: " + new File(dest).getAbsolutePath());
    }

    private void executeExtraction(String dest) {
        logger.info("The resource paths going to be extracted:");
        for (String s : this.requiredResources) {
            logger.info(s + "(required)");
        }
        for (String s : this.optionalResources) {
            logger.info(s + "(optional)");
        }
        for (CubeInstance cube : this.cubesToTrimAndSave) {
            logger.info("Cube {} will be trimmed and extracted", (Object)cube);
        }
        try {
            ResourceStore src = ResourceStore.getStore((KylinConfig)KylinConfig.getInstanceFromEnv());
            ResourceStore dst = ResourceStore.getStore((KylinConfig)KylinConfig.createInstanceFromUri((String)dest));
            for (String path : this.requiredResources) {
                ResourceTool.copyR((ResourceStore)src, (ResourceStore)dst, (String)path);
            }
            for (String path : this.optionalResources) {
                try {
                    ResourceTool.copyR((ResourceStore)src, (ResourceStore)dst, (String)path);
                }
                catch (Exception e) {
                    logger.warn("Exception when copying optional resource {}. May be caused by resource missing. Ignore it.");
                }
            }
            for (CubeInstance cube : this.cubesToTrimAndSave) {
                CubeInstance trimmedCube = CubeInstance.getCopyOf((CubeInstance)cube);
                trimmedCube.getSegments().clear();
                trimmedCube.setUuid(cube.getUuid());
                dst.putResource(trimmedCube.getResourcePath(), (RootPersistentEntity)trimmedCube, CubeManager.CUBE_SERIALIZER);
            }
        }
        catch (IOException e) {
            throw new RuntimeException("IOException", e);
        }
    }

    private IRealization getRealization(RealizationEntry realizationEntry) {
        return this.realizationRegistry.getRealization(realizationEntry.getType(), realizationEntry.getRealization());
    }

    private void dealWithStreaming(CubeInstance cube) {
        for (StreamingConfig streamingConfig : this.streamingManager.listAllStreaming()) {
            if (streamingConfig.getName() == null || !streamingConfig.getName().equalsIgnoreCase(cube.getFactTable())) continue;
            this.addRequired(StreamingConfig.concatResourcePath((String)streamingConfig.getName()));
            this.addRequired(KafkaConfig.concatResourcePath((String)streamingConfig.getName()));
        }
    }

    private void retrieveResourcePath(IRealization realization) {
        logger.info("Deal with realization {} of type {}", (Object)realization.getName(), (Object)realization.getType());
        if (realization instanceof CubeInstance) {
            CubeInstance cube = (CubeInstance)realization;
            String descName = cube.getDescName();
            CubeDesc cubeDesc = this.cubeDescManager.getCubeDesc(descName);
            String modelName = cubeDesc.getModelName();
            DataModelDesc modelDesc = this.metadataManager.getDataModelDesc(modelName);
            this.dealWithStreaming(cube);
            for (String tableName : modelDesc.getAllTables()) {
                this.addRequired(TableDesc.concatResourcePath((String)tableName));
                this.addOptional(TableDesc.concatExdResourcePath((String)tableName));
            }
            this.addRequired(DataModelDesc.concatResourcePath((String)modelDesc.getName()));
            this.addRequired(CubeDesc.concatResourcePath((String)cubeDesc.getName()));
            if (this.includeSegments) {
                this.addRequired(CubeInstance.concatResourcePath((String)cube.getName()));
                for (CubeSegment segment : cube.getSegments(SegmentStatusEnum.READY)) {
                    if (this.includeSegmentDetails) {
                        for (String dictPat : segment.getDictionaryPaths()) {
                            this.addRequired(dictPat);
                        }
                        for (String snapshotPath : segment.getSnapshotPaths()) {
                            this.addRequired(snapshotPath);
                        }
                        this.addRequired(segment.getStatisticsResourcePath());
                    }
                    if (!this.includeJobs) continue;
                    String lastJobId = segment.getLastBuildJobID();
                    if (StringUtils.isEmpty((CharSequence)lastJobId)) {
                        throw new RuntimeException("No job exist for segment :" + segment);
                    }
                    try {
                        ExecutablePO executablePO = this.executableDao.getJob(lastJobId);
                        this.addRequired(ExecutableDao.pathOfJob((String)lastJobId));
                        this.addRequired(ExecutableDao.pathOfJobOutput((String)lastJobId));
                        for (ExecutablePO task : executablePO.getTasks()) {
                            this.addRequired(ExecutableDao.pathOfJob((String)task.getUuid()));
                            this.addRequired(ExecutableDao.pathOfJobOutput((String)task.getUuid()));
                        }
                    }
                    catch (PersistentException e) {
                        throw new RuntimeException("PersistentException", e);
                    }
                }
            } else {
                if (this.includeJobs) {
                    logger.warn("It's useless to set includeJobs to true when includeSegments is set to false");
                }
                this.cubesToTrimAndSave.add(cube);
            }
        } else if (realization instanceof HybridInstance) {
            HybridInstance hybridInstance = (HybridInstance)realization;
            this.addRequired(HybridInstance.concatResourcePath((String)hybridInstance.getName()));
            for (IRealization iRealization : hybridInstance.getRealizations()) {
                if (iRealization.getType() != RealizationType.CUBE) {
                    throw new RuntimeException("Hybrid " + iRealization.getName() + " contains non cube child " + iRealization.getName() + " with type " + iRealization.getType());
                }
                this.retrieveResourcePath(iRealization);
            }
        } else {
            if (realization instanceof IIInstance) {
                throw new IllegalStateException("Does not support extract II instance or hybrid that contains II");
            }
            throw new IllegalStateException("Unknown realization type: " + realization.getType());
        }
    }

    private void addRequired(String record) {
        logger.info("adding required resource {}", (Object)record);
        this.requiredResources.add(record);
    }

    private void addOptional(String record) {
        logger.info("adding optional resource {}", (Object)record);
        this.optionalResources.add(record);
    }

    public static void main(String[] args) {
        CubeMetaExtractor extractor = new CubeMetaExtractor();
        extractor.execute(args);
    }

    static {
        OptionBuilder.withArgName((String)"cube");
        OptionBuilder.hasArg();
        OptionBuilder.isRequired((boolean)false);
        OptionBuilder.withDescription((String)"Specify which cube to extract");
        OPTION_CUBE = OptionBuilder.create((String)"cube");
        OptionBuilder.withArgName((String)"hybrid");
        OptionBuilder.hasArg();
        OptionBuilder.isRequired((boolean)false);
        OptionBuilder.withDescription((String)"Specify which hybrid to extract");
        OPTION_HYBRID = OptionBuilder.create((String)"hybrid");
        OptionBuilder.withArgName((String)"project");
        OptionBuilder.hasArg();
        OptionBuilder.isRequired((boolean)false);
        OptionBuilder.withDescription((String)"Specify realizations in which project to extract");
        OPTION_PROJECT = OptionBuilder.create((String)"project");
        OptionBuilder.withArgName((String)"includeSegments");
        OptionBuilder.hasArg();
        OptionBuilder.isRequired((boolean)false);
        OptionBuilder.withDescription((String)"set this to true if want extract the segments info. Default true");
        OPTION_INCLUDE_SEGMENTS = OptionBuilder.create((String)"includeSegments");
        OptionBuilder.withArgName((String)"includeJobs");
        OptionBuilder.hasArg();
        OptionBuilder.isRequired((boolean)false);
        OptionBuilder.withDescription((String)"set this to true if want to extract job info/outputs too. Default false");
        OPTION_INCLUDE_JOB = OptionBuilder.create((String)"includeJobs");
        OptionBuilder.withArgName((String)"includeSegmentDetails");
        OptionBuilder.hasArg();
        OptionBuilder.isRequired((boolean)false);
        OptionBuilder.withDescription((String)"set this to true if want to extract segment details too, such as dict, tablesnapshot. Default false");
        OPTION_INCLUDE_SEGMENT_DETAILS = OptionBuilder.create((String)"includeSegmentDetails");
        OptionBuilder.withArgName((String)"destDir");
        OptionBuilder.hasArg();
        OptionBuilder.isRequired((boolean)false);
        OptionBuilder.withDescription((String)"specify the dest dir to save the related metadata");
        OPTION_DEST = OptionBuilder.create((String)"destDir");
    }
}

