/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.utils;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.net.InetSocketAddress;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.TimeoutException;
import kafka.admin.RackAwareMode;
import kafka.api.Request$;
import kafka.server.KafkaConfig;
import kafka.server.KafkaServer;
import kafka.server.KafkaServer$;
import kafka.zk.AdminZkClient;
import kafka.zk.KafkaZkClient;
import kafka.zk.KafkaZkClient$;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.message.UpdateMetadataRequestData;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.serialization.StringSerializer;
import org.apache.kafka.common.utils.Time;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkException;
import org.apache.spark.internal.Logging;
import org.apache.spark.util.ShutdownHookManager$;
import org.apache.spark.util.Utils$;
import org.apache.zookeeper.server.NIOServerCnxnFactory;
import org.apache.zookeeper.server.ZooKeeperServer;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Iterable$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0001\tUfa\u0002#F!\u0003\r\tA\u0014\u0005\u00067\u0002!\t\u0001\u0018\u0005\bA\u0002\u0011\r\u0011\"\u0003b\u0011\u001dQ\u0007\u00011A\u0005\n-Dqa\u001c\u0001A\u0002\u0013%\u0001\u000fC\u0004t\u0001\t\u0007I\u0011B6\t\u000fQ\u0004!\u0019!C\u0005W\"IQ\u000f\u0001a\u0001\u0002\u0004%IA\u001e\u0005\f\u0003C\u0002\u0001\u0019!a\u0001\n\u0013\t\u0019\u0007C\u0006\u0002h\u0001\u0001\r\u00111A\u0005\n\u0005%\u0004bCA>\u0001\u0001\u0007\t\u0019!C\u0005\u0003{B1\"!!\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u0002\u0004\"Y\u00111\u0012\u0001A\u0002\u0003\u0007I\u0011BAG\u0011!\t\t\n\u0001b\u0001\n\u0013\t\u0007\u0002CAJ\u0001\u0001\u0007I\u0011B6\t\u0013\u0005U\u0005\u00011A\u0005\n\u0005]\u0005bCAN\u0001\u0001\u0007\t\u0019!C\u0005\u0003;C1\"!+\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u0002,\"Y\u0011Q\u0007\u0001A\u0002\u0003\u0007I\u0011BAX\u0011-\t9\f\u0001a\u0001\u0002\u0004%I!!/\t\u0017\u0005u\u0006\u00011AA\u0002\u0013%\u0011q\u0018\u0005\f\u0003#\u0004\u0001\u0019!a\u0001\n\u0013\t\u0019\u000eC\u0005\u0002X\u0002\u0001\r\u0011\"\u0003\u0002Z\"I\u0011\u0011\u001d\u0001A\u0002\u0013%\u00111\u001d\u0005\n\u0003O\u0004\u0001\u0019!C\u0005\u00033D\u0011\"!;\u0001\u0001\u0004%I!a;\t\u0013\u0005=\b\u00011A\u0005\n\u0005E\b\"CAz\u0001\u0001\u0007I\u0011BA{\u0011\u0019\tI\u0010\u0001C\u0001y\"1\u00111 \u0001\u0005\u0002qDq!!@\u0001\t\u0003\tI\u0007\u0003\u0004\u0002\u0000\u0002!I\u0001\u0018\u0005\u0007\u0005\u0003\u0001A\u0011\u0002/\t\r\t\r\u0001\u0001\"\u0001]\u0011\u0019\u0011)\u0001\u0001C\u00019\"9!q\u0001\u0001\u0005\u0002\t%\u0001b\u0002B\u0004\u0001\u0011\u0005!1\u0005\u0005\b\u0005\u000f\u0001A\u0011\u0001B\u0015\u0011\u001d\u0011i\u0003\u0001C\u0001\u0005_AqA!\f\u0001\t\u0003\u0011\u0019\u0005C\u0004\u0003.\u0001!\tA!\u0014\t\r\tm\u0003\u0001\"\u0001]\u0011\u001d\u0011i\u0003\u0001C\u0001\u0005;B\u0001Ba\u001a\u0001\u0005\u0004%\t!\u0019\u0005\b\u0005S\u0002A\u0011\u0002B6\u0011\u001d\u0011i\u0007\u0001C\u0005\u0005WBqAa\u001c\u0001\t\u0003\u0011\t\bC\u0004\u0003,\u0002!IA!,\u0007\te\u0004AA\u001f\u0005\twB\u0012)\u0019!C\u0001y\"I\u0011q\u0002\u0019\u0003\u0002\u0003\u0006I! \u0005\b\u0003#\u0001D\u0011AA\n\u0011%\t9\u0002\rb\u0001\n\u0003\tI\u0002\u0003\u0005\u0002(A\u0002\u000b\u0011BA\u000e\u0011%\tI\u0003\rb\u0001\n\u0003\tI\u0002\u0003\u0005\u0002,A\u0002\u000b\u0011BA\u000e\u0011!)\bG1A\u0005\u0002\u00055\u0002\u0002CA\u001fa\u0001\u0006I!a\f\t\u0019\u0005}\u0002\u0007%A\u0001\u0004\u0003\u0006I!!\u0011\t\u0011\u0005\u001d\u0003G1A\u0005\u0002\u0005Dq!!\u00131A\u0003%!\r\u0003\u0005\u0002LA\u0012\r\u0011\"\u0001l\u0011\u001d\ti\u0005\rQ\u0001\n1D\u0011\"a\u00141\u0005\u0004%\t!!\u0015\t\u0011\u0005e\u0003\u0007)A\u0005\u0003'B\u0001\"a\u00171\u0005\u0004%\ta\u001b\u0005\b\u0003;\u0002\u0004\u0015!\u0003m\u0011\u0019\ty\u0006\rC\u00019\nq1*\u00194lCR+7\u000f^+uS2\u001c(B\u0001$H\u0003\u0015)H/\u001b7t\u0015\tA\u0015*A\u0003ta\u0006\u00148N\u0003\u0002K\u0017\u00061\u0011\r]1dQ\u0016T\u0011\u0001T\u0001\u0004_J<7\u0001A\n\u0004\u0001=+\u0006C\u0001)T\u001b\u0005\t&\"\u0001*\u0002\u000bM\u001c\u0017\r\\1\n\u0005Q\u000b&AB!osJ+g\r\u0005\u0002W36\tqK\u0003\u0002Y\u000f\u0006A\u0011N\u001c;fe:\fG.\u0003\u0002[/\n9Aj\\4hS:<\u0017A\u0002\u0013j]&$H\u0005F\u0001^!\t\u0001f,\u0003\u0002`#\n!QK\\5u\u0003\u0019Q8\u000eS8tiV\t!\r\u0005\u0002dQ6\tAM\u0003\u0002fM\u0006!A.\u00198h\u0015\u00059\u0017\u0001\u00026bm\u0006L!!\u001b3\u0003\rM#(/\u001b8h\u0003\u0019Q8\u000eU8siV\tA\u000e\u0005\u0002Q[&\u0011a.\u0015\u0002\u0004\u0013:$\u0018A\u0003>l!>\u0014Ho\u0018\u0013fcR\u0011Q,\u001d\u0005\be\u0012\t\t\u00111\u0001m\u0003\rAH%M\u0001\u0014u.\u001cuN\u001c8fGRLwN\u001c+j[\u0016|W\u000f^\u0001\u0011u.\u001cVm]:j_:$\u0016.\\3pkR\f\u0011B_8pW\u0016,\u0007/\u001a:\u0016\u0003]\u0004\"\u0001\u001f\u0019\u000e\u0003\u0001\u0011\u0011#R7cK\u0012$W\r\u001a.p_.,W\r]3s'\t\u0001t*A\u0005{W\u000e{gN\\3diV\tQ\u0010E\u0002\u007f\u0003\u0017q1a`A\u0004!\r\t\t!U\u0007\u0003\u0003\u0007Q1!!\u0002N\u0003\u0019a$o\\8u}%\u0019\u0011\u0011B)\u0002\rA\u0013X\rZ3g\u0013\rI\u0017Q\u0002\u0006\u0004\u0003\u0013\t\u0016A\u0003>l\u0007>tg.Z2uA\u00051A(\u001b8jiz\"2a^A\u000b\u0011\u0015Y8\u00071\u0001~\u0003-\u0019h.\u00199tQ>$H)\u001b:\u0016\u0005\u0005m\u0001\u0003BA\u000f\u0003Gi!!a\b\u000b\u0007\u0005\u0005b-\u0001\u0002j_&!\u0011QEA\u0010\u0005\u00111\u0015\u000e\\3\u0002\u0019Mt\u0017\r]:i_R$\u0015N\u001d\u0011\u0002\r1|w\rR5s\u0003\u001dawn\u001a#je\u0002*\"!a\f\u0011\t\u0005E\u0012\u0011H\u0007\u0003\u0003gQA!!\u000e\u00028\u000511/\u001a:wKJT!!^%\n\t\u0005m\u00121\u0007\u0002\u00105>|7*Z3qKJ\u001cVM\u001d<fe\u0006Q!p\\8lK\u0016\u0004XM\u001d\u0011\u0002\u0007a$#\u0007E\u0003Q\u0003\u0007\u0012G.C\u0002\u0002FE\u0013a\u0001V;qY\u0016\u0014\u0014AA5q\u0003\rI\u0007\u000fI\u0001\u0005a>\u0014H/A\u0003q_J$\b%A\u0004gC\u000e$xN]=\u0016\u0005\u0005M\u0003\u0003BA\u0019\u0003+JA!a\u0016\u00024\t!b*S(TKJ4XM]\"oq:4\u0015m\u0019;pef\f\u0001BZ1di>\u0014\u0018\u0010I\u0001\u000bC\u000e$X/\u00197Q_J$\u0018aC1diV\fG\u000eU8si\u0002\n\u0001b\u001d5vi\u0012|wO\\\u0001\u000eu>|7.Z3qKJ|F%Z9\u0015\u0007u\u000b)\u0007C\u0004s\u0011\u0005\u0005\t\u0019A<\u0002\u000fi\\W\u000b^5mgV\u0011\u00111\u000e\t\u0005\u0003[\n9(\u0004\u0002\u0002p)!\u0011\u0011OA:\u0003\tQ8N\u0003\u0002\u0002v\u0005)1.\u00194lC&!\u0011\u0011PA8\u00055Y\u0015MZ6b5.\u001cE.[3oi\u0006Y!p[+uS2\u001cx\fJ3r)\ri\u0016q\u0010\u0005\te*\t\t\u00111\u0001\u0002l\u0005Y\u0011\rZ7j]\u000ec\u0017.\u001a8u+\t\t)\t\u0005\u0003\u0002n\u0005\u001d\u0015\u0002BAE\u0003_\u0012Q\"\u00113nS:T6n\u00117jK:$\u0018aD1e[&t7\t\\5f]R|F%Z9\u0015\u0007u\u000by\t\u0003\u0005s\u0019\u0005\u0005\t\u0019AAC\u0003)\u0011'o\\6fe\"{7\u000f^\u0001\u000bEJ|7.\u001a:Q_J$\u0018A\u00042s_.,'\u000fU8si~#S-\u001d\u000b\u0004;\u0006e\u0005b\u0002:\u0010\u0003\u0003\u0005\r\u0001\\\u0001\u000bEJ|7.\u001a:D_:4WCAAP!\u0011\t\t+!*\u000e\u0005\u0005\r&\u0002BA\u001b\u0003gJA!a*\u0002$\nY1*\u00194lC\u000e{gNZ5h\u00039\u0011'o\\6fe\u000e{gNZ0%KF$2!XAW\u0011!\u0011\u0018#!AA\u0002\u0005}UCAAY!\u0011\t\t+a-\n\t\u0005U\u00161\u0015\u0002\f\u0017\u000647.Y*feZ,'/\u0001\u0006tKJ4XM]0%KF$2!XA^\u0011!\u00118#!AA\u0002\u0005E\u0016\u0001\u00039s_\u0012,8-\u001a:\u0016\u0005\u0005\u0005\u0007CBAb\u0003\u001blX0\u0004\u0002\u0002F*!\u0011QXAd\u0015\u0011\tI-a3\u0002\u000f\rd\u0017.\u001a8ug*\u0019\u0011QO%\n\t\u0005=\u0017Q\u0019\u0002\u000e\u0017\u000647.\u0019)s_\u0012,8-\u001a:\u0002\u0019A\u0014x\u000eZ;dKJ|F%Z9\u0015\u0007u\u000b)\u000e\u0003\u0005s+\u0005\u0005\t\u0019AAa\u0003\u001dQ8NU3bIf,\"!a7\u0011\u0007A\u000bi.C\u0002\u0002`F\u0013qAQ8pY\u0016\fg.A\u0006{WJ+\u0017\rZ=`I\u0015\fHcA/\u0002f\"A!oFA\u0001\u0002\u0004\tY.A\u0006ce>\\WM\u001d*fC\u0012L\u0018a\u00042s_.,'OU3bIf|F%Z9\u0015\u0007u\u000bi\u000f\u0003\u0005s3\u0005\u0005\t\u0019AAn\u00031aW-Y6EKR,7\r^8s+\u0005y\u0015\u0001\u00057fC.$U\r^3di>\u0014x\fJ3r)\ri\u0016q\u001f\u0005\ben\t\t\u00111\u0001P\u0003%Q8.\u00113ee\u0016\u001c8/A\u0007ce>\\WM]!eIJ,7o]\u0001\u0010u>|7.Z3qKJ\u001cE.[3oi\u000612/\u001a;va\u0016k'-\u001a3eK\u0012Tvn\\6fKB,'/\u0001\rtKR,\b/R7cK\u0012$W\rZ&bM.\f7+\u001a:wKJ\fQa]3ukB\f\u0001\u0002^3be\u0012|wO\\\u0001\fGJ,\u0017\r^3U_BL7\rF\u0004^\u0005\u0017\u0011yAa\u0005\t\r\t51\u00051\u0001~\u0003\u0015!x\u000e]5d\u0011\u0019\u0011\tb\ta\u0001Y\u0006Q\u0001/\u0019:uSRLwN\\:\t\u000f\tU1\u00051\u0001\u0003\u0018\u000511m\u001c8gS\u001e\u0004BA!\u0007\u0003 5\u0011!1\u0004\u0006\u0004\u0005;1\u0017\u0001B;uS2LAA!\t\u0003\u001c\tQ\u0001K]8qKJ$\u0018.Z:\u0015\u000bu\u0013)Ca\n\t\r\t5A\u00051\u0001~\u0011\u0019\u0011\t\u0002\na\u0001YR\u0019QLa\u000b\t\r\t5Q\u00051\u0001~\u00031\u0019XM\u001c3NKN\u001c\u0018mZ3t)\u0015i&\u0011\u0007B\u001a\u0011\u0019\u0011iA\na\u0001{\"9!Q\u0007\u0014A\u0002\t]\u0012!D7fgN\fw-\u001a+p\rJ,\u0017\u000fE\u0004\u0003\u001a\teRP!\u0010\n\t\tm\"1\u0004\u0002\u0004\u001b\u0006\u0004\bcA2\u0003@%\u0019!\u0011\t3\u0003\u000f%sG/Z4feR)QL!\u0012\u0003H!1!QB\u0014A\u0002uDqA!\u000e(\u0001\u0004\u0011I\u0005E\u0003\u007f\u0005\u0017jH.\u0003\u0003\u0003<\u00055A#B/\u0003P\tE\u0003B\u0002B\u0007Q\u0001\u0007Q\u0010C\u0004\u0003T!\u0002\rA!\u0016\u0002\u00115,7o]1hKN\u0004B\u0001\u0015B,{&\u0019!\u0011L)\u0003\u000b\u0005\u0013(/Y=\u0002\u000b\u0019dWo\u001d5\u0015\u000bu\u0013yF!\u0019\t\r\t5!\u00061\u0001~\u0011\u001d\u0011\u0019F\u000ba\u0001\u0005G\u0002R\u0001\u0015B,\u0005K\u0002R\u0001UA\"{v\fAB\u0019:pW\u0016\u0014Hj\\4ESJ\f1C\u0019:pW\u0016\u00148i\u001c8gS\u001e,(/\u0019;j_:,\"Aa\u0006\u0002+A\u0014x\u000eZ;dKJ\u001cuN\u001c4jOV\u0014\u0018\r^5p]\u0006QQM^3oiV\fG\u000e\\=\u0016\t\tM$1\u0010\u000b\u0007\u0005k\u00129Ja*\u0015\t\t]$Q\u0012\t\u0005\u0005s\u0012Y\b\u0004\u0001\u0005\u000f\tudF1\u0001\u0003\u0000\t\tA+\u0005\u0003\u0003\u0002\n\u001d\u0005c\u0001)\u0003\u0004&\u0019!QQ)\u0003\u000f9{G\u000f[5oOB\u0019\u0001K!#\n\u0007\t-\u0015KA\u0002B]fD\u0001Ba$/\t\u0003\u0007!\u0011S\u0001\u0005MVt7\rE\u0003Q\u0005'\u00139(C\u0002\u0003\u0016F\u0013\u0001\u0002\u00102z]\u0006lWM\u0010\u0005\b\u00053s\u0003\u0019\u0001BN\u0003\u001d!\u0018.\\3pkR\u0004BA!(\u0003$6\u0011!q\u0014\u0006\u0004\u0005C;\u0015!C:ue\u0016\fW.\u001b8h\u0013\u0011\u0011)Ka(\u0003\tQKW.\u001a\u0005\b\u0005Ss\u0003\u0019\u0001BN\u0003!Ig\u000e^3sm\u0006d\u0017!H<bSR,f\u000e^5m\u001b\u0016$\u0018\rZ1uC&\u001b\bK]8qC\u001e\fG/\u001a3\u0015\u000bu\u0013yK!-\t\r\t5q\u00061\u0001~\u0011\u0019\u0011\u0019l\fa\u0001Y\u0006I\u0001/\u0019:uSRLwN\u001c")
public interface KafkaTestUtils
extends Logging {
    public void org$apache$spark$utils$KafkaTestUtils$_setter_$org$apache$spark$utils$KafkaTestUtils$$zkHost_$eq(String var1);

    public void org$apache$spark$utils$KafkaTestUtils$_setter_$org$apache$spark$utils$KafkaTestUtils$$zkConnectionTimeout_$eq(int var1);

    public void org$apache$spark$utils$KafkaTestUtils$_setter_$org$apache$spark$utils$KafkaTestUtils$$zkSessionTimeout_$eq(int var1);

    public void org$apache$spark$utils$KafkaTestUtils$_setter_$org$apache$spark$utils$KafkaTestUtils$$brokerHost_$eq(String var1);

    public void org$apache$spark$utils$KafkaTestUtils$_setter_$brokerLogDir_$eq(String var1);

    public String org$apache$spark$utils$KafkaTestUtils$$zkHost();

    public int org$apache$spark$utils$KafkaTestUtils$$zkPort();

    public void org$apache$spark$utils$KafkaTestUtils$$zkPort_$eq(int var1);

    public int org$apache$spark$utils$KafkaTestUtils$$zkConnectionTimeout();

    public int org$apache$spark$utils$KafkaTestUtils$$zkSessionTimeout();

    public EmbeddedZookeeper org$apache$spark$utils$KafkaTestUtils$$zookeeper();

    public void org$apache$spark$utils$KafkaTestUtils$$zookeeper_$eq(EmbeddedZookeeper var1);

    public KafkaZkClient org$apache$spark$utils$KafkaTestUtils$$zkUtils();

    public void org$apache$spark$utils$KafkaTestUtils$$zkUtils_$eq(KafkaZkClient var1);

    public AdminZkClient org$apache$spark$utils$KafkaTestUtils$$adminClient();

    public void org$apache$spark$utils$KafkaTestUtils$$adminClient_$eq(AdminZkClient var1);

    public String org$apache$spark$utils$KafkaTestUtils$$brokerHost();

    public int org$apache$spark$utils$KafkaTestUtils$$brokerPort();

    public void org$apache$spark$utils$KafkaTestUtils$$brokerPort_$eq(int var1);

    public KafkaConfig org$apache$spark$utils$KafkaTestUtils$$brokerConf();

    public void org$apache$spark$utils$KafkaTestUtils$$brokerConf_$eq(KafkaConfig var1);

    public KafkaServer org$apache$spark$utils$KafkaTestUtils$$server();

    public void org$apache$spark$utils$KafkaTestUtils$$server_$eq(KafkaServer var1);

    public KafkaProducer<String, String> org$apache$spark$utils$KafkaTestUtils$$producer();

    public void org$apache$spark$utils$KafkaTestUtils$$producer_$eq(KafkaProducer<String, String> var1);

    public boolean org$apache$spark$utils$KafkaTestUtils$$zkReady();

    public void org$apache$spark$utils$KafkaTestUtils$$zkReady_$eq(boolean var1);

    public boolean org$apache$spark$utils$KafkaTestUtils$$brokerReady();

    public void org$apache$spark$utils$KafkaTestUtils$$brokerReady_$eq(boolean var1);

    public Object org$apache$spark$utils$KafkaTestUtils$$leakDetector();

    public void org$apache$spark$utils$KafkaTestUtils$$leakDetector_$eq(Object var1);

    public static /* synthetic */ String zkAddress$(KafkaTestUtils $this) {
        return $this.zkAddress();
    }

    default public String zkAddress() {
        Predef$.MODULE$.assert(this.org$apache$spark$utils$KafkaTestUtils$$zkReady(), (Function0 & Serializable & scala.Serializable)() -> "Zookeeper not setup yet or already torn down, cannot get zookeeper address");
        return new StringBuilder(1).append(this.org$apache$spark$utils$KafkaTestUtils$$zkHost()).append(":").append(this.org$apache$spark$utils$KafkaTestUtils$$zkPort()).toString();
    }

    public static /* synthetic */ String brokerAddress$(KafkaTestUtils $this) {
        return $this.brokerAddress();
    }

    default public String brokerAddress() {
        Predef$.MODULE$.assert(this.org$apache$spark$utils$KafkaTestUtils$$brokerReady(), (Function0 & Serializable & scala.Serializable)() -> "Kafka not setup yet or already torn down, cannot get broker address");
        return new StringBuilder(1).append(this.org$apache$spark$utils$KafkaTestUtils$$brokerHost()).append(":").append(this.org$apache$spark$utils$KafkaTestUtils$$brokerPort()).toString();
    }

    public static /* synthetic */ KafkaZkClient zookeeperClient$(KafkaTestUtils $this) {
        return $this.zookeeperClient();
    }

    default public KafkaZkClient zookeeperClient() {
        Predef$.MODULE$.assert(this.org$apache$spark$utils$KafkaTestUtils$$zkReady(), (Function0 & Serializable & scala.Serializable)() -> "Zookeeper not setup yet or already torn down, cannot get zookeeper client");
        return (KafkaZkClient)Option$.MODULE$.apply((Object)this.org$apache$spark$utils$KafkaTestUtils$$zkUtils()).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new IllegalStateException("Zookeeper client is not yet initialized");
        });
    }

    private void setupEmbeddedZookeeper() {
        this.org$apache$spark$utils$KafkaTestUtils$$zookeeper_$eq(new EmbeddedZookeeper(this, new StringBuilder(1).append(this.org$apache$spark$utils$KafkaTestUtils$$zkHost()).append(":").append(this.org$apache$spark$utils$KafkaTestUtils$$zkPort()).toString()));
        this.org$apache$spark$utils$KafkaTestUtils$$zkPort_$eq(this.org$apache$spark$utils$KafkaTestUtils$$zookeeper().actualPort());
        this.org$apache$spark$utils$KafkaTestUtils$$zkUtils_$eq(KafkaZkClient$.MODULE$.apply(new StringBuilder(1).append(this.org$apache$spark$utils$KafkaTestUtils$$zkHost()).append(":").append(this.org$apache$spark$utils$KafkaTestUtils$$zkPort()).toString(), false, this.org$apache$spark$utils$KafkaTestUtils$$zkSessionTimeout(), this.org$apache$spark$utils$KafkaTestUtils$$zkConnectionTimeout(), 10, Time.SYSTEM, KafkaZkClient$.MODULE$.apply$default$7(), KafkaZkClient$.MODULE$.apply$default$8(), KafkaZkClient$.MODULE$.apply$default$9(), KafkaZkClient$.MODULE$.apply$default$10()));
        this.org$apache$spark$utils$KafkaTestUtils$$zkReady_$eq(true);
    }

    private void setupEmbeddedKafkaServer() {
        Predef$.MODULE$.assert(this.org$apache$spark$utils$KafkaTestUtils$$zkReady(), (Function0 & Serializable & scala.Serializable)() -> "Zookeeper should be set up beforehand");
        Utils$.MODULE$.startServiceOnPort(this.org$apache$spark$utils$KafkaTestUtils$$brokerPort(), (Function1 & Serializable & scala.Serializable)port -> KafkaTestUtils.$anonfun$setupEmbeddedKafkaServer$2(this, BoxesRunTime.unboxToInt((Object)port)), new SparkConf(), "KafkaBroker");
        this.org$apache$spark$utils$KafkaTestUtils$$brokerReady_$eq(true);
    }

    public static /* synthetic */ void setup$(KafkaTestUtils $this) {
        $this.setup();
    }

    default public void setup() {
        SparkException exception = new SparkException("It was created at: ");
        this.org$apache$spark$utils$KafkaTestUtils$$leakDetector_$eq(ShutdownHookManager$.MODULE$.addShutdownHook((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.logError((Function0 & Serializable & scala.Serializable)() -> "Found a leak KafkaTestUtils.", (Throwable)exception)));
        this.setupEmbeddedZookeeper();
        this.setupEmbeddedKafkaServer();
    }

    public static /* synthetic */ void teardown$(KafkaTestUtils $this) {
        $this.teardown();
    }

    default public void teardown() {
        block3: {
            Object object = this.org$apache$spark$utils$KafkaTestUtils$$leakDetector() != null ? BoxesRunTime.boxToBoolean((boolean)ShutdownHookManager$.MODULE$.removeShutdownHook(this.org$apache$spark$utils$KafkaTestUtils$$leakDetector())) : BoxedUnit.UNIT;
            this.org$apache$spark$utils$KafkaTestUtils$$brokerReady_$eq(false);
            this.org$apache$spark$utils$KafkaTestUtils$$zkReady_$eq(false);
            if (this.org$apache$spark$utils$KafkaTestUtils$$producer() != null) {
                this.org$apache$spark$utils$KafkaTestUtils$$producer().close();
                this.org$apache$spark$utils$KafkaTestUtils$$producer_$eq(null);
            }
            if (this.org$apache$spark$utils$KafkaTestUtils$$server() != null) {
                this.org$apache$spark$utils$KafkaTestUtils$$server().shutdown();
                this.org$apache$spark$utils$KafkaTestUtils$$server().awaitShutdown();
                this.org$apache$spark$utils$KafkaTestUtils$$server_$eq(null);
            }
            this.org$apache$spark$utils$KafkaTestUtils$$brokerConf().logDirs().foreach((Function1 & Serializable & scala.Serializable)f -> {
                KafkaTestUtils.$anonfun$teardown$1(this, f);
                return BoxedUnit.UNIT;
            });
            if (this.org$apache$spark$utils$KafkaTestUtils$$zkUtils() != null) {
                this.org$apache$spark$utils$KafkaTestUtils$$zkUtils().close();
                this.org$apache$spark$utils$KafkaTestUtils$$zkUtils_$eq(null);
            }
            if (this.org$apache$spark$utils$KafkaTestUtils$$zookeeper() == null) break block3;
            this.org$apache$spark$utils$KafkaTestUtils$$zookeeper().shutdown();
            this.org$apache$spark$utils$KafkaTestUtils$$zookeeper_$eq(null);
        }
    }

    public static /* synthetic */ void createTopic$(KafkaTestUtils $this, String topic, int partitions, Properties config) {
        $this.createTopic(topic, partitions, config);
    }

    default public void createTopic(String topic, int partitions, Properties config) {
        this.org$apache$spark$utils$KafkaTestUtils$$adminClient_$eq(new AdminZkClient(this.org$apache$spark$utils$KafkaTestUtils$$zkUtils()));
        AdminZkClient qual$1 = this.org$apache$spark$utils$KafkaTestUtils$$adminClient();
        String x$1 = topic;
        int x$2 = partitions;
        int x$3 = 1;
        Properties x$4 = config;
        RackAwareMode x$5 = qual$1.createTopic$default$5();
        boolean x$6 = qual$1.createTopic$default$6();
        qual$1.createTopic(x$1, x$2, x$3, x$4, x$5, x$6);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), partitions).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)p -> this.waitUntilMetadataIsPropagated(topic, p));
    }

    public static /* synthetic */ void createTopic$(KafkaTestUtils $this, String topic, int partitions) {
        $this.createTopic(topic, partitions);
    }

    default public void createTopic(String topic, int partitions) {
        this.createTopic(topic, partitions, new Properties());
    }

    public static /* synthetic */ void createTopic$(KafkaTestUtils $this, String topic) {
        $this.createTopic(topic);
    }

    default public void createTopic(String topic) {
        this.createTopic(topic, 1, new Properties());
    }

    public static /* synthetic */ void sendMessages$(KafkaTestUtils $this, String topic, Map messageToFreq) {
        $this.sendMessages(topic, messageToFreq);
    }

    default public void sendMessages(String topic, Map<String, Integer> messageToFreq) {
        this.sendMessages(topic, (scala.collection.immutable.Map<String, Object>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply(((MapLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(messageToFreq).asScala()).mapValues((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToInteger((int)x$1)).toSeq())));
    }

    public static /* synthetic */ void sendMessages$(KafkaTestUtils $this, String topic, scala.collection.immutable.Map messageToFreq) {
        $this.sendMessages(topic, (scala.collection.immutable.Map<String, Object>)messageToFreq);
    }

    default public void sendMessages(String topic, scala.collection.immutable.Map<String, Object> messageToFreq) {
        String[] messages = (String[])((TraversableOnce)messageToFreq.flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String s = (String)tuple2._1();
            int freq = tuple2._2$mcI$sp();
            Seq seq = (Seq)Seq$.MODULE$.fill(freq, (Function0 & Serializable & scala.Serializable)() -> s);
            return seq;
        }, Iterable$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(String.class));
        this.sendMessages(topic, messages);
    }

    public static /* synthetic */ void sendMessages$(KafkaTestUtils $this, String topic, String[] messages) {
        $this.sendMessages(topic, messages);
    }

    default public void sendMessages(String topic, String[] messages) {
        if (this.org$apache$spark$utils$KafkaTestUtils$$producer() == null) {
            this.org$apache$spark$utils$KafkaTestUtils$$producer_$eq((KafkaProducer<String, String>)new KafkaProducer(this.producerConfiguration()));
        }
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])messages)).foreach((Function1 & Serializable & scala.Serializable)message -> this.org$apache$spark$utils$KafkaTestUtils$$producer().send(new ProducerRecord(topic, message)));
    }

    public static /* synthetic */ void flush$(KafkaTestUtils $this) {
        $this.flush();
    }

    default public void flush() {
        this.org$apache$spark$utils$KafkaTestUtils$$producer().close();
        this.org$apache$spark$utils$KafkaTestUtils$$producer_$eq(null);
    }

    public static /* synthetic */ void sendMessages$(KafkaTestUtils $this, String topic, Tuple2[] messages) {
        $this.sendMessages(topic, messages);
    }

    default public void sendMessages(String topic, Tuple2<String, String>[] messages) {
        this.org$apache$spark$utils$KafkaTestUtils$$producer_$eq((KafkaProducer<String, String>)new KafkaProducer(this.producerConfiguration()));
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])messages)).foreach((Function1 & Serializable & scala.Serializable)message -> this.org$apache$spark$utils$KafkaTestUtils$$producer().send(new ProducerRecord(topic, message._1(), message._2())));
        this.org$apache$spark$utils$KafkaTestUtils$$producer().close();
        this.org$apache$spark$utils$KafkaTestUtils$$producer_$eq(null);
    }

    public String brokerLogDir();

    /*
     * WARNING - void declaration
     */
    private Properties brokerConfiguration() {
        void var1_1;
        Properties props = new Properties();
        props.put("broker.id", "0");
        props.put("host.name", "127.0.0.1");
        props.put("advertised.host.name", "127.0.0.1");
        props.put("port", Integer.toString(this.org$apache$spark$utils$KafkaTestUtils$$brokerPort()));
        props.put("log.dir", this.brokerLogDir());
        props.put("zookeeper.connect", this.zkAddress());
        props.put("zookeeper.connection.timeout.ms", "60000");
        props.put("log.flush.interval.messages", "1");
        props.put("replica.socket.timeout.ms", "1500");
        props.put("delete.topic.enable", "true");
        props.put("offsets.topic.num.partitions", "1");
        props.put("offsets.topic.replication.factor", "1");
        props.put("group.initial.rebalance.delay.ms", "10");
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private Properties producerConfiguration() {
        void var1_1;
        Properties props = new Properties();
        props.put("bootstrap.servers", this.brokerAddress());
        props.put("request.required.acks", "1");
        props.put("producer.type", "async");
        props.put("retries", "0");
        props.put("batch.size", "10000");
        props.put("linger.ms", "1");
        props.put("value.serializer", StringSerializer.class.getName());
        props.put("key.serializer", StringSerializer.class.getName());
        props.put("acks", "all");
        return var1_1;
    }

    public static /* synthetic */ Object eventually$(KafkaTestUtils $this, org.apache.spark.streaming.Time timeout, org.apache.spark.streaming.Time interval, Function0 func) {
        return $this.eventually(timeout, interval, func);
    }

    default public <T> T eventually(org.apache.spark.streaming.Time timeout, org.apache.spark.streaming.Time interval, Function0<T> func) {
        long startTime = System.currentTimeMillis();
        return (T)this.tryAgain$1(1, startTime, timeout, interval, func);
    }

    private void waitUntilMetadataIsPropagated(String topic, int partition) {
        this.eventually(new org.apache.spark.streaming.Time(10000L), new org.apache.spark.streaming.Time(100L), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> Predef$.MODULE$.assert(this.isPropagated$1(topic, partition), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(52).append("Partition [").append(topic).append(", ").append(partition).append("] metadata not propagated after timeout").toString()));
    }

    public static /* synthetic */ Tuple2 $anonfun$setupEmbeddedKafkaServer$2(KafkaTestUtils $this, int port) {
        $this.org$apache$spark$utils$KafkaTestUtils$$brokerPort_$eq(port);
        $this.org$apache$spark$utils$KafkaTestUtils$$brokerConf_$eq(new KafkaConfig((Map)$this.brokerConfiguration(), false));
        $this.org$apache$spark$utils$KafkaTestUtils$$server_$eq(new KafkaServer($this.org$apache$spark$utils$KafkaTestUtils$$brokerConf(), KafkaServer$.MODULE$.$lessinit$greater$default$2(), KafkaServer$.MODULE$.$lessinit$greater$default$3(), KafkaServer$.MODULE$.$lessinit$greater$default$4()));
        $this.org$apache$spark$utils$KafkaTestUtils$$server().startup();
        $this.org$apache$spark$utils$KafkaTestUtils$$brokerPort_$eq($this.org$apache$spark$utils$KafkaTestUtils$$server().boundPort(new ListenerName("PLAINTEXT")));
        return new Tuple2((Object)$this.org$apache$spark$utils$KafkaTestUtils$$server(), (Object)BoxesRunTime.boxToInteger((int)$this.org$apache$spark$utils$KafkaTestUtils$$brokerPort()));
    }

    public static /* synthetic */ void $anonfun$teardown$1(KafkaTestUtils $this, String f) {
        try {
            Utils$.MODULE$.deleteRecursively(new File(f));
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable2 instanceof IOException) {
                IOException iOException = (IOException)throwable2;
                if (Utils$.MODULE$.isWindows()) {
                    $this.logWarning((Function0 & Serializable & scala.Serializable)() -> iOException.getMessage());
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                }
            }
            throw throwable;
        }
    }

    private static Either makeAttempt$1(Function0 func$1) {
        Right right;
        try {
            right = package$.MODULE$.Right().apply(func$1.apply());
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (!NonFatal$.MODULE$.apply(throwable2)) {
                throw throwable;
            }
            Left left = package$.MODULE$.Left().apply((Object)throwable2);
            right = left;
        }
        return right;
    }

    private Object tryAgain$1(int attempt, long startTime$1, org.apache.spark.streaming.Time timeout$1, org.apache.spark.streaming.Time interval$1, Function0 func$1) {
        Object result;
        Either either;
        block2: {
            while (true) {
                if ((either = KafkaTestUtils.makeAttempt$1(func$1)) instanceof Right) break block2;
                if (!(either instanceof Left)) break;
                Left left = (Left)either;
                Throwable e = (Throwable)left.value();
                long duration = System.currentTimeMillis() - startTime$1;
                if (duration >= timeout$1.milliseconds()) {
                    throw new TimeoutException(e.getMessage());
                }
                Thread.sleep(interval$1.milliseconds());
                ++attempt;
            }
            throw new MatchError((Object)either);
        }
        Right right = (Right)either;
        Object object = result = right.value();
        return object;
    }

    private boolean isPropagated$1(String topic$4, int partition$1) {
        boolean bl;
        Option option = this.org$apache$spark$utils$KafkaTestUtils$$server().metadataCache().getPartitionInfo(topic$4, partition$1);
        if (option instanceof Some) {
            Some some = (Some)option;
            UpdateMetadataRequestData.UpdateMetadataPartitionState partitionState = (UpdateMetadataRequestData.UpdateMetadataPartitionState)some.value();
            int leader = partitionState.leader();
            List isr = partitionState.isr();
            bl = this.org$apache$spark$utils$KafkaTestUtils$$zkUtils().getLeaderForPartition(new TopicPartition(topic$4, partition$1)).isDefined() && Request$.MODULE$.isValidBrokerId(leader) && !isr.isEmpty();
        } else {
            bl = false;
        }
        return bl;
    }

    public static void $init$(KafkaTestUtils $this) {
        $this.org$apache$spark$utils$KafkaTestUtils$_setter_$org$apache$spark$utils$KafkaTestUtils$$zkHost_$eq("127.0.0.1");
        $this.org$apache$spark$utils$KafkaTestUtils$$zkPort_$eq(0);
        $this.org$apache$spark$utils$KafkaTestUtils$_setter_$org$apache$spark$utils$KafkaTestUtils$$zkConnectionTimeout_$eq(60000);
        $this.org$apache$spark$utils$KafkaTestUtils$_setter_$org$apache$spark$utils$KafkaTestUtils$$zkSessionTimeout_$eq(10000);
        $this.org$apache$spark$utils$KafkaTestUtils$_setter_$org$apache$spark$utils$KafkaTestUtils$$brokerHost_$eq("127.0.0.1");
        $this.org$apache$spark$utils$KafkaTestUtils$$brokerPort_$eq(19092);
        $this.org$apache$spark$utils$KafkaTestUtils$$zkReady_$eq(false);
        $this.org$apache$spark$utils$KafkaTestUtils$$brokerReady_$eq(false);
        $this.org$apache$spark$utils$KafkaTestUtils$$leakDetector_$eq(null);
        $this.org$apache$spark$utils$KafkaTestUtils$_setter_$brokerLogDir_$eq(Utils$.MODULE$.createTempDir(Utils$.MODULE$.createTempDir$default$1(), Utils$.MODULE$.createTempDir$default$2()).getAbsolutePath());
    }

    private class EmbeddedZookeeper {
        private final String zkConnect;
        private final File snapshotDir;
        private final File logDir;
        private final ZooKeeperServer zookeeper;
        private final /* synthetic */ Tuple2 x$2;
        private final String ip;
        private final int port;
        private final NIOServerCnxnFactory factory;
        private final int actualPort;
        public final /* synthetic */ KafkaTestUtils $outer;

        public String zkConnect() {
            return this.zkConnect;
        }

        public File snapshotDir() {
            return this.snapshotDir;
        }

        public File logDir() {
            return this.logDir;
        }

        public ZooKeeperServer zookeeper() {
            return this.zookeeper;
        }

        public String ip() {
            return this.ip;
        }

        public int port() {
            return this.port;
        }

        public NIOServerCnxnFactory factory() {
            return this.factory;
        }

        public int actualPort() {
            return this.actualPort;
        }

        public void shutdown() {
            this.factory().shutdown();
            try {
                Utils$.MODULE$.deleteRecursively(this.snapshotDir());
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                if (throwable2 instanceof IOException) {
                    IOException iOException = (IOException)throwable2;
                    if (Utils$.MODULE$.isWindows()) {
                        this.org$apache$spark$utils$KafkaTestUtils$EmbeddedZookeeper$$$outer().logWarning((Function0 & Serializable & scala.Serializable)() -> iOException.getMessage());
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    }
                }
                throw throwable;
            }
            try {
                Utils$.MODULE$.deleteRecursively(this.logDir());
            }
            catch (Throwable throwable) {
                Throwable throwable3 = throwable;
                if (throwable3 instanceof IOException) {
                    IOException iOException = (IOException)throwable3;
                    if (Utils$.MODULE$.isWindows()) {
                        this.org$apache$spark$utils$KafkaTestUtils$EmbeddedZookeeper$$$outer().logWarning((Function0 & Serializable & scala.Serializable)() -> iOException.getMessage());
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    }
                }
                throw throwable;
            }
        }

        public /* synthetic */ KafkaTestUtils org$apache$spark$utils$KafkaTestUtils$EmbeddedZookeeper$$$outer() {
            return this.$outer;
        }

        public EmbeddedZookeeper(KafkaTestUtils $outer, String zkConnect) {
            this.zkConnect = zkConnect;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            this.snapshotDir = Utils$.MODULE$.createTempDir(Utils$.MODULE$.createTempDir$default$1(), Utils$.MODULE$.createTempDir$default$2());
            this.logDir = Utils$.MODULE$.createTempDir(Utils$.MODULE$.createTempDir$default$1(), Utils$.MODULE$.createTempDir$default$2());
            this.zookeeper = new ZooKeeperServer(this.snapshotDir(), this.logDir(), 500);
            String[] splits = zkConnect.split(":");
            Tuple2 tuple2 = new Tuple2((Object)splits[0], (Object)BoxesRunTime.boxToInteger((int)new StringOps(Predef$.MODULE$.augmentString(splits[1])).toInt()));
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String ip = (String)tuple2._1();
            int port = tuple2._2$mcI$sp();
            Tuple2 tuple22 = new Tuple2((Object)ip, (Object)BoxesRunTime.boxToInteger((int)port));
            this.x$2 = tuple22;
            this.ip = (String)this.x$2._1();
            this.port = this.x$2._2$mcI$sp();
            this.factory = new NIOServerCnxnFactory();
            this.factory().configure(new InetSocketAddress(this.ip(), this.port()), 16);
            this.factory().startup(this.zookeeper());
            this.actualPort = this.factory().getLocalPort();
        }
    }
}

