/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.streaming.util;

import com.google.common.collect.Lists;
import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpHandler;
import com.sun.net.httpserver.HttpServer;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.IOUtils;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.response.RestResponse;
import org.apache.kylin.common.util.JsonUtil;
import org.apache.kylin.common.util.NLocalFileMetadataTestCase;
import org.apache.kylin.streaming.request.StreamingJobUpdateRequest;
import org.apache.kylin.streaming.rest.RestSupport;
import org.apache.kylin.streaming.util.ReflectionUtils;
import org.awaitility.Awaitility;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mockito.Mockito;

public class RestSupportTest
extends NLocalFileMetadataTestCase {
    static boolean assertMeet = false;
    static CountDownLatch latch;
    @Rule
    public ExpectedException thrown = ExpectedException.none();

    @Before
    public void setUp() throws Exception {
        this.createTestMetadata(new String[0]);
    }

    @After
    public void tearDown() {
        this.cleanupTestMetadata();
    }

    @Test
    public void testRestSupport() {
        KylinConfig config = RestSupportTest.getTestConfig();
        RestSupport rest = new RestSupport(config);
        Object baseUrl = ReflectionUtils.getField(rest, "baseUrl");
        Assert.assertEquals((Object)"http://127.0.0.1:7070/kylin/api", (Object)baseUrl);
    }

    @Test
    public void testHttpPost() {
        ArrayList ports = Lists.newArrayList((Object[])new Integer[]{50000, 51000, 52000});
        Awaitility.await().atMost(20L, TimeUnit.SECONDS).until(() -> {
            Iterator iterator = ports.iterator();
            while (iterator.hasNext()) {
                int port = (Integer)iterator.next();
                try {
                    latch = new CountDownLatch(1);
                    HttpServer server = HttpServer.create(new InetSocketAddress("localhost", port), 0);
                    StreamingJobUpdateRequest request = new StreamingJobUpdateRequest();
                    server.createContext("/test", new NormalModeHandler(request));
                    server.start();
                    RestSupport rest = new RestSupport("http://localhost:" + port + "/test/");
                    RestResponse restResp = rest.execute((HttpRequestBase)rest.createHttpPost("status"), (Object)new StreamingJobUpdateRequest());
                    Assert.assertNotNull((Object)restResp);
                    Assert.assertEquals((Object)"0", (Object)restResp.getCode());
                    Assert.assertEquals((Object)"false", (Object)restResp.getData());
                    Assert.assertEquals((Object)"", (Object)restResp.getMsg());
                    Boolean maintenanceMode = rest.isMaintenanceMode();
                    Assert.assertFalse((boolean)maintenanceMode);
                    Boolean checkMaintenanceMode = rest.checkMaintenceMode();
                    Assert.assertFalse((boolean)checkMaintenanceMode);
                    rest.close();
                    latch.await(10L, TimeUnit.SECONDS);
                    server.stop(0);
                    break;
                }
                catch (InterruptedException e) {
                    Assert.fail();
                }
                catch (IOException e) {
                }
            }
            assertMeet = true;
            return true;
        });
        if (!assertMeet) {
            Assert.fail();
        }
    }

    @Test
    public void testHttpPut() {
        ArrayList ports = Lists.newArrayList((Object[])new Integer[]{50000, 51000, 52000});
        Awaitility.await().atMost(20L, TimeUnit.SECONDS).until(() -> {
            Iterator iterator = ports.iterator();
            while (iterator.hasNext()) {
                int port = (Integer)iterator.next();
                try {
                    latch = new CountDownLatch(1);
                    HttpServer server = HttpServer.create(new InetSocketAddress("localhost", port), 0);
                    StreamingJobUpdateRequest request = new StreamingJobUpdateRequest();
                    server.createContext("/test", new NormalModeHandler(request));
                    server.start();
                    RestSupport rest = new RestSupport("http://localhost:" + port + "/test/");
                    RestResponse restResp = rest.execute((HttpRequestBase)rest.createHttpPut("status"), (Object)new StreamingJobUpdateRequest());
                    Assert.assertNotNull((Object)restResp);
                    Assert.assertEquals((Object)"0", (Object)restResp.getCode());
                    Assert.assertEquals((Object)"false", (Object)restResp.getData());
                    Assert.assertEquals((Object)"", (Object)restResp.getMsg());
                    Boolean maintenanceMode = rest.isMaintenanceMode();
                    Assert.assertFalse((boolean)maintenanceMode);
                    Boolean checkMaintenanceMode = rest.checkMaintenceMode();
                    Assert.assertFalse((boolean)checkMaintenanceMode);
                    rest.close();
                    latch.await(10L, TimeUnit.SECONDS);
                    server.stop(0);
                    break;
                }
                catch (InterruptedException e) {
                    Assert.fail();
                }
                catch (IOException e) {
                }
            }
            assertMeet = true;
            return true;
        });
        if (!assertMeet) {
            Assert.fail();
        }
    }

    @Test
    public void testHttpGet() {
        ArrayList ports = Lists.newArrayList((Object[])new Integer[]{50000, 51000, 52000});
        Awaitility.await().atMost(20L, TimeUnit.SECONDS).until(() -> {
            Iterator iterator = ports.iterator();
            while (iterator.hasNext()) {
                int port = (Integer)iterator.next();
                try {
                    latch = new CountDownLatch(1);
                    HttpServer server = HttpServer.create(new InetSocketAddress("localhost", port), 0);
                    StreamingJobUpdateRequest request = new StreamingJobUpdateRequest();
                    server.createContext("/test", new NormalModeHandler(request));
                    server.start();
                    RestSupport rest = new RestSupport("http://localhost:" + port + "/test/");
                    RestResponse restResp = rest.execute((HttpRequestBase)rest.createHttpGet("status"), null);
                    Assert.assertNotNull((Object)restResp);
                    Assert.assertEquals((Object)"0", (Object)restResp.getCode());
                    Assert.assertEquals((Object)"false", (Object)restResp.getData());
                    Assert.assertEquals((Object)"", (Object)restResp.getMsg());
                    Boolean maintenanceMode = rest.isMaintenanceMode();
                    Assert.assertFalse((boolean)maintenanceMode);
                    Boolean checkMaintenanceMode = rest.checkMaintenceMode();
                    Assert.assertFalse((boolean)checkMaintenanceMode);
                    rest.close();
                    latch.await(10L, TimeUnit.SECONDS);
                    server.stop(0);
                    break;
                }
                catch (InterruptedException e) {
                    Assert.fail();
                }
                catch (IOException e) {
                }
            }
            assertMeet = true;
            return true;
        });
        if (!assertMeet) {
            Assert.fail();
        }
    }

    @Test
    public void testMaintenanceMode() {
        ArrayList ports = Lists.newArrayList((Object[])new Integer[]{50000, 51000, 52000});
        Awaitility.await().atMost(20L, TimeUnit.SECONDS).until(() -> {
            Iterator iterator = ports.iterator();
            while (iterator.hasNext()) {
                int port = (Integer)iterator.next();
                try {
                    latch = new CountDownLatch(1);
                    HttpServer server = HttpServer.create(new InetSocketAddress("localhost", port), 0);
                    StreamingJobUpdateRequest request = new StreamingJobUpdateRequest();
                    server.createContext("/test", new MaintenanceModeHandler(request, 10));
                    server.start();
                    RestSupport rest = new RestSupport("http://localhost:" + port + "/test/");
                    RestResponse restResp = rest.execute((HttpRequestBase)rest.createHttpPost("status"), (Object)new StreamingJobUpdateRequest());
                    Assert.assertNotNull((Object)restResp);
                    Assert.assertEquals((Object)"0", (Object)restResp.getCode());
                    Assert.assertEquals((Object)"true", (Object)restResp.getData());
                    Assert.assertEquals((Object)"maintenance", (Object)restResp.getMsg());
                    Boolean maintenanceMode = rest.isMaintenanceMode();
                    Assert.assertTrue((boolean)maintenanceMode);
                    rest.close();
                    latch.await(10L, TimeUnit.SECONDS);
                    server.stop(0);
                    break;
                }
                catch (InterruptedException e) {
                    Assert.fail();
                }
                catch (IOException e) {
                }
            }
            assertMeet = true;
            return true;
        });
        if (!assertMeet) {
            Assert.fail();
        }
    }

    @Test
    public void testCheckMaintenanceMode() {
        RestSupport rest = (RestSupport)Mockito.mock(RestSupport.class);
        Mockito.when((Object)rest.isMaintenanceMode()).thenReturn((Object)false);
        Assert.assertFalse((boolean)rest.checkMaintenceMode());
    }

    @Test
    public void testIsMaintenanceMode() {
        RestSupport rest = (RestSupport)Mockito.mock(RestSupport.class);
        Mockito.when((Object)rest.isMaintenanceMode()).thenReturn((Object)false);
        Assert.assertFalse((boolean)rest.isMaintenanceMode());
    }

    static class MaintenanceModeHandler
    implements HttpHandler {
        Object req;
        int mtmCnt;

        public MaintenanceModeHandler(Object req, int mtmCnt) {
            this.req = req;
            this.mtmCnt = mtmCnt;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void handle(HttpExchange httpExchange) throws IOException {
            try {
                InputStream in = httpExchange.getRequestBody();
                String s = IOUtils.toString((InputStream)in);
                if (s.equals(JsonUtil.writeValueAsString((Object)this.req))) {
                    assertMeet = true;
                }
            }
            finally {
                httpExchange.sendResponseHeaders(200, 0L);
                if (this.mtmCnt > 0) {
                    httpExchange.getResponseBody().write(JsonUtil.writeValueAsString((Object)new RestResponse("0", (Object)"true", "maintenance")).getBytes());
                    --this.mtmCnt;
                } else {
                    httpExchange.getResponseBody().write(JsonUtil.writeValueAsString((Object)new RestResponse("0", (Object)"false", "maintenance")).getBytes());
                }
                httpExchange.close();
                latch.countDown();
            }
        }
    }

    static class NormalModeHandler
    implements HttpHandler {
        Object req;

        public NormalModeHandler(Object req) {
            this.req = req;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void handle(HttpExchange httpExchange) throws IOException {
            try {
                InputStream in = httpExchange.getRequestBody();
                String s = IOUtils.toString((InputStream)in);
                if (s.equals(JsonUtil.writeValueAsString((Object)this.req))) {
                    assertMeet = true;
                }
            }
            finally {
                httpExchange.sendResponseHeaders(200, 0L);
                httpExchange.getResponseBody().write(JsonUtil.writeValueAsString((Object)new RestResponse("0", (Object)"false", "")).getBytes());
                httpExchange.close();
                latch.countDown();
            }
        }
    }
}

