/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.streaming.util;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Locale;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class ReflectionUtils {
    private static final Log logger = LogFactory.getLog(ReflectionUtils.class);

    public static void setField(Object targetObject, String name, Object value) {
        ReflectionUtils.setField(targetObject, name, value, (Class)null);
    }

    public static void setField(Object targetObject, String name, Object value, Class<?> type) {
        ReflectionUtils.setField(targetObject, null, name, value, type);
    }

    public static void setField(Class<?> targetClass, String name, Object value) {
        ReflectionUtils.setField(null, targetClass, name, value, null);
    }

    public static void setField(Class<?> targetClass, String name, Object value, Class<?> type) {
        ReflectionUtils.setField(null, targetClass, name, value, type);
    }

    public static void setField(Object targetObject, Class<?> targetClass, String name, Object value, Class<?> type) {
        Field field;
        Assert.isTrue((targetObject != null || targetClass != null ? 1 : 0) != 0, (String)"Either targetObject or targetClass for the field must be specified");
        if (targetClass == null) {
            targetClass = targetObject.getClass();
        }
        if ((field = org.springframework.util.ReflectionUtils.findField(targetClass, (String)name, type)) == null) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "Could not find field '%s' of type [%s] on %s or target class [%s]", name, type, ReflectionUtils.safeToString(targetObject), targetClass));
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)String.format(Locale.ROOT, "Setting field '%s' of type [%s] on %s or target class [%s] to value [%s]", name, type, ReflectionUtils.safeToString(targetObject), targetClass, value));
        }
        org.springframework.util.ReflectionUtils.makeAccessible((Field)field);
        org.springframework.util.ReflectionUtils.setField((Field)field, (Object)targetObject, (Object)value);
    }

    public static Object getField(Object targetObject, String name) {
        return ReflectionUtils.getField(targetObject, null, name);
    }

    public static Object getField(Class<?> targetClass, String name) {
        return ReflectionUtils.getField(null, targetClass, name);
    }

    public static Object getField(Object targetObject, Class<?> targetClass, String name) {
        Field field;
        Assert.isTrue((targetObject != null || targetClass != null ? 1 : 0) != 0, (String)"Either targetObject or targetClass for the field must be specified");
        if (targetClass == null) {
            targetClass = targetObject.getClass();
        }
        if ((field = org.springframework.util.ReflectionUtils.findField(targetClass, (String)name)) == null) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "Could not find field '%s' on %s or target class [%s]", name, ReflectionUtils.safeToString(targetObject), targetClass));
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)String.format(Locale.ROOT, "Getting field '%s' from %s or target class [%s]", name, ReflectionUtils.safeToString(targetObject), targetClass));
        }
        org.springframework.util.ReflectionUtils.makeAccessible((Field)field);
        return org.springframework.util.ReflectionUtils.getField((Field)field, (Object)targetObject);
    }

    public static void invokeSetterMethod(Object target, String name, Object value) {
        ReflectionUtils.invokeSetterMethod(target, name, value, null);
    }

    public static void invokeSetterMethod(Object target, String name, Object value, Class<?> type) {
        Method method;
        Class[] classArray;
        Assert.notNull((Object)target, (String)"Target object must not be null");
        Assert.hasText((String)name, (String)"Method name must not be empty");
        if (type != null) {
            Class[] classArray2 = new Class[1];
            classArray = classArray2;
            classArray2[0] = type;
        } else {
            classArray = null;
        }
        Class[] paramTypes = classArray;
        String setterMethodName = name;
        if (!name.startsWith("set")) {
            setterMethodName = "set" + StringUtils.capitalize((String)name);
        }
        if ((method = org.springframework.util.ReflectionUtils.findMethod(target.getClass(), (String)setterMethodName, (Class[])paramTypes)) == null && !setterMethodName.equals(name)) {
            setterMethodName = name;
            method = org.springframework.util.ReflectionUtils.findMethod(target.getClass(), (String)name, (Class[])paramTypes);
        }
        if (method == null) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "Could not find setter method '%s' on %s with parameter type [%s]", setterMethodName, ReflectionUtils.safeToString(target), type));
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)String.format(Locale.ROOT, "Invoking setter method '%s' on %s with value [%s]", setterMethodName, ReflectionUtils.safeToString(target), value));
        }
        org.springframework.util.ReflectionUtils.makeAccessible((Method)method);
        org.springframework.util.ReflectionUtils.invokeMethod((Method)method, (Object)target, (Object[])new Object[]{value});
    }

    public static Object invokeGetterMethod(Object target, String name) {
        Method method;
        Assert.notNull((Object)target, (String)"Target object must not be null");
        Assert.hasText((String)name, (String)"Method name must not be empty");
        String getterMethodName = name;
        if (!name.startsWith("get")) {
            getterMethodName = "get" + StringUtils.capitalize((String)name);
        }
        if ((method = org.springframework.util.ReflectionUtils.findMethod(target.getClass(), (String)getterMethodName)) == null && !getterMethodName.equals(name)) {
            getterMethodName = name;
            method = org.springframework.util.ReflectionUtils.findMethod(target.getClass(), (String)name);
        }
        if (method == null) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "Could not find getter method '%s' on %s", getterMethodName, ReflectionUtils.safeToString(target)));
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)String.format(Locale.ROOT, "Invoking getter method '%s' on %s", getterMethodName, ReflectionUtils.safeToString(target)));
        }
        org.springframework.util.ReflectionUtils.makeAccessible((Method)method);
        return org.springframework.util.ReflectionUtils.invokeMethod((Method)method, (Object)target);
    }

    private static String safeToString(Object target) {
        try {
            return String.format(Locale.ROOT, "target object [%s]", target);
        }
        catch (Exception var2) {
            return String.format(Locale.ROOT, "target of type [%s] whose toString() method threw [%s]", target != null ? target.getClass().getName() : "unknown", var2);
        }
    }
}

