/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.streaming.util;

import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.util.NLocalFileMetadataTestCase;
import org.apache.kylin.job.constant.JobStatusEnum;
import org.apache.kylin.job.execution.JobTypeEnum;
import org.apache.kylin.metadata.cube.model.NDataLayout;
import org.apache.kylin.metadata.cube.model.NDataSegment;
import org.apache.kylin.metadata.cube.model.NDataflow;
import org.apache.kylin.metadata.cube.model.NDataflowManager;
import org.apache.kylin.metadata.cube.utils.StreamingUtils;
import org.apache.kylin.streaming.manager.StreamingJobManager;
import org.apache.kylin.streaming.metadata.StreamingJobMeta;
import org.apache.kylin.streaming.util.MetaInfoUpdater;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class MetaInfoUpdaterTest
extends NLocalFileMetadataTestCase {
    private static String PROJECT = "streaming_test";
    @Rule
    public ExpectedException thrown = ExpectedException.none();

    @Before
    public void setUp() throws Exception {
        this.createTestMetadata(new String[0]);
    }

    @After
    public void tearDown() {
        this.cleanupTestMetadata();
    }

    @Test
    public void testUpdate() {
        String segId = "c380dd2a-43b8-4268-b73d-2a5f76236633";
        String dataflowId = "e78a89dd-847f-4574-8afa-8768b4228b72";
        KylinConfig testConfig = MetaInfoUpdaterTest.getTestConfig();
        NDataflowManager mgr = NDataflowManager.getInstance((KylinConfig)testConfig, (String)PROJECT);
        NDataflow df = mgr.getDataflow("e78a89dd-847f-4574-8afa-8768b4228b72");
        NDataSegment seg = df.getSegment("c380dd2a-43b8-4268-b73d-2a5f76236633");
        Assert.assertEquals((long)17L, (long)seg.getLayoutSize());
        NDataLayout layout = NDataLayout.newDataLayout((NDataflow)df, (String)seg.getId(), (long)10002L);
        MetaInfoUpdater.update((String)PROJECT, (NDataSegment)seg, (NDataLayout)layout);
        NDataflowManager mgr1 = NDataflowManager.getInstance((KylinConfig)testConfig, (String)PROJECT);
        NDataflow df1 = mgr1.getDataflow("e78a89dd-847f-4574-8afa-8768b4228b72");
        NDataSegment seg1 = df1.getSegment("c380dd2a-43b8-4268-b73d-2a5f76236633");
        Assert.assertEquals((long)17L, (long)seg1.getLayoutSize());
    }

    @Test
    public void testUpdateJobState() {
        String modelId = "e78a89dd-847f-4574-8afa-8768b4228b72";
        String jobId = StreamingUtils.getJobId((String)"e78a89dd-847f-4574-8afa-8768b4228b72", (String)JobTypeEnum.STREAMING_BUILD.toString());
        KylinConfig testConfig = MetaInfoUpdaterTest.getTestConfig();
        StreamingJobManager mgr = StreamingJobManager.getInstance((KylinConfig)testConfig, (String)PROJECT);
        StreamingJobMeta jobMeta = mgr.getStreamingJobByUuid(jobId);
        Assert.assertEquals((Object)JobStatusEnum.STOPPED, (Object)jobMeta.getCurrentStatus());
        Assert.assertNotNull((Object)jobMeta.getLastUpdateTime());
        Assert.assertNull((Object)jobMeta.getLastEndTime());
        Assert.assertNull((Object)jobMeta.getLastStartTime());
        MetaInfoUpdater.updateJobState((String)PROJECT, (String)jobId, (JobStatusEnum)JobStatusEnum.ERROR);
        mgr = StreamingJobManager.getInstance((KylinConfig)testConfig, (String)PROJECT);
        jobMeta = mgr.getStreamingJobByUuid(jobId);
        Assert.assertEquals((Object)JobStatusEnum.ERROR, (Object)jobMeta.getCurrentStatus());
        Assert.assertNotNull((Object)jobMeta.getLastEndTime());
        MetaInfoUpdater.updateJobState((String)PROJECT, (String)jobId, (JobStatusEnum)JobStatusEnum.RUNNING);
        mgr = StreamingJobManager.getInstance((KylinConfig)testConfig, (String)PROJECT);
        jobMeta = mgr.getStreamingJobByUuid(jobId);
        Assert.assertEquals((Object)JobStatusEnum.RUNNING, (Object)jobMeta.getCurrentStatus());
        Assert.assertNotNull((Object)jobMeta.getLastStartTime());
        MetaInfoUpdater.updateJobState((String)PROJECT, (String)jobId, (JobStatusEnum)JobStatusEnum.STOPPED);
        mgr = StreamingJobManager.getInstance((KylinConfig)testConfig, (String)PROJECT);
        jobMeta = mgr.getStreamingJobByUuid(jobId);
        Assert.assertEquals((Object)JobStatusEnum.STOPPED, (Object)jobMeta.getCurrentStatus());
        Assert.assertNotNull((Object)jobMeta.getLastEndTime());
        Assert.assertNotNull((Object)jobMeta.getLastUpdateTime());
        mgr.updateStreamingJob(jobId, copyForWrite -> {
            copyForWrite.setYarnAppId("application_1626786933603_1752");
            copyForWrite.setYarnAppUrl("http://sandbox.hortonworks.com:8088/cluster/app/application_1626786933603_1752");
        });
        MetaInfoUpdater.updateJobState((String)PROJECT, (String)jobId, (JobStatusEnum)JobStatusEnum.STARTING);
        jobMeta = mgr.getStreamingJobByUuid(jobId);
        Assert.assertEquals((Object)"", (Object)jobMeta.getYarnAppId());
        Assert.assertEquals((Object)"", (Object)jobMeta.getYarnAppUrl());
    }

    @Test
    public void testMarkGracefulShutdown() {
        String modelId = "e78a89dd-847f-4574-8afa-8768b4228b72";
        String jobId = StreamingUtils.getJobId((String)"e78a89dd-847f-4574-8afa-8768b4228b72", (String)JobTypeEnum.STREAMING_BUILD.toString());
        KylinConfig testConfig = MetaInfoUpdaterTest.getTestConfig();
        MetaInfoUpdater.markGracefulShutdown((String)PROJECT, (String)jobId);
        StreamingJobManager mgr = StreamingJobManager.getInstance((KylinConfig)testConfig, (String)PROJECT);
        StreamingJobMeta jobMeta = mgr.getStreamingJobByUuid(jobId);
        Assert.assertEquals((Object)"GRACEFUL_SHUTDOWN", (Object)jobMeta.getAction());
    }
}

