/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.streaming.util;

import io.kyligence.kap.guava20.shaded.common.util.concurrent.UncheckedTimeoutException;
import java.util.ArrayList;
import java.util.List;
import org.apache.kylin.cluster.IClusterManager;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.util.AddressUtil;
import org.apache.kylin.common.util.CliCommandExecutor;
import org.apache.kylin.common.util.Logger;
import org.apache.kylin.common.util.ShellException;
import org.apache.kylin.streaming.manager.StreamingJobManager;
import org.apache.kylin.streaming.metadata.StreamingJobMeta;
import org.apache.kylin.streaming.util.JobKiller;
import org.apache.kylin.streaming.util.MockClusterManager;
import org.apache.kylin.streaming.util.ReflectionUtils;
import org.apache.kylin.streaming.util.StreamingTestCase;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class JobKillerTest
extends StreamingTestCase {
    private static String PROJECT = "streaming_test";

    @Before
    public void setUp() throws Exception {
        this.createTestMetadata(new String[0]);
    }

    @After
    public void tearDown() {
        this.cleanupTestMetadata();
    }

    @Test
    public void testKillApplication() {
        String id = "e78a89dd-847f-4574-8afa-8768b4228b72_build";
        JobKiller.killApplication((String)"e78a89dd-847f-4574-8afa-8768b4228b72_build");
    }

    @Test
    public void testMockCreateClusterManager() {
        ReflectionUtils.setField(JobKiller.class, "mock", (Object)new MockClusterManager(){

            @Override
            public boolean applicationExisted(String jobId) {
                return true;
            }
        });
        IClusterManager clusterManager = JobKiller.createClusterManager();
        Assert.assertTrue((clusterManager != null ? 1 : 0) != 0);
        Object mock = ReflectionUtils.getField(JobKiller.class, "mock");
        Assert.assertTrue((mock != null ? 1 : 0) != 0);
        Boolean isYarnEnv = (Boolean)ReflectionUtils.getField(JobKiller.class, "isYarnEnv");
        Assert.assertFalse((boolean)isYarnEnv);
        ReflectionUtils.setField(JobKiller.class, "mock", null);
    }

    @Test
    public void testCreateClusterManager() {
        IClusterManager clusterManager = JobKiller.createClusterManager();
        Assert.assertTrue((!(clusterManager instanceof MockClusterManager) ? 1 : 0) != 0);
    }

    @Test
    public void testYarnApplicationExisted() {
        ReflectionUtils.setField(JobKiller.class, "isYarnEnv", (Object)true);
        String id = "e78a89dd-847f-4574-8afa-8768b4228b72_build";
        ReflectionUtils.setField(JobKiller.class, "mock", (Object)new MockClusterManager(){

            @Override
            public boolean applicationExisted(String jobId) {
                return true;
            }
        });
        Assert.assertTrue((boolean)JobKiller.applicationExisted((String)"e78a89dd-847f-4574-8afa-8768b4228b72_build"));
        ReflectionUtils.setField(JobKiller.class, "mock", null);
        ReflectionUtils.setField(JobKiller.class, "isYarnEnv", (Object)false);
    }

    @Test
    public void testYarnApplicationExistedException() {
        ReflectionUtils.setField(JobKiller.class, "isYarnEnv", (Object)true);
        String id = "e78a89dd-847f-4574-8afa-8768b4228b72_build";
        ReflectionUtils.setField(JobKiller.class, "mock", (Object)new MockClusterManager(){

            @Override
            public boolean applicationExisted(String jobId) {
                throw new UncheckedTimeoutException("mock timeout");
            }
        });
        Assert.assertFalse((boolean)JobKiller.applicationExisted((String)"e78a89dd-847f-4574-8afa-8768b4228b72_build"));
        ReflectionUtils.setField(JobKiller.class, "mock", null);
        ReflectionUtils.setField(JobKiller.class, "isYarnEnv", (Object)false);
    }

    @Test
    public void testKillYarnApplication() {
        ReflectionUtils.setField(JobKiller.class, "isYarnEnv", (Object)true);
        String id = "e78a89dd-847f-4574-8afa-8768b4228b72_build";
        ReflectionUtils.setField(JobKiller.class, "mock", (Object)new MockClusterManager(){

            @Override
            public boolean applicationExisted(String jobId) {
                return true;
            }
        });
        JobKiller.killApplication((String)"e78a89dd-847f-4574-8afa-8768b4228b72_build");
        ReflectionUtils.setField(JobKiller.class, "mock", null);
        ReflectionUtils.setField(JobKiller.class, "isYarnEnv", (Object)false);
    }

    @Test
    public void testKillYarnApplicationException() {
        ReflectionUtils.setField(JobKiller.class, "isYarnEnv", (Object)true);
        String id = "e78a89dd-847f-4574-8afa-8768b4228b72_build";
        ReflectionUtils.setField(JobKiller.class, "mock", (Object)new MockClusterManager(){

            @Override
            public boolean applicationExisted(String jobId) {
                throw new UncheckedTimeoutException("mock timeout");
            }
        });
        JobKiller.killApplication((String)"e78a89dd-847f-4574-8afa-8768b4228b72_build");
        ReflectionUtils.setField(JobKiller.class, "isYarnEnv", (Object)false);
    }

    @Test
    public void testKillBuildProcess() {
        String id = "e78a89dd-847f-4574-8afa-8768b4228b72_build";
        StreamingJobManager mgr = StreamingJobManager.getInstance((KylinConfig)JobKillerTest.getTestConfig(), (String)PROJECT);
        StreamingJobMeta streamingJobMeta = mgr.getStreamingJobByUuid("e78a89dd-847f-4574-8afa-8768b4228b72_build");
        Assert.assertEquals((long)1L, (long)JobKiller.killProcess((StreamingJobMeta)streamingJobMeta));
    }

    @Test
    public void testKillMergeProcess() {
        String id = "e78a89dd-847f-4574-8afa-8768b4228b72_merge";
        StreamingJobManager mgr = StreamingJobManager.getInstance((KylinConfig)JobKillerTest.getTestConfig(), (String)PROJECT);
        StreamingJobMeta streamingJobMeta = mgr.getStreamingJobByUuid("e78a89dd-847f-4574-8afa-8768b4228b72_merge");
        Assert.assertEquals((long)1L, (long)JobKiller.killProcess((StreamingJobMeta)streamingJobMeta));
    }

    @Test
    public void testKillYarnProcess() {
        ReflectionUtils.setField(JobKiller.class, "isYarnEnv", (Object)true);
        String id = "e78a89dd-847f-4574-8afa-8768b4228b72_merge";
        StreamingJobManager mgr = StreamingJobManager.getInstance((KylinConfig)JobKillerTest.getTestConfig(), (String)PROJECT);
        StreamingJobMeta streamingJobMeta = mgr.getStreamingJobByUuid("e78a89dd-847f-4574-8afa-8768b4228b72_merge");
        JobKiller.killProcess((StreamingJobMeta)streamingJobMeta);
        ReflectionUtils.setField(JobKiller.class, "isYarnEnv", (Object)false);
    }

    @Test
    public void testKillYarnProcess1() {
        ReflectionUtils.setField(JobKiller.class, "isYarnEnv", (Object)true);
        String id = "e78a89dd-847f-4574-8afa-8768b4228b72_merge";
        StreamingJobManager mgr = StreamingJobManager.getInstance((KylinConfig)JobKillerTest.getTestConfig(), (String)PROJECT);
        StreamingJobMeta streamingJobMeta = mgr.getStreamingJobByUuid("e78a89dd-847f-4574-8afa-8768b4228b72_merge");
        streamingJobMeta.setNodeInfo("127.0.0.1:7070");
        JobKiller.killProcess((StreamingJobMeta)streamingJobMeta);
        ReflectionUtils.setField(JobKiller.class, "isYarnEnv", (Object)false);
    }

    @Test
    public void testKillYarnProcess2() {
        ReflectionUtils.setField(JobKiller.class, "isYarnEnv", (Object)true);
        String id = "e78a89dd-847f-4574-8afa-8768b4228b72_merge";
        StreamingJobManager mgr = StreamingJobManager.getInstance((KylinConfig)JobKillerTest.getTestConfig(), (String)PROJECT);
        StreamingJobMeta streamingJobMeta = mgr.getStreamingJobByUuid("e78a89dd-847f-4574-8afa-8768b4228b72_merge");
        streamingJobMeta.setNodeInfo(AddressUtil.getLocalInstance());
        JobKiller.killProcess((StreamingJobMeta)streamingJobMeta);
        ReflectionUtils.setField(JobKiller.class, "isYarnEnv", (Object)false);
    }

    @Test
    public void testKillYarnEnvProcess() {
        String id = "e78a89dd-847f-4574-8afa-8768b4228b72_merge";
        StreamingJobManager mgr = StreamingJobManager.getInstance((KylinConfig)JobKillerTest.getTestConfig(), (String)PROJECT);
        StreamingJobMeta streamingJobMeta = mgr.getStreamingJobByUuid("e78a89dd-847f-4574-8afa-8768b4228b72_merge");
        CliCommandExecutor exec = new CliCommandExecutor();
        JobKiller.StringLogger strLogger = new JobKiller.StringLogger(){

            public List<String> getContents() {
                ArrayList<String> mockList = new ArrayList<String>();
                mockList.add("1");
                return mockList;
            }
        };
        JobKiller.killYarnEnvProcess((CliCommandExecutor)exec, (StreamingJobMeta)streamingJobMeta, (JobKiller.StringLogger)strLogger);
    }

    @Test
    public void testKillYarnEnvProcessException() {
        String id = "e78a89dd-847f-4574-8afa-8768b4228b72_merge";
        StreamingJobManager mgr = StreamingJobManager.getInstance((KylinConfig)JobKillerTest.getTestConfig(), (String)PROJECT);
        StreamingJobMeta streamingJobMeta = mgr.getStreamingJobByUuid("e78a89dd-847f-4574-8afa-8768b4228b72_merge");
        CliCommandExecutor exec = new CliCommandExecutor(){

            public CliCommandExecutor.CliCmdExecResult execute(String command, Logger logAppender) throws ShellException {
                throw new ShellException("test");
            }
        };
        JobKiller.killYarnEnvProcess((CliCommandExecutor)exec, (StreamingJobMeta)streamingJobMeta, null);
    }

    @Test
    public void testGrepProcess() {
        KylinConfig config = JobKillerTest.getTestConfig();
        CliCommandExecutor exec = config.getCliCommandExecutor();
        JobKiller.StringLogger strLogger = new JobKiller.StringLogger();
        String jobId = "e78a89dd-847f-4574-8afa-8768b4228b73_simple_test";
        try {
            int resultCode = JobKiller.grepProcess((CliCommandExecutor)exec, (JobKiller.StringLogger)strLogger, (String)"e78a89dd-847f-4574-8afa-8768b4228b73_simple_test");
            Assert.assertEquals((long)0L, (long)resultCode);
            Assert.assertTrue((boolean)strLogger.getContents().isEmpty());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void testDoKillProcess() {
        int resultCode2;
        KylinConfig config = JobKillerTest.getTestConfig();
        CliCommandExecutor exec = config.getCliCommandExecutor();
        String jobId = "e78a89dd-847f-4574-8afa-8768b4228b73_simple_test";
        try {
            resultCode2 = JobKiller.doKillProcess((CliCommandExecutor)exec, (String)"e78a89dd-847f-4574-8afa-8768b4228b73_simple_test", (boolean)false);
            Assert.assertEquals((long)0L, (long)resultCode2);
        }
        catch (Exception resultCode2) {
            // empty catch block
        }
        try {
            resultCode2 = JobKiller.doKillProcess((CliCommandExecutor)exec, (String)"e78a89dd-847f-4574-8afa-8768b4228b73_simple_test", (boolean)true);
            Assert.assertEquals((long)0L, (long)resultCode2);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void testStringLog() {
        JobKiller.StringLogger log = new JobKiller.StringLogger();
        Assert.assertTrue((boolean)log.getContents().isEmpty());
        log.log("test");
        Assert.assertTrue((!log.getContents().isEmpty() ? 1 : 0) != 0);
    }
}

