/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.streaming.metadata;

import java.util.Map;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.util.NLocalFileMetadataTestCase;
import org.apache.kylin.job.constant.JobStatusEnum;
import org.apache.kylin.job.execution.JobTypeEnum;
import org.apache.kylin.metadata.cube.utils.StreamingUtils;
import org.apache.kylin.metadata.model.NDataModel;
import org.apache.kylin.metadata.model.NDataModelManager;
import org.apache.kylin.streaming.constants.StreamingConstants;
import org.apache.kylin.streaming.metadata.StreamingJobMeta;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class StreamingJobMetaTest
extends NLocalFileMetadataTestCase {
    private static String PROJECT = "streaming_test";
    private static String MODEL_ID = "e78a89dd-847f-4574-8afa-8768b4228b73";
    @Rule
    public ExpectedException thrown = ExpectedException.none();

    @Before
    public void setUp() throws Exception {
        this.createTestMetadata(new String[0]);
    }

    @After
    public void tearDown() {
        this.cleanupTestMetadata();
    }

    @Test
    public void testCreateBuildJob() {
        KylinConfig config = KylinConfig.getInstanceFromEnv();
        NDataModelManager dataModelManager = NDataModelManager.getInstance((KylinConfig)config, (String)PROJECT);
        NDataModel model = dataModelManager.getDataModelDesc(MODEL_ID);
        JobStatusEnum jobStatus = JobStatusEnum.NEW;
        JobTypeEnum jobType = JobTypeEnum.STREAMING_BUILD;
        StreamingJobMeta jobMeta = StreamingJobMeta.create((NDataModel)model, (JobStatusEnum)jobStatus, (JobTypeEnum)JobTypeEnum.STREAMING_BUILD);
        Assert.assertNotNull((Object)jobMeta);
        Map params = jobMeta.getParams();
        this.assertJobMeta(model, jobMeta, jobStatus, jobType);
        this.assertCommonParams(params);
        Assert.assertEquals((Object)"30", params.get("kylin.streaming.duration"));
        Assert.assertEquals((Object)StreamingConstants.STREAMING_MAX_OFFSETS_PER_TRIGGER_DEFAULT, params.get("kylin.streaming.kafka-conf.maxOffsetsPerTrigger"));
    }

    @Test
    public void testCreateMergeJob() {
        KylinConfig config = KylinConfig.getInstanceFromEnv();
        NDataModelManager dataModelManager = NDataModelManager.getInstance((KylinConfig)config, (String)PROJECT);
        NDataModel model = dataModelManager.getDataModelDesc(MODEL_ID);
        JobStatusEnum jobStatus = JobStatusEnum.NEW;
        JobTypeEnum jobType = JobTypeEnum.STREAMING_MERGE;
        StreamingJobMeta jobMeta = StreamingJobMeta.create((NDataModel)model, (JobStatusEnum)jobStatus, (JobTypeEnum)jobType);
        Assert.assertNotNull((Object)jobMeta);
        Map params = jobMeta.getParams();
        this.assertJobMeta(model, jobMeta, jobStatus, jobType);
        this.assertCommonParams(params);
        Assert.assertEquals((Object)"32m", params.get("kylin.streaming.segment-max-size"));
        Assert.assertEquals((Object)"3", params.get("kylin.streaming.segment-merge-threshold"));
    }

    private void assertJobMeta(NDataModel dataModel, StreamingJobMeta jobMeta, JobStatusEnum status, JobTypeEnum jobType) {
        Assert.assertNotNull((Object)jobMeta.getCreateTime());
        Assert.assertNotNull((Object)jobMeta.getLastUpdateTime());
        Assert.assertEquals((Object)status, (Object)jobMeta.getCurrentStatus());
        Assert.assertEquals((Object)dataModel.getUuid(), (Object)jobMeta.getModelId());
        Assert.assertEquals((Object)dataModel.getAlias(), (Object)jobMeta.getModelName());
        Assert.assertEquals((Object)dataModel.getRootFactTableName(), (Object)jobMeta.getFactTableName());
        Assert.assertEquals((Object)dataModel.getRootFactTable().getTableDesc().getKafkaConfig().getSubscribe(), (Object)jobMeta.getTopicName());
        Assert.assertEquals((Object)dataModel.getOwner(), (Object)jobMeta.getOwner());
        Assert.assertEquals((Object)StreamingUtils.getJobId((String)dataModel.getUuid(), (String)jobType.name()), (Object)jobMeta.getUuid());
    }

    private void assertCommonParams(Map<String, String> params) {
        Assert.assertTrue((!params.isEmpty() ? 1 : 0) != 0);
        Assert.assertEquals((Object)"yarn", (Object)params.get("spark.master"));
        Assert.assertEquals((Object)"512m", (Object)params.get("spark.driver.memory"));
        Assert.assertEquals((Object)"2", (Object)params.get("spark.executor.instances"));
        Assert.assertEquals((Object)"2", (Object)params.get("spark.executor.cores"));
        Assert.assertEquals((Object)"1g", (Object)params.get("spark.executor.memory"));
        Assert.assertEquals((Object)"8", (Object)params.get("spark.sql.shuffle.partitions"));
        Assert.assertEquals((Object)"false", (Object)params.get("kylin.streaming.job-retry-enabled"));
    }
}

