/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.streaming.metadata;

import java.util.ArrayList;
import java.util.List;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.util.NLocalFileMetadataTestCase;
import org.apache.kylin.job.execution.JobTypeEnum;
import org.apache.kylin.metadata.cube.model.NDataLayout;
import org.apache.kylin.metadata.cube.model.NDataSegment;
import org.apache.kylin.metadata.cube.model.NDataflow;
import org.apache.kylin.metadata.cube.model.NDataflowManager;
import org.apache.kylin.streaming.metadata.BuildLayoutWithRestUpdate;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class BuildLayoutWithRestUpdateTest
extends NLocalFileMetadataTestCase {
    private static String PROJECT = "streaming_test";
    @Rule
    public ExpectedException thrown = ExpectedException.none();

    @Before
    public void setUp() throws Exception {
        this.createTestMetadata(new String[0]);
    }

    @After
    public void tearDown() {
        this.cleanupTestMetadata();
    }

    @Test
    public void testUpdateLayouts() {
        BuildLayoutWithRestUpdate layoutUpdater = new BuildLayoutWithRestUpdate(JobTypeEnum.STREAMING_BUILD){

            public void updateLayouts(KylinConfig config, String project, String dataflowId, List<NDataLayout> layouts) {
                super.updateLayouts(config, project, dataflowId, layouts);
            }
        };
        String segId = "c380dd2a-43b8-4268-b73d-2a5f76236633";
        String dataflowId = "e78a89dd-847f-4574-8afa-8768b4228b72";
        KylinConfig testConfig = BuildLayoutWithRestUpdateTest.getTestConfig();
        NDataflowManager mgr = NDataflowManager.getInstance((KylinConfig)testConfig, (String)PROJECT);
        NDataflow df = mgr.getDataflow("e78a89dd-847f-4574-8afa-8768b4228b72");
        NDataSegment seg = df.getSegment("c380dd2a-43b8-4268-b73d-2a5f76236633");
        Assert.assertEquals((long)17L, (long)seg.getLayoutSize());
        ArrayList<NDataLayout> layouts = new ArrayList<NDataLayout>();
        layouts.add(NDataLayout.newDataLayout((NDataflow)df, (String)seg.getId(), (long)10002L));
        layoutUpdater.updateLayouts(testConfig, PROJECT, "e78a89dd-847f-4574-8afa-8768b4228b72", layouts);
        NDataflowManager mgr1 = NDataflowManager.getInstance((KylinConfig)testConfig, (String)PROJECT);
        NDataflow df1 = mgr1.getDataflow("e78a89dd-847f-4574-8afa-8768b4228b72");
        NDataSegment seg1 = df1.getSegment("c380dd2a-43b8-4268-b73d-2a5f76236633");
        Assert.assertEquals((long)17L, (long)seg1.getLayoutSize());
    }
}

