/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.streaming.merge;

import java.util.List;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.metadata.cube.model.IndexPlan;
import org.apache.kylin.metadata.cube.model.NDataflow;
import org.apache.kylin.metadata.cube.model.NDataflowManager;
import org.apache.kylin.metadata.cube.utils.StreamingUtils;
import org.apache.kylin.metadata.model.SegmentStatusEnum;
import org.apache.kylin.metadata.model.Segments;
import org.apache.kylin.streaming.merge.PeakMergePolicy;
import org.apache.kylin.streaming.util.ReflectionUtils;
import org.apache.kylin.streaming.util.StreamingTestCase;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class PeakMergePolicyTest
extends StreamingTestCase {
    private static String PROJECT = "streaming_test";
    private static String DATAFLOW_ID = "e78a89dd-847f-4574-8afa-8768b4228b73_rt";
    private static String MODEL_ID = "e78a89dd-847f-4574-8afa-8768b4228b73";
    @Rule
    public ExpectedException thrown = ExpectedException.none();
    private NDataflowManager mgr;
    private PeakMergePolicy peakMergePolicy;

    @Before
    public void setUp() throws Exception {
        this.createTestMetadata(new String[0]);
        this.mgr = NDataflowManager.getInstance((KylinConfig)PeakMergePolicyTest.getTestConfig(), (String)PROJECT);
        this.peakMergePolicy = new PeakMergePolicy();
    }

    @After
    public void tearDown() {
        this.cleanupTestMetadata();
    }

    @Test
    public void testSelectMatchedSegList1() {
        Long thresholdOf20k = StreamingUtils.parseSize((String)"20k");
        KylinConfig testConfig = PeakMergePolicyTest.getTestConfig();
        IndexPlan copy = this.createIndexPlan(testConfig, PROJECT, MODEL_ID, MODEL_ALIAS);
        NDataflowManager mgr = NDataflowManager.getInstance((KylinConfig)testConfig, (String)PROJECT);
        NDataflow df = mgr.createDataflow(copy, "test_owner");
        df = this.createSegments(mgr, df, 3);
        for (int i = 0; i < df.getSegments().size(); ++i) {
            ReflectionUtils.setField(df.getSegments().get(i), "storageSize", (Object)2048L);
        }
        df = mgr.getDataflow(df.getId());
        Segments segments = df.getSegments(new SegmentStatusEnum[]{SegmentStatusEnum.READY, SegmentStatusEnum.WARNING});
        List matchedSegList = this.peakMergePolicy.selectMatchedSegList((List)segments, 0, thresholdOf20k.longValue(), 3);
        Assert.assertEquals((long)0L, (long)matchedSegList.size());
    }

    @Test
    public void testSelectMatchedSegList() {
        Long thresholdOf4k = StreamingUtils.parseSize((String)"4k");
        KylinConfig testConfig = PeakMergePolicyTest.getTestConfig();
        IndexPlan copy = this.createIndexPlan(testConfig, PROJECT, MODEL_ID, MODEL_ALIAS);
        NDataflowManager mgr = NDataflowManager.getInstance((KylinConfig)testConfig, (String)PROJECT);
        NDataflow df = mgr.createDataflow(copy, "test_owner");
        df = this.createSegments(mgr, df, 3);
        for (int i = 0; i < df.getSegments().size(); ++i) {
            if (i < 2) {
                ReflectionUtils.setField(df.getSegments().get(i), "storageSize", (Object)2048L);
                continue;
            }
            ReflectionUtils.setField(df.getSegments().get(i), "storageSize", (Object)4096L);
        }
        df = mgr.getDataflow(df.getId());
        Segments segments = df.getSegments(new SegmentStatusEnum[]{SegmentStatusEnum.READY, SegmentStatusEnum.WARNING});
        List matchedSegList = this.peakMergePolicy.selectMatchedSegList((List)segments, 0, thresholdOf4k.longValue(), 3);
        Assert.assertEquals((long)3L, (long)matchedSegList.size());
        matchedSegList = this.peakMergePolicy.selectMatchedSegList((List)segments, 0, thresholdOf4k.longValue(), 5);
        Assert.assertEquals((long)3L, (long)matchedSegList.size());
        matchedSegList = this.peakMergePolicy.selectMatchedSegList((List)segments, 0, StreamingUtils.parseSize((String)"20k").longValue(), 3);
        Assert.assertEquals((long)0L, (long)matchedSegList.size());
        matchedSegList = this.peakMergePolicy.selectMatchedSegList((List)segments, 0, thresholdOf4k.longValue(), 2);
        Assert.assertEquals((long)0L, (long)matchedSegList.size());
    }
}

