/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.streaming.merge;

import java.io.IOException;
import java.util.List;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.metadata.cube.model.IndexPlan;
import org.apache.kylin.metadata.cube.model.NDataSegment;
import org.apache.kylin.metadata.cube.model.NDataflow;
import org.apache.kylin.metadata.cube.model.NDataflowManager;
import org.apache.kylin.metadata.model.SegmentStatusEnum;
import org.apache.kylin.metadata.model.Segments;
import org.apache.kylin.streaming.merge.NormalMergePolicy;
import org.apache.kylin.streaming.util.StreamingTestCase;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class NormalMergePolicyTest
extends StreamingTestCase {
    private static String PROJECT = "streaming_test";
    private static String MODEL_ID;
    private static String DATAFLOW_ID;
    private static int thresholdOf1k;
    @Rule
    public ExpectedException thrown = ExpectedException.none();
    private NDataflowManager mgr;
    private NormalMergePolicy normalMergePolicy;

    @Before
    public void setUp() throws Exception {
        this.createTestMetadata(new String[0]);
        this.mgr = NDataflowManager.getInstance((KylinConfig)NormalMergePolicyTest.getTestConfig(), (String)PROJECT);
        this.normalMergePolicy = new NormalMergePolicy();
    }

    @After
    public void tearDown() {
        this.cleanupTestMetadata();
    }

    @Test
    public void testSelectMatchedSegList() {
        NDataflow dataflow = this.mgr.getDataflow(DATAFLOW_ID);
        Segments segments = dataflow.getSegments().getSegments(new SegmentStatusEnum[]{SegmentStatusEnum.READY, SegmentStatusEnum.WARNING});
        Assert.assertTrue((((NDataSegment)segments.get(0)).getStorageBytesSize() > (long)thresholdOf1k ? 1 : 0) != 0);
        Assert.assertTrue((!((NDataSegment)segments.get(0)).getAdditionalInfo().isEmpty() ? 1 : 0) != 0);
        Assert.assertTrue((((NDataSegment)segments.get(1)).getStorageBytesSize() > (long)thresholdOf1k ? 1 : 0) != 0);
        Assert.assertTrue((!((NDataSegment)segments.get(1)).getAdditionalInfo().isEmpty() ? 1 : 0) != 0);
        Assert.assertTrue((((NDataSegment)segments.get(2)).getStorageBytesSize() > (long)thresholdOf1k ? 1 : 0) != 0);
        Assert.assertTrue((boolean)((NDataSegment)segments.get(2)).getAdditionalInfo().isEmpty());
        List matchedSegList = this.normalMergePolicy.selectMatchedSegList((List)segments, 1, (long)thresholdOf1k, 3);
        Assert.assertEquals((long)0L, (long)matchedSegList.size());
        List matchedSegList1 = this.normalMergePolicy.selectMatchedSegList((List)segments, 1, (long)(thresholdOf1k * 8), 3);
        Assert.assertEquals((long)0L, (long)matchedSegList1.size());
    }

    @Test
    public void testSelectMatchedSegListOfLayer0() throws IOException {
        KylinConfig testConfig = NormalMergePolicyTest.getTestConfig();
        IndexPlan copy = this.createIndexPlan(testConfig, PROJECT, MODEL_ID, MODEL_ALIAS);
        NDataflowManager mgr = NDataflowManager.getInstance((KylinConfig)testConfig, (String)PROJECT);
        NDataflow df = mgr.createDataflow(copy, "test_owner");
        df = this.createSegments(mgr, df, 30);
        df = this.setSegmentStorageSize(mgr, df, 2048L);
        Segments segments = df.getSegments(new SegmentStatusEnum[]{SegmentStatusEnum.READY, SegmentStatusEnum.WARNING});
        List matchedSegList = this.normalMergePolicy.selectMatchedSegList((List)segments, 0, (long)(thresholdOf1k * 20), 3);
        Assert.assertEquals((long)3L, (long)matchedSegList.size());
        List matchedSegList1 = this.normalMergePolicy.selectMatchedSegList((List)segments, 0, (long)(thresholdOf1k * 3), 5);
        Assert.assertEquals((long)3L, (long)matchedSegList1.size());
    }

    @Test
    public void testSelectMatchedSegListOfLayer1() throws IOException {
        KylinConfig testConfig = NormalMergePolicyTest.getTestConfig();
        IndexPlan copy = this.createIndexPlan(testConfig, PROJECT, MODEL_ID, MODEL_ALIAS);
        NDataflowManager mgr = NDataflowManager.getInstance((KylinConfig)testConfig, (String)PROJECT);
        NDataflow df = mgr.createDataflow(copy, "test_owner");
        df = this.createSegments(mgr, df, 30, 1);
        df = this.setSegmentStorageSize(mgr, df, 2048L);
        Segments segments = df.getSegments();
        List matchedSegList = this.normalMergePolicy.selectMatchedSegList((List)segments, 1, (long)(thresholdOf1k * 20), 3);
        Assert.assertEquals((long)3L, (long)matchedSegList.size());
        List matchedSegList1 = this.normalMergePolicy.selectMatchedSegList((List)segments, 1, (long)(thresholdOf1k * 3), 5);
        Assert.assertEquals((long)3L, (long)matchedSegList1.size());
    }

    static {
        DATAFLOW_ID = MODEL_ID = "e78a89dd-847f-4574-8afa-8768b4228b73";
        thresholdOf1k = 1024;
    }
}

