/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.streaming.merge;

import java.util.List;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.metadata.cube.model.IndexPlan;
import org.apache.kylin.metadata.cube.model.NDataSegment;
import org.apache.kylin.metadata.cube.model.NDataflow;
import org.apache.kylin.metadata.cube.model.NDataflowManager;
import org.apache.kylin.metadata.model.Segments;
import org.apache.kylin.streaming.merge.MergePolicy;
import org.apache.kylin.streaming.util.ReflectionUtils;
import org.apache.kylin.streaming.util.StreamingTestCase;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class MergePolicyTest
extends StreamingTestCase {
    private static String PROJECT = "streaming_test";
    private static String MODEL_ID = "e78a89dd-847f-4574-8afa-8768b4228b73";
    @Rule
    public ExpectedException thrown = ExpectedException.none();
    private NDataflowManager mgr;
    private MergePolicy mergePolicy;

    @Before
    public void setUp() throws Exception {
        this.createTestMetadata(new String[0]);
        this.mgr = NDataflowManager.getInstance((KylinConfig)MergePolicyTest.getTestConfig(), (String)PROJECT);
        this.mergePolicy = new MergePolicy(){

            public int findStartIndex(List<NDataSegment> segList, Long thresholdOfSegSize) {
                return super.findStartIndex(segList, thresholdOfSegSize);
            }

            public List<NDataSegment> selectMatchedSegList(List<NDataSegment> segList, int layer, long thresholdOfSegSize, int numOfSeg) {
                return null;
            }

            public boolean matchMergeCondition(long thresholdOfSegSize) {
                return false;
            }
        };
    }

    @After
    public void tearDown() {
        this.cleanupTestMetadata();
    }

    @Test
    public void testFindStartIndex() {
        KylinConfig testConfig = MergePolicyTest.getTestConfig();
        IndexPlan copy = this.createIndexPlan(testConfig, PROJECT, MODEL_ID, MODEL_ALIAS);
        NDataflowManager mgr = NDataflowManager.getInstance((KylinConfig)testConfig, (String)PROJECT);
        NDataflow df = mgr.createDataflow(copy, "test_owner");
        df = this.createSegments(mgr, df, 30);
        for (int i = 0; i < df.getSegments().size(); ++i) {
            if (i < 10) {
                ReflectionUtils.setField(df.getSegments().get(i), "storageSize", (Object)4096L);
                continue;
            }
            ReflectionUtils.setField(df.getSegments().get(i), "storageSize", (Object)2048L);
        }
        df = mgr.getDataflow(df.getId());
        Segments segments = df.getSegments();
        int startIndex = this.mergePolicy.findStartIndex((List)segments, Long.valueOf(1024L));
        Assert.assertEquals((long)-1L, (long)startIndex);
        int startIndex1 = this.mergePolicy.findStartIndex((List)segments, Long.valueOf(20480L));
        Assert.assertEquals((long)0L, (long)startIndex1);
        int startIndex2 = this.mergePolicy.findStartIndex((List)segments, Long.valueOf(2048L));
        Assert.assertEquals((long)10L, (long)startIndex2);
    }

    @Test
    public void testIsThresholdOfSegSizeOver() {
        boolean thresholdOver = this.mergePolicy.isThresholdOfSegSizeOver(20480L, 10240L);
        Assert.assertEquals((Object)true, (Object)thresholdOver);
        boolean thresholdOver1 = this.mergePolicy.isThresholdOfSegSizeOver(10240L, 10240L);
        Assert.assertEquals((Object)false, (Object)thresholdOver1);
    }
}

