/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.streaming.manager;

import com.google.common.collect.Lists;
import java.util.List;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.util.NLocalFileMetadataTestCase;
import org.apache.kylin.common.util.RandomUtil;
import org.apache.kylin.job.constant.JobStatusEnum;
import org.apache.kylin.job.execution.JobTypeEnum;
import org.apache.kylin.metadata.model.FunctionDesc;
import org.apache.kylin.metadata.model.NDataModel;
import org.apache.kylin.metadata.model.NTableMetadataManager;
import org.apache.kylin.metadata.model.ParameterDesc;
import org.apache.kylin.metadata.model.TableDesc;
import org.apache.kylin.metadata.model.TableRef;
import org.apache.kylin.metadata.streaming.KafkaConfig;
import org.apache.kylin.streaming.manager.StreamingJobManager;
import org.apache.kylin.streaming.metadata.StreamingJobMeta;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class StreamingJobManagerTest
extends NLocalFileMetadataTestCase {
    private static String PROJECT = "streaming_test";
    @Rule
    public ExpectedException thrown = ExpectedException.none();
    private StreamingJobManager mgr;
    private String modelTest = "model_test";
    private String ownerTest = "owner_test";

    @Before
    public void setUp() throws Exception {
        this.createTestMetadata(new String[0]);
        this.mgr = StreamingJobManager.getInstance((KylinConfig)StreamingJobManagerTest.getTestConfig(), (String)PROJECT);
    }

    @After
    public void tearDown() {
        this.cleanupTestMetadata();
    }

    @Test
    public void testGetStreamingJobByUuid() {
        String emptyId = "";
        Assert.assertNull((Object)this.mgr.getStreamingJobByUuid(""));
        String id = "e78a89dd-847f-4574-8afa-8768b4228b72_build";
        StreamingJobMeta streamingJobMeta = this.mgr.getStreamingJobByUuid("e78a89dd-847f-4574-8afa-8768b4228b72_build");
        Assert.assertNotNull((Object)streamingJobMeta);
    }

    @Test
    public void testCreateStreamingJobForBuild() {
        String uuid = RandomUtil.randomUUIDStr();
        NDataModel model = this.mockModel(uuid);
        this.mgr.createStreamingJob(model, JobTypeEnum.STREAMING_BUILD);
        StreamingJobMeta meta = this.mgr.getStreamingJobByUuid(uuid + "_build");
        Assert.assertNotNull((Object)meta);
        Assert.assertEquals((Object)(uuid + "_build"), (Object)meta.getUuid());
        Assert.assertEquals((Object)this.ownerTest, (Object)meta.getOwner());
        Assert.assertEquals((Object)uuid, (Object)meta.getModelId());
        Assert.assertEquals((Object)this.modelTest, (Object)meta.getModelName());
        Assert.assertEquals((Object)PROJECT, (Object)meta.getProject());
    }

    @Test
    public void testCreateStreamingJobForMerge() {
        String uuid = RandomUtil.randomUUIDStr();
        NDataModel model = this.mockModel(uuid);
        this.mgr.createStreamingJob(model, JobTypeEnum.STREAMING_MERGE);
        StreamingJobMeta meta = this.mgr.getStreamingJobByUuid(uuid + "_merge");
        Assert.assertNotNull((Object)meta);
        Assert.assertEquals((Object)(uuid + "_merge"), (Object)meta.getUuid());
        Assert.assertEquals((Object)this.ownerTest, (Object)meta.getOwner());
        Assert.assertEquals((Object)uuid, (Object)meta.getModelId());
        Assert.assertEquals((Object)this.modelTest, (Object)meta.getModelName());
        Assert.assertEquals((Object)PROJECT, (Object)meta.getProject());
    }

    @Test
    public void testCreateStreamingJob() {
        String uuid = RandomUtil.randomUUIDStr();
        NDataModel model = this.mockModel(uuid);
        this.mgr.createStreamingJob(model);
        StreamingJobMeta buildMeta = this.mgr.getStreamingJobByUuid(uuid + "_build");
        Assert.assertNotNull((Object)buildMeta);
        StreamingJobMeta mergeMeta = this.mgr.getStreamingJobByUuid(uuid + "_merge");
        Assert.assertNotNull((Object)mergeMeta);
    }

    @Test
    public void testCopy() {
        String id = "e78a89dd-847f-4574-8afa-8768b4228b72_build";
        StreamingJobMeta streamingJobMeta = this.mgr.getStreamingJobByUuid("e78a89dd-847f-4574-8afa-8768b4228b72_build");
        StreamingJobMeta copyMeta = this.mgr.copy(streamingJobMeta);
        Assert.assertNotNull((Object)copyMeta);
        Assert.assertEquals((Object)streamingJobMeta, (Object)copyMeta);
        Assert.assertNotEquals((long)System.identityHashCode(streamingJobMeta), (long)System.identityHashCode(copyMeta));
    }

    @Test
    public void testUpdateStreamingJob() {
        String id = "e78a89dd-847f-4574-8afa-8768b4228b72_build";
        StreamingJobMeta result = this.mgr.updateStreamingJob("e78a89dd-847f-4574-8afa-8768b4228b72_build", copyForWrite -> {
            copyForWrite.setProcessId("9999");
            copyForWrite.setNodeInfo("localhost:7070");
            copyForWrite.setCurrentStatus(JobStatusEnum.ERROR);
        });
        Assert.assertNotNull((Object)result);
        StreamingJobMeta meta = this.mgr.getStreamingJobByUuid("e78a89dd-847f-4574-8afa-8768b4228b72_build");
        Assert.assertEquals((Object)"9999", (Object)meta.getProcessId());
        Assert.assertEquals((Object)"localhost:7070", (Object)meta.getNodeInfo());
        Assert.assertEquals((Object)JobStatusEnum.ERROR, (Object)meta.getCurrentStatus());
    }

    @Test
    public void testUpdateStreamingJobOfErrorId() {
        String id = "e78a89dd-847f-4574-8afa-8768b4228b7_build";
        StreamingJobMeta result = this.mgr.updateStreamingJob("e78a89dd-847f-4574-8afa-8768b4228b7_build", copyForWrite -> {
            copyForWrite.setProcessId("9999");
            copyForWrite.setNodeInfo("localhost:7070");
            copyForWrite.setCurrentStatus(JobStatusEnum.ERROR);
        });
        Assert.assertNull((Object)result);
        StreamingJobMeta meta = this.mgr.getStreamingJobByUuid("e78a89dd-847f-4574-8afa-8768b4228b7_build");
        Assert.assertNull((Object)meta);
    }

    @Test
    public void testDeleteStreamingJob() {
        String id = "e78a89dd-847f-4574-8afa-8768b4228b72_build";
        StreamingJobMeta streamingJobMeta = this.mgr.getStreamingJobByUuid("e78a89dd-847f-4574-8afa-8768b4228b72_build");
        this.mgr.deleteStreamingJob("e78a89dd-847f-4574-8afa-8768b4228b72_build");
        StreamingJobMeta meta = this.mgr.getStreamingJobByUuid("e78a89dd-847f-4574-8afa-8768b4228b72_build");
        Assert.assertNull((Object)meta);
    }

    @Test
    public void testListAllStreamingJobMeta() {
        List lists = this.mgr.listAllStreamingJobMeta();
        Assert.assertEquals((long)11L, (long)lists.size());
    }

    private NDataModel mockModel(String uuid) {
        NDataModel model = new NDataModel();
        model.setUuid(uuid);
        model.setProject(PROJECT);
        model.setAlias(this.modelTest);
        model.setOwner(this.ownerTest);
        String tableName = "DEFAULT.SSB_TOPIC";
        model.setRootFactTableName("DEFAULT.SSB_TOPIC");
        NDataModel.Measure measure = new NDataModel.Measure();
        measure.setName("test_measure");
        measure.setFunction(FunctionDesc.newInstance((String)"COUNT", (List)Lists.newArrayList((Object[])new ParameterDesc[]{ParameterDesc.newInstance((Object)"1")}), (String)"bigint"));
        model.setAllMeasures((List)Lists.newArrayList((Object[])new NDataModel.Measure[]{measure}));
        KafkaConfig kafkaConf = new KafkaConfig();
        kafkaConf.setProject(PROJECT);
        kafkaConf.setDatabase("DEFAULT");
        kafkaConf.setName("SSB_TOPIC");
        kafkaConf.setKafkaBootstrapServers("10.1.2.210:9094");
        kafkaConf.setStartingOffsets("earliest");
        TableDesc tableDesc = NTableMetadataManager.getInstance((KylinConfig)StreamingJobManagerTest.getTestConfig(), (String)PROJECT).getTableDesc("DEFAULT.SSB_TOPIC");
        model.setRootFactTableRef(new TableRef(model, model.getAlias(), tableDesc, true));
        return model;
    }
}

