/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.streaming.jobs.thread;

import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.job.execution.JobTypeEnum;
import org.apache.kylin.metadata.cube.utils.StreamingUtils;
import org.apache.kylin.streaming.app.StreamingMergeEntry;
import org.apache.kylin.streaming.jobs.impl.StreamingJobLauncher;
import org.apache.kylin.streaming.jobs.thread.StreamingJobRunner;
import org.apache.kylin.streaming.util.AwaitUtils;
import org.apache.kylin.streaming.util.StreamingTestCase;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class StreamingJobRunnerTest
extends StreamingTestCase {
    private static String PROJECT = "streaming_test";
    @Rule
    public ExpectedException thrown = ExpectedException.none();
    private StreamingJobRunner runner;

    @Before
    public void setUp() throws Exception {
        this.createTestMetadata(new String[0]);
    }

    @After
    public void tearDown() {
        this.cleanupTestMetadata();
    }

    @Test
    public void testStop() {
        String modelId = "e78a89dd-847f-4574-8afa-8768b4228b72";
        StreamingMergeEntry app = new StreamingMergeEntry();
        String buildJobId = StreamingUtils.getJobId((String)"e78a89dd-847f-4574-8afa-8768b4228b72", (String)JobTypeEnum.STREAMING_BUILD.name());
        Assert.assertFalse((boolean)app.isGracefulShutdown(PROJECT, buildJobId));
        String mergeJobId = StreamingUtils.getJobId((String)"e78a89dd-847f-4574-8afa-8768b4228b72", (String)JobTypeEnum.STREAMING_MERGE.name());
        Assert.assertFalse((boolean)app.isGracefulShutdown(PROJECT, mergeJobId));
        this.runner = new StreamingJobRunner(PROJECT, "e78a89dd-847f-4574-8afa-8768b4228b72", JobTypeEnum.STREAMING_BUILD);
        this.runner.init();
        this.runner.stop();
        Assert.assertTrue((boolean)app.isGracefulShutdown(PROJECT, buildJobId));
        this.runner = new StreamingJobRunner(PROJECT, "e78a89dd-847f-4574-8afa-8768b4228b72", JobTypeEnum.STREAMING_MERGE);
        this.runner.init();
        this.runner.stop();
        Assert.assertTrue((boolean)app.isGracefulShutdown(PROJECT, mergeJobId));
    }

    @Test
    public void testStopWithNoInitial() {
        KylinConfig config = StreamingJobRunnerTest.getTestConfig();
        String modelId = "e78a89dd-847f-4574-8afa-8768b4228b72";
        this.runner = new StreamingJobRunner(PROJECT, "e78a89dd-847f-4574-8afa-8768b4228b72", JobTypeEnum.STREAMING_BUILD);
        this.runner.stop();
        StreamingMergeEntry app = new StreamingMergeEntry();
        String buildJobId = StreamingUtils.getJobId((String)"e78a89dd-847f-4574-8afa-8768b4228b72", (String)JobTypeEnum.STREAMING_BUILD.name());
        Assert.assertFalse((boolean)app.isGracefulShutdown(PROJECT, buildJobId));
        String mergeJobId = StreamingUtils.getJobId((String)"e78a89dd-847f-4574-8afa-8768b4228b72", (String)JobTypeEnum.STREAMING_MERGE.name());
        Assert.assertFalse((boolean)app.isGracefulShutdown(PROJECT, mergeJobId));
    }

    @Test
    public void testBuildJobRunner_run() {
        String modelId = "e78a89dd-847f-4574-8afa-8768b4228b72";
        StreamingJobRunner runner = new StreamingJobRunner(PROJECT, "e78a89dd-847f-4574-8afa-8768b4228b72", JobTypeEnum.STREAMING_BUILD);
        runner.init();
        AwaitUtils.await(() -> runner.run(), 10000, () -> {});
    }

    @Test
    public void testBuildJobLauncher_launch() {
        String modelId = "e78a89dd-847f-4574-8afa-8768b4228b72";
        StreamingJobLauncher launcher = new StreamingJobLauncher();
        launcher.init(PROJECT, "e78a89dd-847f-4574-8afa-8768b4228b72", JobTypeEnum.STREAMING_BUILD);
        AwaitUtils.await(() -> launcher.launch(), 10000, () -> {});
    }

    @Test
    public void testMergeJobLauncher_launch() {
        String modelId = "e78a89dd-847f-4574-8afa-8768b4228b72";
        StreamingJobLauncher launcher = new StreamingJobLauncher();
        launcher.init(PROJECT, "e78a89dd-847f-4574-8afa-8768b4228b72", JobTypeEnum.STREAMING_MERGE);
        AwaitUtils.await(() -> launcher.launch(), 10000, () -> {});
    }
}

