/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.streaming.jobs;

import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.metadata.cube.model.NDataSegment;
import org.apache.kylin.metadata.cube.model.NDataflow;
import org.apache.kylin.metadata.cube.model.NDataflowManager;
import org.apache.kylin.metadata.cube.model.NDataflowUpdate;
import org.apache.kylin.metadata.model.SegmentRange;
import org.apache.kylin.metadata.model.SegmentStatusEnum;
import org.apache.kylin.streaming.jobs.StreamingSegmentManager;
import org.apache.kylin.streaming.util.StreamingTestCase;
import org.apache.spark.sql.SparkSession;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class StreamingSegmentManagerTest
extends StreamingTestCase {
    private static String PROJECT = "streaming_test";
    private static String DATAFLOW_ID = "e78a89dd-847f-4574-8afa-8768b4228b73";
    @Rule
    public ExpectedException thrown = ExpectedException.none();

    @Before
    public void setUp() throws Exception {
        this.createTestMetadata(new String[0]);
    }

    @After
    public void tearDown() {
        this.cleanupTestMetadata();
    }

    @Test
    public void testAllocateSegment() {
        KylinConfig testConfig = StreamingSegmentManagerTest.getTestConfig();
        NDataflowManager mgr = NDataflowManager.getInstance((KylinConfig)testConfig, (String)PROJECT);
        NDataflow df = mgr.getDataflow(DATAFLOW_ID);
        NDataflowUpdate update = new NDataflowUpdate(df.getUuid());
        update.setToRemoveSegs((NDataSegment[])df.getSegments().toArray((Object[])new NDataSegment[0]));
        mgr.updateDataflow(update);
        df = mgr.getDataflow(df.getId());
        Assert.assertEquals((long)0L, (long)df.getSegments().size());
        SegmentRange.KafkaOffsetPartitionedSegmentRange sr = this.createSegmentRange();
        SparkSession ss = SparkSession.builder().master("local").appName("segbuild").getOrCreate();
        NDataSegment newSeg = StreamingSegmentManager.allocateSegment((SparkSession)ss, (SegmentRange.KafkaOffsetPartitionedSegmentRange)sr, (String)DATAFLOW_ID, (String)PROJECT, (Long)0L, (Long)1L);
        df = mgr.getDataflow(df.getId());
        Assert.assertEquals((long)1L, (long)df.getSegments().size());
        Assert.assertEquals((Object)SegmentStatusEnum.NEW, (Object)df.getSegment(newSeg.getId()).getStatus());
        ss.close();
    }
}

