/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.streaming.jobs;

import java.nio.ByteBuffer;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import org.apache.kylin.parser.AbstractDataParser;
import org.apache.kylin.streaming.PartitionRowIterator;
import org.apache.kylin.streaming.util.StreamingTestCase;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.RowFactory;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DataTypes;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.StructType;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import scala.collection.AbstractIterator;
import scala.collection.Iterator;
import scala.math.BigDecimal;

public class PartitionRowIteratorTest
extends StreamingTestCase {
    @Rule
    public ExpectedException thrown = ExpectedException.none();
    private static final String DEFAULT_CLASSNAME = "org.apache.kylin.parser.TimedJsonStreamParser";
    private static final AbstractDataParser<ByteBuffer> dataParser;

    @Before
    public void setUp() throws Exception {
        this.createTestMetadata(new String[0]);
    }

    @After
    public void tearDown() {
        this.cleanupTestMetadata();
    }

    @Test
    public void testNextEmpty() {
        StructType schema = new StructType().add("value", DataTypes.StringType);
        PartitionRowIterator partitionRowIter = new PartitionRowIterator((Iterator)new AbstractIterator<Row>(){

            public boolean hasNext() {
                return true;
            }

            public Row next() {
                return RowFactory.create((Object[])new Object[]{""});
            }
        }, schema, "value", dataParser);
        Assert.assertTrue((boolean)partitionRowIter.hasNext());
        Row row = partitionRowIter.next();
        Assert.assertEquals((long)0L, (long)row.length());
    }

    @Test
    public void testNextParseException() {
        StructType schema = new StructType().add("value", DataTypes.IntegerType);
        PartitionRowIterator partitionRowIter = new PartitionRowIterator((Iterator)new AbstractIterator<Row>(){

            public boolean hasNext() {
                return true;
            }

            public Row next() {
                return RowFactory.create((Object[])new Object[]{"{\"value\":\"ab\"}"});
            }
        }, schema, "value", dataParser);
        Assert.assertTrue((boolean)partitionRowIter.hasNext());
        Row row = partitionRowIter.next();
        Assert.assertEquals((long)0L, (long)row.length());
    }

    @Test
    public void testConvertEmptyJsonValue2Row() {
        List<DataType> schemas = Arrays.asList(DataTypes.ShortType, DataTypes.IntegerType, DataTypes.LongType, DataTypes.DoubleType, DataTypes.FloatType, DataTypes.BooleanType, DataTypes.TimestampType, DataTypes.DateType, DecimalType.apply((int)5, (int)2));
        schemas.forEach(dataType -> {
            StructType schema = new StructType().add("value", dataType);
            PartitionRowIterator partitionRowIter = new PartitionRowIterator(null, schema, "value", dataParser);
            Row row = partitionRowIter.parseToRow("{}");
            Assert.assertNull((Object)row.get(0));
            row = partitionRowIter.parseToRow("{\"value\":\"\"}");
            Assert.assertNull((Object)row.get(0));
            row = partitionRowIter.parseToRow("{\"value2\":\"\"}");
            Assert.assertNull((Object)row.get(0));
        });
    }

    @Test
    public void testConvertJson2Row() {
        StructType schema = new StructType().add("value1", DataTypes.ShortType).add("value2", DataTypes.IntegerType).add("value3", DataTypes.LongType).add("value4", DataTypes.DoubleType).add("value5", DataTypes.FloatType).add("value6", DataTypes.BooleanType);
        PartitionRowIterator partitionRowIter = new PartitionRowIterator(null, schema, "value2", dataParser);
        Row row = partitionRowIter.parseToRow("{\"value1\":121,\"value2\":122,\"value3\":123,\"value4\":124, \"value5\":125,\"value6\":true}");
        Assert.assertEquals((Object)121, (Object)row.get(0));
        Assert.assertEquals((Object)122, (Object)row.get(1));
        Assert.assertEquals((Object)123L, (Object)row.get(2));
        Assert.assertEquals((Object)124.0, (Object)row.get(3));
        Assert.assertEquals((Object)Float.valueOf(125.0f), (Object)row.get(4));
        Assert.assertEquals((Object)true, (Object)row.get(5));
        schema = new StructType().add("value1", (DataType)DecimalType.apply((int)38, (int)18));
        partitionRowIter = new PartitionRowIterator(null, schema, null, dataParser);
        row = partitionRowIter.parseToRow("{\"value1\":4.567}");
        Assert.assertEquals((Object)BigDecimal.valueOf((double)4.567), (Object)row.get(0));
        schema = new StructType().add("value1", DataTypes.StringType);
        partitionRowIter = new PartitionRowIterator(null, schema, null, dataParser);
        row = partitionRowIter.parseToRow("{\"value1\":\"\"}");
        Assert.assertEquals((Object)"", (Object)row.get(0));
    }

    @Test
    public void testTimestampType() {
        StructType schema = new StructType().add("value", DataTypes.TimestampType);
        PartitionRowIterator partitionRowIterator = new PartitionRowIterator(null, schema, "value", dataParser);
        Assert.assertThrows((String)"invalid value 1970-01-01 00:00:00", IllegalArgumentException.class, () -> partitionRowIterator.parseToRow("{\"value\": \"1970-01-01 00:00:00\"}"));
        Row row = partitionRowIterator.parseToRow("{\"value\": \"1970-01-01 08:00:00\"}");
        Assert.assertEquals((long)0L, (long)((Timestamp)row.get(0)).getTime());
        row = partitionRowIterator.parseToRow("{\"value\": \"2022-01-01 08:00:00\"}");
        Assert.assertEquals((long)1640995200000L, (long)((Timestamp)row.get(0)).getTime());
    }

    @Test
    public void testTimestampTypeOfNonePartitionColumn() {
        StructType schema = new StructType().add("value", DataTypes.TimestampType);
        PartitionRowIterator partitionRowIterator = new PartitionRowIterator(null, schema, null, dataParser);
        Row row = partitionRowIterator.parseToRow("{\"value\": \"1956-01-01 00:00:00\"}");
        Assert.assertEquals((long)-441878400000L, (long)((Timestamp)row.get(0)).getTime());
        row = partitionRowIterator.parseToRow("{\"value\": \"1970-01-01 08:00:00\"}");
        Assert.assertEquals((long)0L, (long)((Timestamp)row.get(0)).getTime());
        row = partitionRowIterator.parseToRow("{\"value\": \"2022-01-01 08:00:00\"}");
        Assert.assertEquals((long)1640995200000L, (long)((Timestamp)row.get(0)).getTime());
    }

    @Test
    public void testDateType() {
        StructType schema = new StructType().add("value", DataTypes.DateType);
        PartitionRowIterator partitionRowIterator = new PartitionRowIterator(null, schema, null, dataParser);
        Row row = partitionRowIterator.parseToRow("{\"value\": \"1956-01-02\"}");
        Assert.assertEquals((long)-441792000000L, (long)((Date)row.get(0)).getTime());
        row = partitionRowIterator.parseToRow("{\"value\": \"1970-01-01\"}");
        Assert.assertEquals((long)-28800000L, (long)((Date)row.get(0)).getTime());
        row = partitionRowIterator.parseToRow("{\"value\": \"1970-01-02\"}");
        Assert.assertEquals((long)57600000L, (long)((Date)row.get(0)).getTime());
        row = partitionRowIterator.parseToRow("{\"value\": \"2022-01-01\"}");
        Assert.assertEquals((long)1640966400000L, (long)((Date)row.get(0)).getTime());
    }

    static {
        try {
            dataParser = AbstractDataParser.getDataParser((String)DEFAULT_CLASSNAME, (ClassLoader)Thread.currentThread().getContextClassLoader());
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException(e);
        }
    }
}

