/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.parser;

import com.fasterxml.jackson.core.JsonParseException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.kylin.parser.AbstractDataParser;
import org.junit.Assert;
import org.junit.Test;

public class TimedJsonStreamParserTest {
    private static final String jsonFilePath = "src/test/resources/message.json";
    private static final String dupKeyJsonFilePath = "src/test/resources/message_with_dup_key.json";
    private static final String className = "org.apache.kylin.parser.TimedJsonStreamParser";

    @Test
    public void testFlattenMessage() throws Exception {
        InputStream is = Files.newInputStream(Paths.get(jsonFilePath, new String[0]), new OpenOption[0]);
        ByteBuffer buffer = ByteBuffer.wrap(IOUtils.toByteArray((InputStream)is));
        AbstractDataParser parser = AbstractDataParser.getDataParser((String)className, (ClassLoader)Thread.currentThread().getContextClassLoader());
        Map flatMap = parser.process((Object)buffer);
        Assert.assertEquals((long)29L, (long)flatMap.size());
        Assert.assertEquals((Object)"Jul 20, 2016 9:59:17 AM", flatMap.get("createdAt"));
        Assert.assertEquals((Object)755703618762862600L, flatMap.get("id"));
        Assert.assertEquals((Object)false, flatMap.get("isTruncated"));
        Assert.assertEquals((Object)"dejamos", flatMap.get("text"));
        Assert.assertEquals((Object)"", flatMap.get("contributorsIDs"));
        Assert.assertEquals((Object)755703584084328400L, flatMap.get("mediaEntities_0_id"));
        Assert.assertEquals((Object)150, flatMap.get("mediaEntities_0_sizes_0_width"));
        Assert.assertEquals((Object)100, flatMap.get("mediaEntities_0_sizes_1_resize"));
        Assert.assertEquals((Object)4853763947L, flatMap.get("user_id"));
        Assert.assertEquals((Object)"Noticias", flatMap.get("user_description"));
        Assert.assertEquals((Object)false, flatMap.get("user_is_Default_Profile_Image"));
        Assert.assertEquals((Object)false, flatMap.get("user_isProtected"));
    }

    @Test
    public void testFlattenMessageWithDupKey() throws Exception {
        InputStream is = Files.newInputStream(Paths.get(dupKeyJsonFilePath, new String[0]), new OpenOption[0]);
        ByteBuffer buffer = ByteBuffer.wrap(IOUtils.toByteArray((InputStream)is));
        AbstractDataParser parser = AbstractDataParser.getDataParser((String)className, (ClassLoader)Thread.currentThread().getContextClassLoader());
        Map flatMap = parser.process((Object)buffer);
        Assert.assertEquals((long)31L, (long)flatMap.size());
        Assert.assertEquals((Object)"Jul 20, 2016 9:59:17 AM", flatMap.get("createdAt"));
        Assert.assertEquals((Object)755703618762862600L, flatMap.get("id"));
        Assert.assertEquals((Object)false, flatMap.get("isTruncated"));
        Assert.assertEquals((Object)"dejamos", flatMap.get("text"));
        Assert.assertEquals((Object)"", flatMap.get("contributorsIDs"));
        Assert.assertEquals((Object)755703584084328400L, flatMap.get("mediaEntities_0_id"));
        Assert.assertEquals((Object)150, flatMap.get("mediaEntities_0_sizes_0_width"));
        Assert.assertEquals((Object)100, flatMap.get("mediaEntities_0_sizes_1_resize"));
        Assert.assertEquals((Object)"Noticias", flatMap.get("user_description"));
        Assert.assertEquals((Object)false, flatMap.get("user_is_Default_Profile_Image"));
        Assert.assertEquals((Object)false, flatMap.get("user_isProtected"));
        Assert.assertEquals((Object)123456, flatMap.get("user_id"));
        Assert.assertEquals((Object)4853763947L, flatMap.get("user_id_1"));
        Assert.assertEquals((Object)654321, flatMap.get("user_id_1_1"));
    }

    @Test
    public void testException() throws Exception {
        String text = "test";
        AbstractDataParser parser = AbstractDataParser.getDataParser((String)className, (ClassLoader)Thread.currentThread().getContextClassLoader());
        ByteBuffer input = StandardCharsets.UTF_8.encode(text);
        Assert.assertThrows(JsonParseException.class, () -> parser.process((Object)input));
    }
}

