/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.parser;

import java.util.HashMap;
import org.apache.kylin.parser.AbstractTimeParser;
import org.apache.kylin.parser.AbstractTimeParserTestBase;
import org.junit.Assert;
import org.junit.Test;

public class DefaultTimeParserTest
extends AbstractTimeParserTestBase {
    private static final String TS_TIMEZONE = "tsTimezone";
    private static final String TS_PARSER = "org.apache.kylin.parser.DefaultTimeParser";

    @Test
    public void testParseBlankTime() throws Exception {
        HashMap<String, String> props = new HashMap<String, String>();
        props.put(TS_TIMEZONE, "GMT");
        AbstractTimeParser timeParser = this.getDateTimeParser(TS_PARSER, props);
        long time = timeParser.parseTime("");
        Assert.assertEquals((long)0L, (long)time);
        time = timeParser.parseTime(null);
        Assert.assertEquals((long)0L, (long)time);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testParseNoValidTime() throws Exception {
        HashMap<String, String> props = new HashMap<String, String>();
        props.put(TS_TIMEZONE, "GMT");
        AbstractTimeParser timeParser = this.getDateTimeParser(TS_PARSER, props);
        timeParser.parseTime("1a11b23423c");
    }

    @Test
    public void testParseTimeWithTimeZone_GMT() throws Exception {
        HashMap<String, String> props = new HashMap<String, String>();
        props.put(TS_TIMEZONE, "GMT");
        AbstractTimeParser timeParser = this.getDateTimeParser(TS_PARSER, props);
        long time = timeParser.parseTime("1569240794000");
        Assert.assertEquals((long)1569240794000L, (long)time);
    }

    @Test
    public void testParseTimeWithTimeZone_GMT_0() throws Exception {
        HashMap<String, String> props = new HashMap<String, String>();
        props.put(TS_TIMEZONE, "GMT+0");
        AbstractTimeParser timeParser = this.getDateTimeParser(TS_PARSER, props);
        long time = timeParser.parseTime("1569240794000");
        Assert.assertEquals((long)1569240794000L, (long)time);
    }

    @Test
    public void testParseTimeWithTimeZone_GMT_8() throws Exception {
        HashMap<String, String> props = new HashMap<String, String>();
        props.put(TS_TIMEZONE, "GMT+8");
        AbstractTimeParser timeParser = this.getDateTimeParser(TS_PARSER, props);
        long time = timeParser.parseTime("1569211994000");
        Assert.assertEquals((long)1569240794000L, (long)time);
    }
}

