/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.parser;

import java.util.HashMap;
import org.apache.kylin.parser.AbstractTimeParser;
import org.apache.kylin.parser.AbstractTimeParserTestBase;
import org.apache.kylin.parser.DateTimeParser;
import org.junit.Assert;
import org.junit.Test;

public class DateTimeParserTest
extends AbstractTimeParserTestBase {
    private static final String TS_PATTERN = "tsPattern";
    private static final String TS_PARSER = "org.apache.kylin.parser.DateTimeParser";

    @Test
    public void testParse_COMPACT_DATE_PATTERN() throws Exception {
        HashMap<String, String> props = new HashMap<String, String>();
        props.put(TS_PATTERN, "yyyyMMdd");
        AbstractTimeParser timeParser = this.getDateTimeParser(TS_PARSER, props);
        long time = timeParser.parseTime("20190923");
        Assert.assertEquals((long)1569168000000L, (long)time);
    }

    @Test
    public void testParse_DEFAULT_DATE_PATTERN() throws Exception {
        HashMap<String, String> props = new HashMap<String, String>();
        props.put(TS_PATTERN, "yyyy-MM-dd");
        props.put(TS_PATTERN, "yyyy-MM-dd");
        AbstractTimeParser timeParser = this.getDateTimeParser(TS_PARSER, props);
        long time = timeParser.parseTime("2019-09-23");
        Assert.assertEquals((long)1569168000000L, (long)time);
    }

    @Test
    public void testParse_DEFAULT_TIME_PATTERN() throws Exception {
        HashMap<String, String> props = new HashMap<String, String>();
        props.put(TS_PATTERN, "HH:mm:ss");
        AbstractTimeParser timeParser = this.getDateTimeParser(TS_PARSER, props);
        long time = timeParser.parseTime("12:13:14");
        Assert.assertEquals((long)15194000L, (long)time);
    }

    @Test
    public void testParse_DEFAULT_DATETIME_PATTERN_WITHOUT_MILLISECONDS() throws Exception {
        HashMap<String, String> props = new HashMap<String, String>();
        props.put(TS_PATTERN, "yyyy-MM-dd HH:mm:ss");
        AbstractTimeParser timeParser = this.getDateTimeParser(TS_PARSER, props);
        long time = timeParser.parseTime("2019-09-23 12:13:14");
        Assert.assertEquals((long)1569211994000L, (long)time);
    }

    @Test
    public void testParse_DEFAULT_DATETIME_PATTERN_WITH_MILLISECONDS() throws Exception {
        HashMap<String, String> props = new HashMap<String, String>();
        props.put(TS_PATTERN, "yyyy-MM-dd HH:mm:ss.SSS");
        AbstractTimeParser timeParser = this.getDateTimeParser(TS_PARSER, props);
        long time = timeParser.parseTime("2019-09-23 12:13:14.135");
        Assert.assertEquals((long)1569211994135L, (long)time);
    }

    @Test
    public void testParse_SelfDefined_1() throws Exception {
        HashMap<String, String> props = new HashMap<String, String>();
        props.put(TS_PATTERN, "MM-dd-yyyy HH:mm:ss");
        AbstractTimeParser timeParser = this.getDateTimeParser(TS_PARSER, props);
        long time = timeParser.parseTime("09-23-2019 12:13:14");
        Assert.assertEquals((long)1569211994000L, (long)time);
    }

    @Test
    public void testParse_SelfDefined_2() throws Exception {
        HashMap<String, String> props = new HashMap<String, String>();
        props.put(TS_PATTERN, "HH:mm:ss MM-dd-yyyy");
        AbstractTimeParser timeParser = this.getDateTimeParser(TS_PARSER, props);
        long time = timeParser.parseTime("12:13:14 09-23-2019");
        Assert.assertEquals((long)1569211994000L, (long)time);
    }

    @Test
    public void testParseTime() {
        HashMap<String, String> props1 = new HashMap<String, String>();
        props1.put(TS_PATTERN, "yyyy/MM/dd");
        HashMap<String, String> props2 = new HashMap<String, String>();
        props2.put(TS_PATTERN, "MM.dd.yyyy");
        DateTimeParser parser1 = new DateTimeParser(props1);
        DateTimeParser parser2 = new DateTimeParser(props2);
        Long parsedTime1 = parser1.parseTime("2000/12/1");
        Long parsedTime2 = parser2.parseTime("12.1.2000");
        Assert.assertEquals((Object)parsedTime1, (Object)parsedTime2);
    }
}

