/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.parser;

import com.fasterxml.jackson.core.JsonParseException;
import com.google.common.collect.Maps;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import org.apache.kylin.parser.AbstractDataParser;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class AbstractDataParserTest {
    @Rule
    public ExpectedException expectedException = ExpectedException.none();

    @Test
    public void testGetDataParser() throws Exception {
        String json1 = "{\"cust_no\":\"343242\",\"windowDate\":\"2021-06-01 00:00:00\",\"windowDateLong\":\"1625037465002\",\"msg_type\":\"single\",\"msg_type1\":\"old\",\"msg_type2\":\"jily\",\"msg_type3\":\"pandora\",\"age\":\"32\",\"bal1\":21,\"bal2\":12,\"bal3\":13,\"bal4\":15,\"bal5\":22}";
        String json2 = "{\"cust_no\":\"343242\",\"windowDate\":\"2021-06-01 00:00:00\",\"windowDateLong\":\"1625037465002\",\"msg_type\":\"single\",\"msg_type1\":\"old\",\"msg_type2\":\"jily\",\"msg_type3\":\"pandora\",\"age\":\"32\",\"bal1\":21,\"bal2\":12,\"bal3\":13,\"bal4\":15,\"bal5\":22";
        AbstractDataParser dataParser = AbstractDataParser.getDataParser((String)"org.apache.kylin.parser.TimedJsonStreamParser", (ClassLoader)Thread.currentThread().getContextClassLoader());
        Assert.assertNotNull((Object)dataParser);
        dataParser.before();
        dataParser.after((Map)Maps.newHashMap());
        Assert.assertTrue((boolean)dataParser.defineDataTypes().isEmpty());
        dataParser.process((Object)StandardCharsets.UTF_8.encode(json1));
        dataParser.process(null);
        ByteBuffer encode = StandardCharsets.UTF_8.encode(json2);
        Assert.assertThrows(JsonParseException.class, () -> dataParser.process((Object)encode));
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        Assert.assertThrows(IllegalStateException.class, () -> AbstractDataParser.getDataParser(null, (ClassLoader)contextClassLoader));
        Assert.assertThrows(IllegalStateException.class, () -> AbstractDataParser.getDataParser((String)"java.lang.String", (ClassLoader)contextClassLoader));
    }
}

