/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.kafka.util;

import java.io.File;
import java.lang.reflect.Constructor;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Properties;
import lombok.Generated;
import org.apache.commons.io.FileUtils;
import org.apache.kafka.clients.admin.AdminClient;
import org.apache.kafka.clients.admin.internals.AdminMetadataManager;
import org.apache.kafka.common.Cluster;
import org.apache.kafka.common.Node;
import org.apache.kylin.common.KapConfig;
import org.apache.kylin.common.util.Pair;
import org.apache.kylin.kafka.util.KafkaUtils;
import org.apache.kylin.streaming.jobs.StreamingJobUtils;
import org.apache.kylin.streaming.util.ReflectionUtils;
import org.apache.kylin.streaming.util.StreamingTestCase;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KafkaUtilsTest
extends StreamingTestCase {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(KafkaUtilsTest.class);
    @Rule
    public ExpectedException thrown = ExpectedException.none();

    @Before
    public void setUp() throws Exception {
        this.createTestMetadata(new String[0]);
    }

    @After
    public void tearDown() {
        this.cleanupTestMetadata();
    }

    @Test
    public void testConstructMethod() {
        Constructor<?>[] constructors = KafkaUtils.class.getDeclaredConstructors();
        Assert.assertEquals((long)1L, (long)constructors.length);
        try {
            constructors[0].setAccessible(true);
            constructors[0].newInstance(new Object[0]);
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e.getCause() instanceof IllegalStateException));
        }
    }

    @Test
    public void testConstructDefaultKafkaConsumerProperties() {
        Properties prop = KafkaUtils.getConsumerProperties((String)"localhost:9092", (String)"client1", (Properties)new Properties());
        Assert.assertNotNull((Object)prop);
        Properties propNull = KafkaUtils.getConsumerProperties((String)"localhost:9092", (String)"client1", null);
        Assert.assertNotNull((Object)propNull);
        Assert.assertEquals((Object)"localhost:9092", (Object)prop.getProperty("bootstrap.servers"));
        Assert.assertEquals((Object)"client1", (Object)prop.getProperty("group.id"));
        Assert.assertEquals((Object)"false", (Object)prop.getProperty("enable.auto.commit"));
    }

    @Test
    public void testKafkaAdminClient() {
        try (AdminClient client = KafkaUtils.getKafkaAdminClient((String)"localhost:9092", (String)"group1");){
            AdminMetadataManager metadataManager = (AdminMetadataManager)ReflectionUtils.getField(client, "metadataManager");
            Cluster cluster = (Cluster)ReflectionUtils.getField(metadataManager, "cluster");
            List nodes = cluster.nodes();
            Assert.assertEquals((Object)"localhost", (Object)((Node)nodes.get(0)).host());
            Assert.assertEquals((long)9092L, (long)((Node)nodes.get(0)).port());
        }
        catch (Exception e) {
            log.error("failed to close AdminClient.", (Throwable)e);
        }
    }

    @Test
    public void testConstructDefaultKafkaAdminClientProperties() throws Exception {
        Properties prop = KafkaUtils.getAdminClientProperties((String)"localhost:9092", (String)"group1", (Properties)new Properties());
        Assert.assertNotNull((Object)prop);
        Properties prop1 = KafkaUtils.getAdminClientProperties((String)"localhost:9092", (String)"group1", null);
        Assert.assertNotNull((Object)prop1);
        Assert.assertEquals((Object)"localhost:9092", (Object)prop.getProperty("bootstrap.servers"));
        Assert.assertEquals((Object)"group1", (Object)prop.getProperty("group.id"));
        KapConfig kapConfig = KapConfig.getInstanceFromEnv();
        FileUtils.write((File)new File(kapConfig.getKafkaJaasConfPath()), (CharSequence)"KafkaClient{ org.apache.kafka.common.security.scram.ScramLoginModule required;};", (Charset)StandardCharsets.UTF_8);
        String text = StreamingJobUtils.extractKafkaJaasConf((boolean)true);
        Assert.assertNull((Object)text);
        Pair kafkaJaasTextPair = (Pair)ReflectionUtils.getField(KafkaUtils.class, "kafkaJaasTextPair");
        kafkaJaasTextPair.setFirst((Object)false);
        KafkaUtilsTest.getTestConfig().setProperty("kylin.kafka-jaas.enabled", "true");
        Properties prop2 = KafkaUtils.getAdminClientProperties((String)"localhost:9092", (String)"group1", null);
        Assert.assertNotNull((Object)prop2.get("sasl.jaas.config"));
        KafkaUtilsTest.getTestConfig().setProperty("kylin.kafka-jaas.enabled", "false");
    }
}

