/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.kafka;

import java.util.Collections;
import java.util.HashMap;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.StreamingTestConstant;
import org.apache.kylin.engine.spark.NSparkCubingEngine;
import org.apache.kylin.metadata.model.ISourceAware;
import org.apache.kylin.metadata.model.NTableMetadataManager;
import org.apache.kylin.metadata.model.SegmentRange;
import org.apache.kylin.metadata.model.TableDesc;
import org.apache.kylin.source.ISourceMetadataExplorer;
import org.apache.kylin.source.SourceFactory;
import org.apache.kylin.source.kafka.KafkaExplorer;
import org.apache.kylin.source.kafka.NSparkKafkaSource;
import org.apache.kylin.streaming.util.StreamingTestCase;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.SparkSession;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class NSparkKafkaSourceTest
extends StreamingTestCase {
    @Rule
    public ExpectedException thrown = ExpectedException.none();
    private static String PROJECT = "streaming_test";
    private static String DATAFLOW_ID = "e78a89dd-847f-4574-8afa-8768b4228b73";

    @Before
    public void setUp() throws Exception {
        this.createTestMetadata(new String[0]);
    }

    @After
    public void tearDown() {
        this.cleanupTestMetadata();
    }

    @Test
    public void testGetSourceMetadataExplorer() {
        KylinConfig config = NSparkKafkaSourceTest.getTestConfig();
        NSparkKafkaSource source = this.createSparkKafkaSource(config);
        ISourceMetadataExplorer kafkaExplorer = source.getSourceMetadataExplorer();
        Assert.assertTrue((boolean)(kafkaExplorer instanceof KafkaExplorer));
        Assert.assertTrue((boolean)kafkaExplorer.checkTablesAccess(Collections.emptySet()));
    }

    @Test
    public void testAdaptToBuildEngine() {
        KylinConfig config = NSparkKafkaSourceTest.getTestConfig();
        NSparkKafkaSource source = this.createSparkKafkaSource(config);
        source.enableMemoryStream(false);
        Assert.assertFalse((boolean)source.enableMemoryStream());
        source.post(StreamingTestConstant.KAP_SSB_STREAMING_JSON_FILE());
        SparkSession ss = this.createSparkSession();
        NTableMetadataManager tableMetadataManager = NTableMetadataManager.getInstance((KylinConfig)NSparkKafkaSourceTest.getTestConfig(), (String)PROJECT);
        TableDesc tableDesc = tableMetadataManager.getTableDesc("SSB.P_LINEORDER");
        NSparkCubingEngine.NSparkCubingSource engineAdapter = (NSparkCubingEngine.NSparkCubingSource)SourceFactory.createEngineAdapter((ISourceAware)tableDesc, NSparkCubingEngine.NSparkCubingSource.class);
        Dataset ds = engineAdapter.getSourceData(tableDesc, ss, new HashMap());
        Assert.assertEquals((long)1L, (long)ds.count());
        this.thrown.expect(UnsupportedOperationException.class);
        source.createReadableTable(tableDesc);
    }

    @Test
    public void testAdaptToBuildEngine1() {
        KylinConfig config = NSparkKafkaSourceTest.getTestConfig();
        NSparkKafkaSource source = this.createSparkKafkaSource(config);
        source.enableMemoryStream(true);
        Assert.assertTrue((boolean)source.enableMemoryStream());
        source.post(StreamingTestConstant.KAP_SSB_STREAMING_JSON_FILE());
        NTableMetadataManager tableMetadataManager = NTableMetadataManager.getInstance((KylinConfig)NSparkKafkaSourceTest.getTestConfig(), (String)PROJECT);
        TableDesc tableDesc = tableMetadataManager.getTableDesc("SSB.P_LINEORDER");
        NSparkCubingEngine.NSparkCubingSource engineAdapter = (NSparkCubingEngine.NSparkCubingSource)SourceFactory.createEngineAdapter((ISourceAware)tableDesc, NSparkCubingEngine.NSparkCubingSource.class);
        SparkSession ss = this.createSparkSession();
        Dataset ds = engineAdapter.getSourceData(tableDesc, ss, new HashMap());
        Assert.assertEquals((Object)"memory", (Object)ds.logicalPlan().toString());
    }

    @Test
    public void testCreateReadableTable() {
        KylinConfig config = NSparkKafkaSourceTest.getTestConfig();
        NSparkKafkaSource source = this.createSparkKafkaSource(config);
        this.thrown.expect(UnsupportedOperationException.class);
        source.createReadableTable(null);
    }

    @Test
    public void testEnrichSourcePartitionBeforeBuild() {
        KylinConfig config = NSparkKafkaSourceTest.getTestConfig();
        NSparkKafkaSource source = this.createSparkKafkaSource(config);
        this.thrown.expect(UnsupportedOperationException.class);
        source.enrichSourcePartitionBeforeBuild(null, null);
    }

    @Test
    public void testGetSampleDataDeployer() {
        KylinConfig config = NSparkKafkaSourceTest.getTestConfig();
        NSparkKafkaSource source = this.createSparkKafkaSource(config);
        this.thrown.expect(UnsupportedOperationException.class);
        source.getSampleDataDeployer();
    }

    @Test
    public void testGetSegmentRange() {
        KylinConfig config = NSparkKafkaSourceTest.getTestConfig();
        NSparkKafkaSource source = this.createSparkKafkaSource(config);
        SegmentRange.KafkaOffsetPartitionedSegmentRange seg = (SegmentRange.KafkaOffsetPartitionedSegmentRange)source.getSegmentRange("1234", "5678");
        Assert.assertTrue((boolean)(seg instanceof SegmentRange.KafkaOffsetPartitionedSegmentRange));
        Assert.assertEquals((long)1234L, (long)seg.getStart());
        Assert.assertEquals((long)5678L, (long)seg.getEnd());
        SegmentRange.KafkaOffsetPartitionedSegmentRange seg1 = (SegmentRange.KafkaOffsetPartitionedSegmentRange)source.getSegmentRange("", "");
        Assert.assertEquals((long)0L, (long)seg1.getStart());
        Assert.assertEquals((long)Long.MAX_VALUE, (long)seg1.getEnd());
    }

    @Test
    public void testSupportBuildSnapShotByPartition() {
        KylinConfig config = NSparkKafkaSourceTest.getTestConfig();
        NSparkKafkaSource source = this.createSparkKafkaSource(config);
        Assert.assertTrue((boolean)source.supportBuildSnapShotByPartition());
    }
}

