/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.storage.hbase.util;

import java.io.IOException;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.util.AbstractApplication;
import org.apache.kylin.common.util.OptionsHelper;
import org.apache.kylin.storage.hbase.HBaseConnection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HtableAlterMetadataCLI
extends AbstractApplication {
    private static final Option OPTION_METADATA_KEY;
    private static final Option OPTION_METADATA_VALUE;
    protected static final Option OPTION_HTABLE_NAME;
    protected static final Logger logger;
    String tableName;
    String metadataKey;
    String metadataValue;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void alter() throws IOException {
        Connection conn = HBaseConnection.get(KylinConfig.getInstanceFromEnv().getStorageUrl());
        try (Admin hbaseAdmin = null;){
            hbaseAdmin = conn.getAdmin();
            HTableDescriptor table = hbaseAdmin.getTableDescriptor(TableName.valueOf((String)this.tableName));
            hbaseAdmin.disableTable(table.getTableName());
            table.setValue(this.metadataKey, this.metadataValue);
            hbaseAdmin.modifyTable(table.getTableName(), table);
            hbaseAdmin.enableTable(table.getTableName());
        }
    }

    public static void main(String[] args) throws Exception {
        HtableAlterMetadataCLI cli = new HtableAlterMetadataCLI();
        cli.execute(args);
    }

    protected Options getOptions() {
        Options options = new Options();
        options.addOption(OPTION_HTABLE_NAME);
        options.addOption(OPTION_METADATA_KEY);
        options.addOption(OPTION_METADATA_VALUE);
        return options;
    }

    protected void execute(OptionsHelper optionsHelper) throws Exception {
        this.tableName = optionsHelper.getOptionValue(OPTION_HTABLE_NAME);
        this.metadataKey = optionsHelper.getOptionValue(OPTION_METADATA_KEY);
        this.metadataValue = optionsHelper.getOptionValue(OPTION_METADATA_VALUE);
        this.alter();
    }

    static {
        OptionBuilder.withArgName((String)"key");
        OptionBuilder.hasArg();
        OptionBuilder.isRequired((boolean)true);
        OptionBuilder.withDescription((String)"The metadata key");
        OPTION_METADATA_KEY = OptionBuilder.create((String)"key");
        OptionBuilder.withArgName((String)"value");
        OptionBuilder.hasArg();
        OptionBuilder.isRequired((boolean)true);
        OptionBuilder.withDescription((String)"The metadata value");
        OPTION_METADATA_VALUE = OptionBuilder.create((String)"value");
        OptionBuilder.withArgName((String)"htablename");
        OptionBuilder.hasArg();
        OptionBuilder.isRequired((boolean)true);
        OptionBuilder.withDescription((String)"HTable name");
        OPTION_HTABLE_NAME = OptionBuilder.create((String)"htablename");
        logger = LoggerFactory.getLogger(HtableAlterMetadataCLI.class);
    }
}

