/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.storage.hbase.steps;

import org.apache.hadoop.hbase.CompatibilityFactory;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.mapreduce.HFileOutputFormat2;
import org.apache.hadoop.hbase.protobuf.generated.HFileProtos;
import org.apache.hadoop.hbase.regionserver.BloomType;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.util.ClassUtil;
import org.apache.kylin.common.util.StringUtil;
import org.apache.kylin.cube.CubeSegment;
import org.apache.kylin.engine.mr.common.AbstractHadoopJob;
import org.apache.kylin.engine.spark.SparkBatchCubingJobBuilder2;
import org.apache.kylin.engine.spark.SparkExecutable;
import org.apache.kylin.engine.spark.SparkExecutableFactory;
import org.apache.kylin.job.execution.AbstractExecutable;
import org.apache.kylin.storage.hbase.steps.HBaseJobSteps;
import org.apache.kylin.storage.hbase.steps.SparkCubeHFile;

public class HBaseSparkSteps
extends HBaseJobSteps {
    public HBaseSparkSteps(CubeSegment seg) {
        super(seg);
    }

    @Override
    public AbstractExecutable createConvertCuboidToHfileStep(String jobId) {
        String cuboidRootPath = this.getCuboidRootPath(jobId);
        String inputPath = cuboidRootPath + (cuboidRootPath.endsWith("/") ? "" : "/");
        SparkBatchCubingJobBuilder2 jobBuilder2 = new SparkBatchCubingJobBuilder2(this.seg, null);
        SparkExecutable sparkExecutable = SparkExecutableFactory.instance((KylinConfig)this.seg.getConfig());
        sparkExecutable.setClassName(SparkCubeHFile.class.getName());
        sparkExecutable.setParam(SparkCubeHFile.OPTION_CUBE_NAME.getOpt(), this.seg.getRealization().getName());
        sparkExecutable.setParam(SparkCubeHFile.OPTION_SEGMENT_ID.getOpt(), this.seg.getUuid());
        sparkExecutable.setParam(SparkCubeHFile.OPTION_INPUT_PATH.getOpt(), inputPath);
        sparkExecutable.setParam(SparkCubeHFile.OPTION_META_URL.getOpt(), jobBuilder2.getSegmentMetadataUrl(this.seg.getConfig(), jobId));
        sparkExecutable.setParam(SparkCubeHFile.OPTION_OUTPUT_PATH.getOpt(), this.getHFilePath(jobId));
        sparkExecutable.setParam(SparkCubeHFile.OPTION_PARTITION_FILE_PATH.getOpt(), this.getRowkeyDistributionOutputPath(jobId) + "/part-r-00000_hfile");
        sparkExecutable.setParam(AbstractHadoopJob.OPTION_HBASE_CONF_PATH.getOpt(), this.getHBaseConfFilePath(jobId));
        sparkExecutable.setJobId(jobId);
        StringBuilder jars = new StringBuilder();
        StringUtil.appendWithSeparator((StringBuilder)jars, (String)ClassUtil.findContainingJar(KeyValue.class));
        StringUtil.appendWithSeparator((StringBuilder)jars, (String)ClassUtil.findContainingJar(HFileOutputFormat2.class));
        StringUtil.appendWithSeparator((StringBuilder)jars, (String)ClassUtil.findContainingJar(BloomType.class));
        StringUtil.appendWithSeparator((StringBuilder)jars, (String)ClassUtil.findContainingJar(HFileProtos.class));
        StringUtil.appendWithSeparator((StringBuilder)jars, (String)ClassUtil.findContainingJar(CompatibilityFactory.class));
        StringUtil.appendWithSeparator((StringBuilder)jars, (String)ClassUtil.findContainingJar((String)"org.htrace.HTraceConfiguration", null));
        StringUtil.appendWithSeparator((StringBuilder)jars, (String)ClassUtil.findContainingJar((String)"org.apache.htrace.Trace", null));
        StringUtil.appendWithSeparator((StringBuilder)jars, (String)ClassUtil.findContainingJar((String)"com.yammer.metrics.core.MetricsRegistry", null));
        StringUtil.appendWithSeparator((StringBuilder)jars, (String)ClassUtil.findContainingJar((String)"org.apache.hadoop.hbase.regionserver.MetricsRegionServerSourceFactory", null));
        StringUtil.appendWithSeparator((StringBuilder)jars, (String)ClassUtil.findContainingJar((String)"org.apache.hadoop.hbase.regionserver.MetricsRegionServerSourceFactoryImpl", null));
        StringUtil.appendWithSeparator((StringBuilder)jars, (String)this.seg.getConfig().getSparkAdditionalJars());
        sparkExecutable.setJars(jars.toString());
        sparkExecutable.setName("Convert Cuboid Data to HFile");
        sparkExecutable.setCounterSaveAs(",,byteSizeBytes", this.getCounterOutputPath(jobId));
        return sparkExecutable;
    }
}

