/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.storage.hbase.common.coprocessor;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.kylin.common.util.Bytes;
import org.apache.kylin.shaded.com.google.common.collect.Lists;
import org.apache.kylin.storage.hbase.common.coprocessor.AggrKey;
import org.apache.kylin.storage.hbase.common.coprocessor.CoprocessorProjector;
import org.junit.Assert;
import org.junit.Test;

public class RowProjectorTest {
    byte[] mask = new byte[]{-1, 0, 0, -1};
    CoprocessorProjector sample = new CoprocessorProjector(this.mask, true);

    @Test
    public void testSerialize() {
        byte[] bytes = CoprocessorProjector.serialize((CoprocessorProjector)this.sample);
        CoprocessorProjector copy = CoprocessorProjector.deserialize((byte[])bytes);
        Assert.assertTrue((boolean)Arrays.equals(this.sample.groupByMask, copy.groupByMask));
    }

    @Test
    public void testProject() {
        AggrKey rowKey2;
        byte[] bytes1 = new byte[]{-1, -2, -3, -4};
        byte[] bytes2 = new byte[]{1, 2, 3, 4};
        byte[] bytes3 = new byte[]{1, 99, 100, 4};
        byte[] bytes4 = new byte[]{1, 1, 1, 5};
        AggrKey rowKey = this.sample.getAggrKey(this.newCellWithRowKey(bytes1));
        Assert.assertTrue((rowKey == (rowKey2 = this.sample.getAggrKey(this.newCellWithRowKey(bytes2))) ? 1 : 0) != 0);
        Assert.assertTrue((boolean)Bytes.equals((byte[])rowKey.get(), (int)rowKey.offset(), (int)rowKey.length(), (byte[])bytes2, (int)0, (int)bytes2.length));
        rowKey2 = rowKey.copy();
        Assert.assertTrue((rowKey != rowKey2 ? 1 : 0) != 0);
        rowKey = this.sample.getAggrKey(this.newCellWithRowKey(bytes1));
        Assert.assertTrue((rowKey.hashCode() != rowKey2.hashCode() ? 1 : 0) != 0);
        Assert.assertTrue((!rowKey.equals((Object)rowKey2) ? 1 : 0) != 0);
        Assert.assertTrue((rowKey.compareTo(rowKey2) > 0 ? 1 : 0) != 0);
        rowKey = this.sample.getAggrKey(this.newCellWithRowKey(bytes3));
        Assert.assertTrue((rowKey.hashCode() == rowKey2.hashCode() ? 1 : 0) != 0);
        Assert.assertTrue((rowKey.equals((Object)rowKey2) ? 1 : 0) != 0);
        Assert.assertTrue((rowKey.compareTo(rowKey2) == 0 ? 1 : 0) != 0);
        rowKey = this.sample.getAggrKey(this.newCellWithRowKey(bytes4));
        Assert.assertTrue((rowKey.hashCode() != rowKey2.hashCode() ? 1 : 0) != 0);
        Assert.assertTrue((!rowKey.equals((Object)rowKey2) ? 1 : 0) != 0);
        Assert.assertTrue((rowKey.compareTo(rowKey2) > 0 ? 1 : 0) != 0);
    }

    private List<Cell> newCellWithRowKey(byte[] rowkey) {
        ArrayList list = Lists.newArrayList();
        list.add(new KeyValue(rowkey, null, null, null));
        return list;
    }
}

