/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.source.adhocquery;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.kylin.shaded.com.google.common.base.Predicates;
import org.apache.kylin.shaded.com.google.common.collect.FluentIterable;
import org.apache.kylin.source.adhocquery.IPushDownConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HivePushDownConverter
implements IPushDownConverter {
    private static final Logger logger = LoggerFactory.getLogger(HivePushDownConverter.class);
    private static final Pattern EXTRACT_PATTERN = Pattern.compile("extract\\s*(\\()\\s*(.*?)\\s*from(\\s+)", 2);
    private static final Pattern FROM_PATTERN = Pattern.compile("\\s+from\\s+(\\()\\s*select\\s", 2);
    private static final Pattern ALIAS_PATTERN = Pattern.compile("\\s*([`'_a-z0-9A-Z]+)", 2);
    private static final Pattern CAST_PATTERN = Pattern.compile("CAST\\((.*?) (?i)AS\\s*(.*?)\\s*\\)", 2);
    private static final Pattern CONCAT_PATTERN = Pattern.compile("(['_a-z0-9A-Z]+)\\|\\|(['_a-z0-9A-Z]+)", 2);
    private static final Pattern TIMESTAMP_ADD_DIFF_PATTERN = Pattern.compile("timestamp(add|diff)\\s*\\(\\s*(.*?)\\s*,", 2);
    private static final Pattern SELECT_PATTERN = Pattern.compile("^select", 2);
    private static final Pattern LIMIT_PATTERN = Pattern.compile("(limit\\s+[0-9;]+)$", 2);
    private static final Set<String> sqlKeyWordsExceptAS = FluentIterable.from(calciteKeyWords).filter(Predicates.not(Predicates.equalTo("AS"))).toSet();

    public static String replaceString(String originString, String fromString, String toString) {
        return originString.replace(fromString, toString);
    }

    public static String extractReplace(String originString) {
        Matcher extractMatcher = EXTRACT_PATTERN.matcher(originString);
        String replacedString = originString;
        Map<Integer, Integer> parenthesesPairs = null;
        while (extractMatcher.find()) {
            if (parenthesesPairs == null) {
                parenthesesPairs = HivePushDownConverter.findParenthesesPairs(originString);
            }
            String functionStr = extractMatcher.group(2);
            int startIdx = extractMatcher.end(3);
            int endIdx = parenthesesPairs.get(extractMatcher.start(1));
            String extractInner = originString.substring(startIdx, endIdx);
            int originStart = extractMatcher.start(0);
            int originEnd = endIdx + 1;
            replacedString = HivePushDownConverter.replaceString(replacedString, originString.substring(originStart, originEnd), functionStr + "(" + extractInner + ")");
        }
        return replacedString;
    }

    public static String castReplace(String originString) {
        Matcher castMatcher = CAST_PATTERN.matcher(originString);
        String replacedString = originString;
        while (castMatcher.find()) {
            String castStr = castMatcher.group();
            String type = castMatcher.group(2);
            String supportedType = "";
            switch (type.toUpperCase(Locale.ROOT)) {
                case "INTEGER": {
                    supportedType = "int";
                    break;
                }
                case "SHORT": {
                    supportedType = "smallint";
                    break;
                }
                case "LONG": {
                    supportedType = "bigint";
                    break;
                }
                default: {
                    supportedType = type;
                }
            }
            if (supportedType.equals(type)) continue;
            String replacedCastStr = castStr.replace(type, supportedType);
            replacedString = HivePushDownConverter.replaceString(replacedString, castStr, replacedCastStr);
        }
        return replacedString;
    }

    public static String subqueryReplace(String originString) {
        Matcher subqueryMatcher = FROM_PATTERN.matcher(originString);
        String replacedString = originString;
        Map<Integer, Integer> parenthesesPairs = null;
        while (subqueryMatcher.find()) {
            String aliasCandidate;
            int startIdx;
            int endIdx;
            Matcher aliasMatcher;
            if (parenthesesPairs == null) {
                parenthesesPairs = HivePushDownConverter.findParenthesesPairs(originString);
            }
            if (!(aliasMatcher = ALIAS_PATTERN.matcher(originString.substring(endIdx = parenthesesPairs.get(startIdx = subqueryMatcher.start(1)) + 1))).find() || (aliasCandidate = aliasMatcher.group(1)) != null && !sqlKeyWordsExceptAS.contains(aliasCandidate.toUpperCase(Locale.ROOT))) continue;
            replacedString = HivePushDownConverter.replaceString(replacedString, originString.substring(startIdx, endIdx), originString.substring(startIdx, endIdx) + " as alias");
        }
        return replacedString;
    }

    public static String timestampAddDiffReplace(String originString) {
        Matcher timestampaddMatcher = TIMESTAMP_ADD_DIFF_PATTERN.matcher(originString);
        String replacedString = originString;
        while (timestampaddMatcher.find()) {
            String interval = timestampaddMatcher.group(2);
            String timestampaddStr = HivePushDownConverter.replaceString(timestampaddMatcher.group(), interval, "'" + interval + "'");
            replacedString = HivePushDownConverter.replaceString(replacedString, timestampaddMatcher.group(), timestampaddStr);
        }
        return replacedString;
    }

    public static String concatReplace(String originString) {
        Matcher concatMatcher = CONCAT_PATTERN.matcher(originString);
        String replacedString = originString;
        while (concatMatcher.find()) {
            String leftString = concatMatcher.group(1);
            String rightString = concatMatcher.group(2);
            replacedString = HivePushDownConverter.replaceString(replacedString, leftString + "||" + rightString, "concat(" + leftString + "," + rightString + ")");
        }
        return replacedString;
    }

    public static String addLimit(String originString) {
        Matcher selectMatcher = SELECT_PATTERN.matcher(originString);
        Matcher limitMatcher = LIMIT_PATTERN.matcher(originString);
        String replacedString = originString;
        if (selectMatcher.find() && !limitMatcher.find()) {
            if (originString.endsWith(";")) {
                replacedString = originString.replaceAll(";+$", "");
            }
            replacedString = replacedString.concat(" limit 1");
        }
        return replacedString;
    }

    public static String doConvert(String originStr, boolean isPrepare) {
        String convertedSql = HivePushDownConverter.replaceString(originStr, "\"", "`");
        convertedSql = HivePushDownConverter.extractReplace(convertedSql);
        convertedSql = HivePushDownConverter.castReplace(convertedSql);
        convertedSql = HivePushDownConverter.subqueryReplace(convertedSql);
        convertedSql = HivePushDownConverter.replaceString(convertedSql, "CHAR_LENGTH", "LENGTH");
        convertedSql = HivePushDownConverter.replaceString(convertedSql, "char_length", "length");
        convertedSql = HivePushDownConverter.concatReplace(convertedSql);
        convertedSql = HivePushDownConverter.timestampAddDiffReplace(convertedSql);
        convertedSql = HivePushDownConverter.replaceString(convertedSql, "INTEGER", "INT");
        convertedSql = HivePushDownConverter.replaceString(convertedSql, "integer", "int");
        if (isPrepare) {
            convertedSql = HivePushDownConverter.addLimit(convertedSql);
        }
        return convertedSql;
    }

    private static Map<Integer, Integer> findParenthesesPairs(String sql) {
        HashMap<Integer, Integer> result = new HashMap<Integer, Integer>();
        if (sql.length() > 1) {
            Stack<Integer> lStack = new Stack<Integer>();
            boolean inStrVal = false;
            block4: for (int i = 0; i < sql.length(); ++i) {
                switch (sql.charAt(i)) {
                    case '(': {
                        if (inStrVal) continue block4;
                        lStack.push(i);
                        continue block4;
                    }
                    case ')': {
                        if (inStrVal || lStack.empty()) continue block4;
                        result.put((Integer)lStack.pop(), i);
                        continue block4;
                    }
                }
            }
        }
        return result;
    }

    @Override
    public String convert(String originSql, String project, String defaultSchema, boolean isPrepare) {
        return HivePushDownConverter.doConvert(originSql, isPrepare);
    }
}

