/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.metadata.realization;

import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.util.ClassUtil;
import org.apache.kylin.metadata.realization.IRealization;
import org.apache.kylin.metadata.realization.IRealizationProvider;
import org.apache.kylin.metadata.realization.RealizationType;
import org.apache.kylin.shaded.com.google.common.collect.Maps;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RealizationRegistry {
    private static final Logger logger = LoggerFactory.getLogger(RealizationRegistry.class);
    private Map<RealizationType, IRealizationProvider> providers;
    private KylinConfig config;

    public static RealizationRegistry getInstance(KylinConfig config) {
        return config.getManager(RealizationRegistry.class);
    }

    static RealizationRegistry newInstance(KylinConfig config) throws IOException {
        return new RealizationRegistry(config);
    }

    private RealizationRegistry(KylinConfig config) throws IOException {
        logger.info("Initializing RealizationRegistry with metadata url " + config);
        this.config = config;
        this.init();
    }

    private void init() {
        String[] providerNames;
        this.providers = Maps.newConcurrentMap();
        for (String clsName : providerNames = this.config.getRealizationProviders()) {
            try {
                Class<IRealizationProvider> cls = ClassUtil.forName(clsName, IRealizationProvider.class);
                IRealizationProvider p = (IRealizationProvider)cls.getMethod("getInstance", KylinConfig.class).invoke(null, this.config);
                this.providers.put(p.getRealizationType(), p);
            }
            catch (Exception | NoClassDefFoundError e) {
                if (e instanceof ClassNotFoundException || e instanceof NoClassDefFoundError) {
                    logger.warn("Failed to create realization provider " + e);
                    continue;
                }
                logger.error("Failed to create realization provider", e);
            }
        }
        if (this.providers.isEmpty()) {
            throw new IllegalArgumentException("Failed to find realization provider by url: " + this.config.getMetadataUrl());
        }
        logger.info("RealizationRegistry is " + this.providers);
    }

    public Set<RealizationType> getRealizationTypes() {
        return Collections.unmodifiableSet(this.providers.keySet());
    }

    public IRealization getRealization(RealizationType type, String name) {
        IRealizationProvider p = this.providers.get((Object)type);
        if (p == null) {
            logger.warn("No provider for realization type " + (Object)((Object)type));
            return null;
        }
        try {
            return p.getRealization(name);
        }
        catch (Exception ex) {
            logger.warn("Failed to load realization " + (Object)((Object)type) + ":" + name, (Throwable)ex);
            return null;
        }
    }
}

