/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.metadata.model;

import java.util.Set;
import org.apache.kylin.metadata.datatype.DataType;
import org.apache.kylin.metadata.expression.TupleExpression;
import org.apache.kylin.metadata.model.ExpressionDynamicFunctionDesc;
import org.apache.kylin.metadata.model.FunctionDesc;
import org.apache.kylin.metadata.model.ParameterDesc;
import org.apache.kylin.metadata.model.TblColRef;
import org.apache.kylin.shaded.com.google.common.collect.Sets;

public class SumExpressionDynamicFunctionDesc
extends ExpressionDynamicFunctionDesc {
    public static final TblColRef mockCntCol = TblColRef.newInnerColumn("COUNT", TblColRef.InnerDataTypeEnum.DERIVED);
    private Set<TblColRef> measureColumnSet;

    public SumExpressionDynamicFunctionDesc(ParameterDesc parameter, TupleExpression tupleExpression) {
        super(parameter, "SUM", null, tupleExpression);
    }

    @Override
    public String getRewriteFieldName() {
        return "_KY_SUM_" + this.tupleExpression.toString();
    }

    @Override
    public DataType getRewriteFieldType() {
        return this.getReturnDataType();
    }

    @Override
    public Set<TblColRef> getRuntimeMeasures() {
        if (this.measureColumnSet == null) {
            this.measureColumnSet = Sets.newHashSet(super.getRuntimeMeasures());
            this.measureColumnSet.remove(mockCntCol);
        }
        return this.measureColumnSet;
    }

    @Override
    protected FunctionDesc constructRuntimeFunction(TblColRef column) {
        return column == mockCntCol ? FunctionDesc.newInstance("COUNT", null, null) : FunctionDesc.newInstance("SUM", ParameterDesc.newInstance(column), null);
    }

    @Override
    protected void resetReturnType() {
        DataType returnType = this.tupleExpression.getDataType();
        for (FunctionDesc funcDesc : this.runtimeFuncMap.values()) {
            returnType = TupleExpression.referDataType(returnType, funcDesc.getReturnDataType());
        }
        this.setReturnDataType(returnType);
    }
}

