/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.metadata.expression;

import java.nio.ByteBuffer;
import java.util.Collections;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.util.BytesUtil;
import org.apache.kylin.metadata.datatype.DataType;
import org.apache.kylin.metadata.expression.ExpressionVisitor;
import org.apache.kylin.metadata.expression.TupleExpression;
import org.apache.kylin.metadata.filter.IFilterCodeSystem;
import org.apache.kylin.metadata.model.ColumnDesc;
import org.apache.kylin.metadata.model.DataModelDesc;
import org.apache.kylin.metadata.model.DataModelManager;
import org.apache.kylin.metadata.model.SumExpressionDynamicFunctionDesc;
import org.apache.kylin.metadata.model.TableDesc;
import org.apache.kylin.metadata.model.TableRef;
import org.apache.kylin.metadata.model.TblColRef;
import org.apache.kylin.metadata.tuple.IEvaluatableTuple;

public class ColumnTupleExpression
extends TupleExpression {
    private static final String _QUALIFIED_ = "_QUALIFIED_";
    private TblColRef columnRef;

    public static ColumnTupleExpression getCntColumnTupleExpression() {
        return new ColumnTupleExpression(DataType.getType("bigint"), SumExpressionDynamicFunctionDesc.mockCntCol);
    }

    public ColumnTupleExpression(TblColRef column) {
        this(column.getType(), column);
    }

    public ColumnTupleExpression(DataType dataType, TblColRef column) {
        super(dataType, TupleExpression.ExpressionOperatorEnum.COLUMN, Collections.emptyList());
        this.columnRef = column;
    }

    @Override
    public void verify() {
    }

    @Override
    public Object calculate(IEvaluatableTuple tuple, IFilterCodeSystem<?> cs) {
        return tuple.getValue(this.columnRef);
    }

    @Override
    public TupleExpression accept(ExpressionVisitor visitor) {
        return visitor.visitColumn(this);
    }

    @Override
    public void serialize(IFilterCodeSystem<?> cs, ByteBuffer buffer) {
        TableRef tableRef = this.columnRef.getTableRef();
        if (tableRef == null) {
            String table = this.columnRef.getTable();
            BytesUtil.writeUTFString(table, buffer);
            String columnId = this.columnRef.getColumnDesc().getId();
            BytesUtil.writeUTFString(columnId, buffer);
            String columnName = this.columnRef.getName();
            BytesUtil.writeUTFString(columnName, buffer);
            String dataType = this.columnRef.getDatatype();
            BytesUtil.writeUTFString(dataType, buffer);
        } else {
            BytesUtil.writeUTFString(_QUALIFIED_, buffer);
            String model = tableRef.getModel().getName();
            BytesUtil.writeUTFString(model, buffer);
            String alias = tableRef.getAlias();
            BytesUtil.writeUTFString(alias, buffer);
            String col = this.columnRef.getName();
            BytesUtil.writeUTFString(col, buffer);
        }
    }

    @Override
    public void deserialize(IFilterCodeSystem<?> cs, ByteBuffer buffer) {
        String tableName = BytesUtil.readUTFString(buffer);
        if (_QUALIFIED_.equals(tableName)) {
            String model = BytesUtil.readUTFString(buffer);
            String alias = BytesUtil.readUTFString(buffer);
            String col = BytesUtil.readUTFString(buffer);
            KylinConfig config = KylinConfig.getInstanceFromEnv();
            DataModelDesc modelDesc = DataModelManager.getInstance(config).getDataModelDesc(model);
            this.columnRef = modelDesc.findColumn(alias, col);
        } else {
            TableDesc tableDesc = null;
            if (tableName != null) {
                tableDesc = new TableDesc();
                tableDesc.setName(tableName);
            }
            ColumnDesc column = new ColumnDesc();
            column.setId(BytesUtil.readUTFString(buffer));
            column.setName(BytesUtil.readUTFString(buffer));
            column.setDatatype(BytesUtil.readUTFString(buffer));
            column.init(tableDesc);
            this.columnRef = column.getRef();
        }
    }

    public TblColRef getColumn() {
        return this.columnRef;
    }

    public String toString() {
        return this.columnRef.getCanonicalName();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ColumnTupleExpression that = (ColumnTupleExpression)o;
        return this.columnRef != null ? this.columnRef.equals(that.columnRef) : that.columnRef == null;
    }

    public int hashCode() {
        return this.columnRef != null ? this.columnRef.hashCode() : 0;
    }
}

