/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.measure.map.bitmap;

import java.io.IOException;
import java.io.Serializable;
import java.nio.ByteBuffer;
import org.apache.kylin.measure.map.MapKeySerializer;
import org.apache.kylin.measure.map.bitmap.BitmapCounterMap;
import org.apache.kylin.measure.map.bitmap.BitmapCounterMapFactory;
import org.apache.kylin.measure.map.bitmap.RoaringBitmapCounterMap;
import org.apache.kylin.measure.map.bitmap.SegmentStartTimeKeySerializer;

public class RoaringBitmapCounterMapFactory
implements BitmapCounterMapFactory,
Serializable {
    public static final RoaringBitmapCounterMapFactory INSTANCE = new RoaringBitmapCounterMapFactory();
    private final MapKeySerializer keySerializer = new SegmentStartTimeKeySerializer();

    private RoaringBitmapCounterMapFactory() {
    }

    @Override
    public MapKeySerializer getMapKeySerializer() {
        return this.keySerializer;
    }

    @Override
    public BitmapCounterMap newBitmapMap() {
        return new RoaringBitmapCounterMap(this.keySerializer);
    }

    @Override
    public BitmapCounterMap newBitmapMap(ByteBuffer in) throws IOException {
        RoaringBitmapCounterMap counter = new RoaringBitmapCounterMap(this.keySerializer);
        counter.readFields(in);
        return counter;
    }
}

