/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.dimension;

import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentMap;
import javax.annotation.Nullable;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.util.ClassUtil;
import org.apache.kylin.common.util.Pair;
import org.apache.kylin.dimension.BooleanDimEnc;
import org.apache.kylin.dimension.DateDimEnc;
import org.apache.kylin.dimension.DimensionEncoding;
import org.apache.kylin.dimension.FixedLenDimEnc;
import org.apache.kylin.dimension.FixedLenHexDimEnc;
import org.apache.kylin.dimension.IntDimEnc;
import org.apache.kylin.dimension.IntegerDimEnc;
import org.apache.kylin.dimension.TimeDimEnc;
import org.apache.kylin.shaded.com.google.common.base.Predicate;
import org.apache.kylin.shaded.com.google.common.collect.Iterables;
import org.apache.kylin.shaded.com.google.common.collect.Maps;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DimensionEncodingFactory {
    private static final Logger logger = LoggerFactory.getLogger(DimensionEncodingFactory.class);
    private static Map<Pair<String, Integer>, DimensionEncodingFactory> factoryMap;

    protected int getCurrentVersion() {
        return 1;
    }

    public static DimensionEncoding create(String encodingName, String[] args, int version) {
        DimensionEncodingFactory factory;
        if (factoryMap == null) {
            DimensionEncodingFactory.initFactoryMap();
        }
        if ((factory = factoryMap.get(Pair.newPair(encodingName, version))) == null) {
            throw new IllegalArgumentException("Unknown dimension encoding name " + encodingName + " (note '" + "dict" + "' is not handled by factory)");
        }
        return factory.createDimensionEncoding(encodingName, args);
    }

    public static Map<String, Integer> getValidEncodings() {
        if (factoryMap == null) {
            DimensionEncodingFactory.initFactoryMap();
        }
        TreeMap<String, Integer> result = Maps.newTreeMap();
        for (Pair<String, Integer> p : factoryMap.keySet()) {
            if (result.containsKey(p.getFirst()) && (Integer)result.get(p.getFirst()) > p.getSecond()) continue;
            result.put(p.getFirst(), p.getSecond());
        }
        result.put("dict", 1);
        return result;
    }

    public static boolean isValidEncoding(final String encodingName) {
        if (factoryMap == null) {
            DimensionEncodingFactory.initFactoryMap();
        }
        return "dict".equals(encodingName) || Iterables.any(factoryMap.keySet(), new Predicate<Pair<String, Integer>>(){

            @Override
            public boolean apply(@Nullable Pair<String, Integer> input) {
                return input.getFirst().equals(encodingName);
            }
        });
    }

    public static boolean isValidEncoding(String encodingName, String[] args, int version) {
        DimensionEncodingFactory factory;
        if (factoryMap == null) {
            DimensionEncodingFactory.initFactoryMap();
        }
        if ((factory = factoryMap.get(Pair.newPair(encodingName, version))) == null) {
            return true;
        }
        return factory.isValidDimensionEncoding(encodingName, args);
    }

    private static synchronized void initFactoryMap() {
        if (factoryMap == null) {
            String[] clsNames;
            ConcurrentMap<Pair<String, Integer>, DimensionEncodingFactory> map = Maps.newConcurrentMap();
            DimensionEncodingFactory value = new FixedLenDimEnc.Factory();
            map.put(Pair.newPair("fixed_length", value.getCurrentVersion()), value);
            value = new IntDimEnc.Factory();
            map.put(Pair.newPair("int", value.getCurrentVersion()), value);
            value = new IntegerDimEnc.Factory();
            map.put(Pair.newPair("integer", value.getCurrentVersion()), value);
            value = new FixedLenHexDimEnc.Factory();
            map.put(Pair.newPair("fixed_length_hex", value.getCurrentVersion()), value);
            value = new DateDimEnc.Factory();
            map.put(Pair.newPair("date", value.getCurrentVersion()), value);
            value = new TimeDimEnc.Factory();
            map.put(Pair.newPair("time", value.getCurrentVersion()), value);
            value = new BooleanDimEnc.Factory();
            map.put(Pair.newPair("boolean", value.getCurrentVersion()), value);
            for (String clsName : clsNames = KylinConfig.getInstanceFromEnv().getCubeDimensionCustomEncodingFactories()) {
                try {
                    DimensionEncodingFactory factory = (DimensionEncodingFactory)ClassUtil.newInstance(clsName);
                    map.put(Pair.newPair(factory.getSupportedEncodingName(), factory.getCurrentVersion()), factory);
                }
                catch (Exception ex) {
                    logger.error("Failed to init dimension encoding factory " + clsName, (Throwable)ex);
                }
            }
            factoryMap = map;
        }
    }

    public abstract String getSupportedEncodingName();

    public abstract DimensionEncoding createDimensionEncoding(String var1, String[] var2);

    public abstract boolean isValidDimensionEncoding(String var1, String[] var2);
}

