/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.cube.model;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import org.apache.kylin.cube.cuboid.Cuboid;
import org.apache.kylin.cube.cuboid.CuboidScheduler;
import org.apache.kylin.cube.model.CubeDesc;
import org.apache.kylin.cube.model.RowKeyDesc;
import org.apache.kylin.cube.model.SelectRule;
import org.apache.kylin.metadata.model.TblColRef;
import org.apache.kylin.shaded.com.google.common.base.Function;
import org.apache.kylin.shaded.com.google.common.base.Preconditions;
import org.apache.kylin.shaded.com.google.common.collect.Collections2;
import org.apache.kylin.shaded.com.google.common.collect.Lists;
import org.apache.kylin.shaded.com.google.common.collect.Maps;
import org.apache.kylin.shaded.com.google.common.math.LongMath;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE, getterVisibility=JsonAutoDetect.Visibility.NONE, isGetterVisibility=JsonAutoDetect.Visibility.NONE, setterVisibility=JsonAutoDetect.Visibility.NONE)
public class AggregationGroup
implements Serializable {
    @JsonProperty(value="includes")
    private String[] includes;
    @JsonProperty(value="select_rule")
    private SelectRule selectRule;
    private long partialCubeFullMask;
    private long mandatoryColumnMask;
    private List<HierarchyMask> hierarchyMasks;
    private List<Long> joints;
    private long jointDimsMask;
    private long normalDimsMask;
    private long hierarchyDimsMask;
    private List<Long> normalDims;
    private CubeDesc cubeDesc;
    private boolean isMandatoryOnlyValid;
    private HashMap<Long, Long> dim2JointMap;

    public void init(CubeDesc cubeDesc, RowKeyDesc rowKeyDesc) {
        this.cubeDesc = cubeDesc;
        this.isMandatoryOnlyValid = cubeDesc.getConfig().getCubeAggrGroupIsMandatoryOnlyValid();
        if (this.includes == null || this.includes.length == 0 || this.selectRule == null) {
            throw new IllegalStateException("AggregationGroup incomplete");
        }
        this.normalizeColumnNames();
        this.buildPartialCubeFullMask(rowKeyDesc);
        this.buildMandatoryColumnMask(rowKeyDesc);
        this.buildJointColumnMask(rowKeyDesc);
        this.buildJointDimsMask();
        this.buildHierarchyMasks(rowKeyDesc);
        this.buildHierarchyDimsMask();
        this.buildNormalDimsMask();
    }

    private void normalizeColumnNames() {
        Preconditions.checkNotNull(this.includes);
        this.normalizeColumnNames(this.includes);
        Preconditions.checkNotNull(this.selectRule.mandatoryDims);
        this.normalizeColumnNames(this.selectRule.mandatoryDims);
        if (this.selectRule.hierarchyDims == null) {
            this.selectRule.hierarchyDims = new String[0][];
        }
        for (String[] cols : this.selectRule.hierarchyDims) {
            Preconditions.checkNotNull(cols);
            this.normalizeColumnNames(cols);
        }
        if (this.selectRule.jointDims == null) {
            this.selectRule.jointDims = new String[0][];
        }
        for (String[] cols : this.selectRule.jointDims) {
            Preconditions.checkNotNull(cols);
            this.normalizeColumnNames(cols);
        }
    }

    private void normalizeColumnNames(String[] names) {
        if (names == null) {
            return;
        }
        for (int i = 0; i < names.length; ++i) {
            TblColRef col = this.cubeDesc.getModel().findColumn(names[i]);
            names[i] = col.getIdentity();
        }
        HashSet<String> set = new HashSet<String>(Arrays.asList(names));
        if (set.size() < names.length) {
            throw new IllegalStateException("Columns in aggrgroup must not contain duplication: " + Arrays.asList(names));
        }
    }

    private void buildPartialCubeFullMask(RowKeyDesc rowKeyDesc) {
        Preconditions.checkState(this.includes != null);
        Preconditions.checkState(this.includes.length != 0);
        this.partialCubeFullMask = 0L;
        for (String dim : this.includes) {
            TblColRef hColumn = this.cubeDesc.getModel().findColumn(dim);
            Integer index = rowKeyDesc.getColumnBitIndex(hColumn);
            long bit = 1L << index;
            this.partialCubeFullMask |= bit;
        }
    }

    private void buildJointColumnMask(RowKeyDesc rowKeyDesc) {
        this.joints = Lists.newArrayList();
        this.dim2JointMap = Maps.newHashMap();
        if (this.selectRule.jointDims == null || this.selectRule.jointDims.length == 0) {
            return;
        }
        for (String[] jointDims : this.selectRule.jointDims) {
            if (jointDims == null || jointDims.length == 0) continue;
            long joint = 0L;
            for (int i = 0; i < jointDims.length; ++i) {
                TblColRef hColumn = this.cubeDesc.getModel().findColumn(jointDims[i]);
                Integer index = rowKeyDesc.getColumnBitIndex(hColumn);
                long bit = 1L << index;
                joint |= bit;
            }
            Preconditions.checkState(joint != 0L);
            this.joints.add(joint);
        }
        Iterator<Long> iterator = this.joints.iterator();
        while (iterator.hasNext()) {
            long jt = (Long)iterator.next();
            for (int i = 0; i < 64; ++i) {
                if ((1L << i & jt) == 0L) continue;
                this.dim2JointMap.put(1L << i, jt);
            }
        }
    }

    private void buildMandatoryColumnMask(RowKeyDesc rowKeyDesc) {
        this.mandatoryColumnMask = 0L;
        String[] mandatory_dims = this.selectRule.mandatoryDims;
        if (mandatory_dims == null || mandatory_dims.length == 0) {
            return;
        }
        for (String dim : mandatory_dims) {
            TblColRef hColumn = this.cubeDesc.getModel().findColumn(dim);
            Integer index = rowKeyDesc.getColumnBitIndex(hColumn);
            this.mandatoryColumnMask |= 1L << index;
        }
    }

    private void buildHierarchyMasks(RowKeyDesc rowKeyDesc) {
        this.hierarchyMasks = new ArrayList<HierarchyMask>();
        if (this.selectRule.hierarchyDims == null || this.selectRule.hierarchyDims.length == 0) {
            return;
        }
        for (String[] hierarchy_dims : this.selectRule.hierarchyDims) {
            int i;
            HierarchyMask mask = new HierarchyMask();
            if (hierarchy_dims == null || hierarchy_dims.length == 0) continue;
            ArrayList<Long> allMaskList = new ArrayList<Long>();
            ArrayList<Long> dimList = new ArrayList<Long>();
            for (i = 0; i < hierarchy_dims.length; ++i) {
                TblColRef hColumn = this.cubeDesc.getModel().findColumn(hierarchy_dims[i]);
                Integer index = rowKeyDesc.getColumnBitIndex(hColumn);
                long bit = 1L << index;
                if (this.dim2JointMap.get(bit) != null) {
                    bit = this.dim2JointMap.get(bit);
                }
                mask.fullMask |= bit;
                allMaskList.add(mask.fullMask);
                dimList.add(bit);
            }
            Preconditions.checkState(allMaskList.size() == dimList.size());
            mask.allMasks = new long[allMaskList.size()];
            mask.dims = new long[dimList.size()];
            for (i = 0; i < allMaskList.size(); ++i) {
                mask.allMasks[i] = (Long)allMaskList.get(i);
                mask.dims[i] = (Long)dimList.get(i);
            }
            this.hierarchyMasks.add(mask);
        }
    }

    private void buildNormalDimsMask() {
        long leftover = this.partialCubeFullMask & (this.mandatoryColumnMask ^ 0xFFFFFFFFFFFFFFFFL);
        leftover &= this.jointDimsMask ^ 0xFFFFFFFFFFFFFFFFL;
        for (HierarchyMask hierarchyMask : this.hierarchyMasks) {
            leftover &= hierarchyMask.fullMask ^ 0xFFFFFFFFFFFFFFFFL;
        }
        this.normalDimsMask = leftover;
        this.normalDims = this.bits(leftover);
    }

    private void buildHierarchyDimsMask() {
        long ret = 0L;
        for (HierarchyMask mask : this.hierarchyMasks) {
            ret |= mask.fullMask;
        }
        this.hierarchyDimsMask = ret;
    }

    private List<Long> bits(long x) {
        long bit;
        ArrayList<Long> r = Lists.newArrayList();
        for (long l = x; l != 0L; l ^= bit) {
            bit = Long.lowestOneBit(l);
            r.add(bit);
        }
        return r;
    }

    public void buildJointDimsMask() {
        long ret = 0L;
        for (long x : this.joints) {
            ret |= x;
        }
        this.jointDimsMask = ret;
    }

    public long getMandatoryColumnMask() {
        return this.mandatoryColumnMask;
    }

    public List<HierarchyMask> getHierarchyMasks() {
        return this.hierarchyMasks;
    }

    public int getBuildLevel() {
        int ret = 1;
        if (this.getPartialCubeFullMask() == Cuboid.getBaseCuboidId(this.cubeDesc)) {
            --ret;
        }
        ret += this.getNormalDims().size();
        for (HierarchyMask hierarchyMask : this.hierarchyMasks) {
            ret += hierarchyMask.allMasks.length;
        }
        for (Long joint : this.joints) {
            if ((joint & this.getHierarchyDimsMask()) != 0L) continue;
            ++ret;
        }
        return ret;
    }

    public long calculateCuboidCombination() {
        long combination = 1L;
        try {
            if (this.getDimCap() > 0) {
                CuboidScheduler cuboidScheduler = this.cubeDesc.getInitialCuboidScheduler();
                combination = cuboidScheduler.calculateCuboidsForAggGroup(this).size();
            } else {
                TreeSet<String> includeDims = new TreeSet<String>(Arrays.asList(this.includes));
                TreeSet<String> mandatoryDims = new TreeSet<String>(Arrays.asList(this.selectRule.mandatoryDims));
                TreeSet<String> hierarchyDims = new TreeSet<String>();
                for (String[] ss : this.selectRule.hierarchyDims) {
                    hierarchyDims.addAll(Arrays.asList(ss));
                    combination = LongMath.checkedMultiply(combination, ss.length + 1);
                }
                TreeSet<String> jointDims = new TreeSet<String>();
                for (String[] ss : this.selectRule.jointDims) {
                    jointDims.addAll(Arrays.asList(ss));
                }
                combination = LongMath.checkedMultiply(combination, 1L << this.selectRule.jointDims.length);
                TreeSet<String> normalDims = new TreeSet<String>();
                normalDims.addAll(includeDims);
                normalDims.removeAll(mandatoryDims);
                normalDims.removeAll(hierarchyDims);
                normalDims.removeAll(jointDims);
                combination = LongMath.checkedMultiply(combination, 1L << normalDims.size());
                if (this.cubeDesc.getConfig().getCubeAggrGroupIsMandatoryOnlyValid() && !mandatoryDims.isEmpty()) {
                    ++combination;
                }
                --combination;
            }
            if (combination < 0L) {
                throw new ArithmeticException();
            }
        }
        catch (ArithmeticException ae) {
            combination = Long.MAX_VALUE;
        }
        if (combination < 0L) {
            combination = 0x7FFFFFFFFFFFFFFEL;
        }
        return combination;
    }

    public Long translateToOnTreeCuboid(long cuboidID) {
        if ((cuboidID & (this.getPartialCubeFullMask() ^ 0xFFFFFFFFFFFFFFFFL)) > 0L) {
            return null;
        }
        cuboidID |= this.getMandatoryColumnMask();
        for (HierarchyMask hierarchyMask : this.getHierarchyMasks()) {
            long fullMask = hierarchyMask.fullMask;
            long intersect = cuboidID & fullMask;
            if (intersect == 0L || intersect == fullMask) continue;
            boolean startToFill = false;
            for (int i = hierarchyMask.dims.length - 1; i >= 0; --i) {
                if (startToFill) {
                    cuboidID |= hierarchyMask.dims[i];
                    continue;
                }
                if ((cuboidID & hierarchyMask.dims[i]) == 0L) continue;
                startToFill = true;
                cuboidID |= hierarchyMask.dims[i];
            }
        }
        for (Long joint : this.getJoints()) {
            if ((cuboidID | joint) == cuboidID || (cuboidID & (joint ^ 0xFFFFFFFFFFFFFFFFL)) == cuboidID) continue;
            cuboidID |= joint.longValue();
        }
        if (!this.isOnTree(cuboidID)) {
            long nonJointDims = this.removeBits(this.getPartialCubeFullMask() ^ this.getMandatoryColumnMask(), this.getJoints());
            if (nonJointDims != 0L) {
                long nonJointNonHierarchy = this.removeBits(nonJointDims, Collections2.transform(this.getHierarchyMasks(), new Function<HierarchyMask, Long>(){

                    @Override
                    public Long apply(HierarchyMask input) {
                        return input.fullMask;
                    }
                }));
                if (nonJointNonHierarchy != 0L) {
                    return cuboidID | Long.lowestOneBit(nonJointNonHierarchy);
                }
                long allJointDims = this.getJointDimsMask();
                for (HierarchyMask hierarchyMask : this.getHierarchyMasks()) {
                    long dim = hierarchyMask.allMasks[0];
                    if ((dim & allJointDims) != 0L) continue;
                    return cuboidID | dim;
                }
            }
            if (this.getJoints().size() > 0) {
                cuboidID |= Collections.min(this.getJoints(), Cuboid.cuboidSelectComparator).longValue();
            }
            if (!this.isOnTree(cuboidID)) {
                return null;
            }
        }
        return cuboidID;
    }

    private long removeBits(long original, Collection<Long> toRemove) {
        long ret = original;
        for (Long joint : toRemove) {
            ret &= joint ^ 0xFFFFFFFFFFFFFFFFL;
        }
        return ret;
    }

    public boolean isOnTree(long cuboidID) {
        if (cuboidID <= 0L) {
            return false;
        }
        if ((cuboidID & (this.partialCubeFullMask ^ 0xFFFFFFFFFFFFFFFFL)) != 0L) {
            return false;
        }
        return this.checkMandatoryColumns(cuboidID) && this.checkHierarchy(cuboidID) && this.checkJoint(cuboidID);
    }

    private boolean checkMandatoryColumns(long cuboidID) {
        if ((cuboidID & this.mandatoryColumnMask) != this.mandatoryColumnMask) {
            return false;
        }
        if (cuboidID == Cuboid.getBaseCuboidId(this.cubeDesc)) {
            return true;
        }
        return this.isMandatoryOnlyValid || (cuboidID & (this.mandatoryColumnMask ^ 0xFFFFFFFFFFFFFFFFL)) != 0L;
    }

    private boolean checkJoint(long cuboidID) {
        for (long joint : this.joints) {
            long common = cuboidID & joint;
            if (common == 0L || common == joint) continue;
            return false;
        }
        return true;
    }

    private boolean checkHierarchy(long cuboidID) {
        if (this.hierarchyMasks == null || this.hierarchyMasks.size() == 0) {
            return true;
        }
        for (HierarchyMask hierarchy : this.hierarchyMasks) {
            long result = cuboidID & hierarchy.fullMask;
            if (result <= 0L) continue;
            boolean meetHierarcy = false;
            for (long mask : hierarchy.allMasks) {
                if (result != mask) continue;
                meetHierarcy = true;
                break;
            }
            if (meetHierarcy) continue;
            return false;
        }
        return true;
    }

    public void setIncludes(String[] includes) {
        this.includes = includes;
    }

    public void setSelectRule(SelectRule selectRule) {
        this.selectRule = selectRule;
    }

    public List<Long> getJoints() {
        return this.joints;
    }

    public long getJointDimsMask() {
        return this.jointDimsMask;
    }

    public long getNormalDimsMask() {
        return this.normalDimsMask;
    }

    public long getHierarchyDimsMask() {
        return this.hierarchyDimsMask;
    }

    public List<Long> getNormalDims() {
        return this.normalDims;
    }

    public long getPartialCubeFullMask() {
        return this.partialCubeFullMask;
    }

    public String[] getIncludes() {
        return this.includes;
    }

    public SelectRule getSelectRule() {
        return this.selectRule;
    }

    public boolean isMandatoryOnlyValid() {
        return this.isMandatoryOnlyValid;
    }

    public CubeDesc getCubeDesc() {
        return this.cubeDesc;
    }

    public int getDimCap() {
        return this.selectRule.dimCap == null ? 0 : this.selectRule.dimCap;
    }

    public static class HierarchyMask
    implements Serializable {
        public long fullMask;
        public long[] allMasks;
        public long[] dims;
    }
}

