/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.common.livy;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.compress.utils.Lists;
import org.apache.kylin.common.livy.LivyRestBuilder;
import org.apache.kylin.common.livy.LivyRestClient;
import org.apache.kylin.common.livy.LivyStateEnum;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LivyRestExecutor {
    protected static final Logger logger = LoggerFactory.getLogger(LivyRestExecutor.class);

    public void execute(LivyRestBuilder livyRestBuilder, org.apache.kylin.common.util.Logger logAppender) {
        try {
            String statusResult;
            long startTime = System.currentTimeMillis();
            String dataJson = livyRestBuilder.build();
            logAppender.log("Livy submit Json: ");
            logAppender.log(dataJson + "\n");
            LivyRestClient restClient = new LivyRestClient();
            String result = restClient.livySubmitJobBatches(dataJson);
            JSONObject jsonObject = new JSONObject(result);
            String state = jsonObject.getString("state");
            logAppender.log("Livy submit Result: " + state);
            logger.info("Livy submit Result: {}", (Object)state);
            this.livyLog(jsonObject, logAppender);
            String livyTaskId = jsonObject.getString("id");
            while (!(LivyStateEnum.shutting_down.toString().equalsIgnoreCase(state) || LivyStateEnum.error.toString().equalsIgnoreCase(state) || LivyStateEnum.dead.toString().equalsIgnoreCase(state) || LivyStateEnum.success.toString().equalsIgnoreCase(state))) {
                statusResult = restClient.livyGetJobStatusBatches(livyTaskId);
                jsonObject = new JSONObject(statusResult);
                if (!state.equalsIgnoreCase(jsonObject.getString("state"))) {
                    logAppender.log("Livy status Result: " + jsonObject.getString("state"));
                    this.livyLog(jsonObject, logAppender);
                }
                state = jsonObject.getString("state");
                Thread.sleep(10000L);
            }
            if (!LivyStateEnum.success.toString().equalsIgnoreCase(state)) {
                statusResult = restClient.livyGetJobStatusBatches(livyTaskId);
                jsonObject = new JSONObject(statusResult);
                String detailErrorLog = String.join((CharSequence)"\n", this.getLogs(jsonObject));
                logAppender.log("livy start execute failed. state is " + state + ". log is " + detailErrorLog);
                logger.info("livy start execute failed. state is {}", (Object)(state + ". log is " + detailErrorLog));
                throw new RuntimeException("livy get status failed. state is " + state + ". log is " + detailErrorLog);
            }
            logAppender.log("costTime : " + (System.currentTimeMillis() - startTime) / 1000L + " s");
        }
        catch (Exception e) {
            logger.error("livy execute failed.", (Throwable)e);
            throw new RuntimeException("livy execute failed. \n" + e.getMessage());
        }
    }

    public String state(String batchId) {
        try {
            LivyRestClient restClient = new LivyRestClient();
            String statusResult = restClient.livyGetJobStatusBatches(batchId);
            JSONObject stateJson = new JSONObject(statusResult);
            return stateJson.getString("state");
        }
        catch (Exception e) {
            logger.error("livy execute failed.", (Throwable)e);
            return "";
        }
    }

    public Boolean kill(String batchId) {
        try {
            LivyRestClient restClient = new LivyRestClient();
            String statusResult = restClient.livyDeleteBatches(batchId);
            JSONObject stateJson = new JSONObject(statusResult);
            return stateJson.getString("msg").equalsIgnoreCase("deleted");
        }
        catch (Exception e) {
            logger.error("livy execute failed.", (Throwable)e);
            return false;
        }
    }

    private void livyLog(JSONObject logInfo, org.apache.kylin.common.util.Logger logger) {
        for (String log : this.getLogs(logInfo)) {
            logger.log(log);
        }
        logInfo.remove("log");
        logger.log(logInfo.toString());
    }

    private List<String> getLogs(JSONObject logInfo) {
        ArrayList logs = Lists.newArrayList();
        if (logInfo.has("log")) {
            try {
                JSONArray logArray = logInfo.getJSONArray("log");
                for (int i = 0; i < logArray.length(); ++i) {
                    logs.add(logArray.getString(i));
                }
            }
            catch (JSONException e) {
                logger.error("livy execute failed.", (Throwable)e);
            }
        }
        return logs;
    }
}

