/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.storage.hbase.steps;

import java.util.List;
import org.apache.kylin.cube.CubeSegment;
import org.apache.kylin.engine.spark.ISparkOutput;
import org.apache.kylin.job.execution.AbstractExecutable;
import org.apache.kylin.job.execution.DefaultChainedExecutable;
import org.apache.kylin.storage.hbase.steps.HBaseSparkSteps;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HBaseSparkOutputTransition
implements ISparkOutput {
    private static final Logger logger = LoggerFactory.getLogger(HBaseSparkOutputTransition.class);

    public ISparkOutput.ISparkBatchCubingOutputSide getBatchCubingOutputSide(CubeSegment seg) {
        final HBaseSparkSteps steps = new HBaseSparkSteps(seg);
        return new ISparkOutput.ISparkBatchCubingOutputSide(){

            public void addStepPhase2_BuildDictionary(DefaultChainedExecutable jobFlow) {
                jobFlow.addTask((AbstractExecutable)steps.createCreateHTableStep(jobFlow.getId()));
            }

            public void addStepPhase3_BuildCube(DefaultChainedExecutable jobFlow) {
                jobFlow.addTask(steps.createConvertCuboidToHfileStep(jobFlow.getId()));
                jobFlow.addTask((AbstractExecutable)steps.createBulkLoadStep(jobFlow.getId()));
            }

            public void addStepPhase4_Cleanup(DefaultChainedExecutable jobFlow) {
                steps.addCubingGarbageCollectionSteps(jobFlow);
            }
        };
    }

    public ISparkOutput.ISparkBatchMergeOutputSide getBatchMergeOutputSide(final CubeSegment seg) {
        return new ISparkOutput.ISparkBatchMergeOutputSide(){
            HBaseSparkSteps steps;
            {
                this.steps = new HBaseSparkSteps(seg);
            }

            public void addStepPhase1_MergeDictionary(DefaultChainedExecutable jobFlow) {
                jobFlow.addTask((AbstractExecutable)this.steps.createCreateHTableStep(jobFlow.getId()));
            }

            public void addStepPhase2_BuildCube(CubeSegment seg2, List<CubeSegment> mergingSegments, DefaultChainedExecutable jobFlow) {
                jobFlow.addTask(this.steps.createConvertCuboidToHfileStep(jobFlow.getId()));
                jobFlow.addTask((AbstractExecutable)this.steps.createBulkLoadStep(jobFlow.getId()));
            }

            public void addStepPhase3_Cleanup(DefaultChainedExecutable jobFlow) {
                this.steps.addMergingGarbageCollectionSteps(jobFlow);
            }
        };
    }

    public ISparkOutput.ISparkBatchOptimizeOutputSide getBatchOptimizeOutputSide(CubeSegment seg) {
        return null;
    }
}

