/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.storage.hbase.steps;

import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.lib.input.FileSplit;
import org.apache.hadoop.mapreduce.lib.input.SequenceFileInputFormat;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;
import org.apache.hadoop.mapreduce.lib.output.SequenceFileOutputFormat;
import org.apache.kylin.common.util.HadoopUtil;
import org.apache.kylin.cube.CubeInstance;
import org.apache.kylin.cube.CubeSegment;
import org.apache.kylin.cube.cuboid.CuboidModeEnum;
import org.apache.kylin.cube.cuboid.CuboidScheduler;
import org.apache.kylin.engine.mr.IMROutput2;
import org.apache.kylin.engine.mr.JobBuilderSupport;
import org.apache.kylin.engine.mr.common.AbstractHadoopJob;
import org.apache.kylin.engine.mr.common.MapReduceUtil;
import org.apache.kylin.engine.mr.steps.HiveToBaseCuboidMapper;
import org.apache.kylin.engine.mr.steps.InMemCuboidMapper;
import org.apache.kylin.engine.mr.steps.MergeCuboidJob;
import org.apache.kylin.engine.mr.steps.NDCuboidMapper;
import org.apache.kylin.job.execution.AbstractExecutable;
import org.apache.kylin.job.execution.DefaultChainedExecutable;
import org.apache.kylin.storage.hbase.steps.HBaseJobSteps;
import org.apache.kylin.storage.hbase.steps.HBaseMRSteps;
import org.apache.kylin.storage.hbase.steps.HBaseSparkSteps;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HBaseMROutput2Transition
implements IMROutput2 {
    private static final Logger logger = LoggerFactory.getLogger(HBaseMROutput2Transition.class);

    public IMROutput2.IMRBatchCubingOutputSide2 getBatchCubingOutputSide(CubeSegment seg) {
        boolean useSpark = seg.getCubeDesc().getEngineType() == 4;
        final HBaseJobSteps steps = useSpark ? new HBaseSparkSteps(seg) : new HBaseMRSteps(seg);
        return new IMROutput2.IMRBatchCubingOutputSide2(){

            public void addStepPhase2_BuildDictionary(DefaultChainedExecutable jobFlow) {
                jobFlow.addTask((AbstractExecutable)steps.createCreateHTableStep(jobFlow.getId()));
            }

            public void addStepPhase3_BuildCube(DefaultChainedExecutable jobFlow) {
                jobFlow.addTask(steps.createConvertCuboidToHfileStep(jobFlow.getId()));
                jobFlow.addTask((AbstractExecutable)steps.createBulkLoadStep(jobFlow.getId()));
            }

            public void addStepPhase4_Cleanup(DefaultChainedExecutable jobFlow) {
                steps.addCubingGarbageCollectionSteps(jobFlow);
            }

            public IMROutput2.IMROutputFormat getOutputFormat() {
                return new HBaseMROutputFormat();
            }
        };
    }

    public IMROutput2.IMRBatchMergeOutputSide2 getBatchMergeOutputSide(final CubeSegment seg) {
        return new IMROutput2.IMRBatchMergeOutputSide2(){
            HBaseMRSteps steps;
            {
                this.steps = new HBaseMRSteps(seg);
            }

            public void addStepPhase1_MergeDictionary(DefaultChainedExecutable jobFlow) {
                jobFlow.addTask((AbstractExecutable)this.steps.createCreateHTableStep(jobFlow.getId()));
            }

            public void addStepPhase2_BuildCube(CubeSegment seg2, List<CubeSegment> mergingSegments, DefaultChainedExecutable jobFlow) {
                jobFlow.addTask((AbstractExecutable)this.steps.createMergeCuboidDataStep(seg2, mergingSegments, jobFlow.getId(), MergeCuboidJob.class));
                jobFlow.addTask(this.steps.createConvertCuboidToHfileStep(jobFlow.getId()));
                jobFlow.addTask((AbstractExecutable)this.steps.createBulkLoadStep(jobFlow.getId()));
            }

            public void addStepPhase3_Cleanup(DefaultChainedExecutable jobFlow) {
                this.steps.addMergingGarbageCollectionSteps(jobFlow);
            }

            public IMROutput2.IMRMergeOutputFormat getOutputFormat() {
                return new HBaseMergeMROutputFormat();
            }
        };
    }

    public IMROutput2.IMRBatchOptimizeOutputSide2 getBatchOptimizeOutputSide(final CubeSegment seg) {
        return new IMROutput2.IMRBatchOptimizeOutputSide2(){
            HBaseMRSteps steps;
            {
                this.steps = new HBaseMRSteps(seg);
            }

            public void addStepPhase2_CreateHTable(DefaultChainedExecutable jobFlow) {
                jobFlow.addTask((AbstractExecutable)this.steps.createCreateHTableStep(jobFlow.getId(), CuboidModeEnum.RECOMMEND));
            }

            public void addStepPhase3_BuildCube(DefaultChainedExecutable jobFlow) {
                jobFlow.addTask(this.steps.createConvertCuboidToHfileStep(jobFlow.getId()));
                jobFlow.addTask((AbstractExecutable)this.steps.createBulkLoadStep(jobFlow.getId()));
            }

            public void addStepPhase4_Cleanup(DefaultChainedExecutable jobFlow) {
                this.steps.addOptimizeGarbageCollectionSteps(jobFlow);
            }

            public void addStepPhase5_Cleanup(DefaultChainedExecutable jobFlow) {
                this.steps.addCheckpointGarbageCollectionSteps(jobFlow);
            }
        };
    }

    public static class HBaseMergeMROutputFormat
    implements IMROutput2.IMRMergeOutputFormat {
        public void configureJobInput(Job job, String input) throws Exception {
            job.setInputFormatClass(SequenceFileInputFormat.class);
        }

        public void configureJobOutput(Job job, String output, CubeSegment segment) throws Exception {
            int reducerNum = MapReduceUtil.getLayeredCubingReduceTaskNum((CubeSegment)segment, (CuboidScheduler)segment.getCuboidScheduler(), (double)AbstractHadoopJob.getTotalMapInputMB((Job)job), (int)-1);
            job.setNumReduceTasks(reducerNum);
            Path outputPath = new Path(output);
            HadoopUtil.deletePath((Configuration)job.getConfiguration(), (Path)outputPath);
            FileOutputFormat.setOutputPath((Job)job, (Path)outputPath);
            job.setOutputFormatClass(SequenceFileOutputFormat.class);
        }

        public CubeSegment findSourceSegment(FileSplit fileSplit, CubeInstance cube) {
            String filePath = fileSplit.getPath().toString();
            String jobID = JobBuilderSupport.extractJobIDFromPath((String)filePath);
            return CubeInstance.findSegmentWithJobId((String)jobID, (CubeInstance)cube);
        }
    }

    public static class HBaseMROutputFormat
    implements IMROutput2.IMROutputFormat {
        public void configureJobInput(Job job, String input) throws Exception {
            job.setInputFormatClass(SequenceFileInputFormat.class);
        }

        public void configureJobOutput(Job job, String output, CubeSegment segment, CuboidScheduler cuboidScheduler, int level) throws Exception {
            int reducerNum = 1;
            Class mapperClass = job.getMapperClass();
            if (mapperClass == HiveToBaseCuboidMapper.class) {
                for (Map.Entry entry : segment.getConfig().getBaseCuboidMRConfigOverride().entrySet()) {
                    job.getConfiguration().set((String)entry.getKey(), (String)entry.getValue());
                }
            }
            if (mapperClass == HiveToBaseCuboidMapper.class || mapperClass == NDCuboidMapper.class) {
                reducerNum = MapReduceUtil.getLayeredCubingReduceTaskNum((CubeSegment)segment, (CuboidScheduler)cuboidScheduler, (double)AbstractHadoopJob.getTotalMapInputMB((Job)job), (int)level);
            } else if (mapperClass == InMemCuboidMapper.class) {
                reducerNum = MapReduceUtil.getInmemCubingReduceTaskNum((CubeSegment)segment, (CuboidScheduler)cuboidScheduler);
            }
            Path outputPath = new Path(output);
            FileOutputFormat.setOutputPath((Job)job, (Path)outputPath);
            job.setOutputFormatClass(SequenceFileOutputFormat.class);
            job.setNumReduceTasks(reducerNum);
            HadoopUtil.deletePath((Configuration)job.getConfiguration(), (Path)outputPath);
        }
    }
}

